/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentTracker {
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            boolean bl;
            Window window;
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 1L) != 0L) {
                window = SwingUtilities.getWindowAncestor(ComponentTracker.this.tracked);
                if (!Objects.equals(ComponentTracker.this.window, window)) {
                    Window window2 = ComponentTracker.this.window;
                    ComponentTracker.this.window = window;
                    ComponentTracker.this.windowIsDisplayable = window != null && window.isDisplayable();
                    ComponentTracker.this.windowChanged(window2, ComponentTracker.this.window);
                }
            }
            if ((l & 2L) != 0L && (window = SwingUtilities.getWindowAncestor(ComponentTracker.this.tracked)) != null && window == ComponentTracker.this.window && (bl = window.isDisplayable()) != ComponentTracker.this.windowIsDisplayable) {
                ComponentTracker.this.windowIsDisplayable = bl;
                ComponentTracker.this.windowChanged(ComponentTracker.this.window, ComponentTracker.this.window);
            }
            if ((l & 4L) != 0L) {
                ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
            }
        }
    };
    private final HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    private final ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ComponentTracker.this.visibleBoundsChanged(ComponentTracker.this.window);
        }
    };
    private Component tracked;
    private Window window;
    private boolean windowIsDisplayable;

    public void attach(@Nullable JComponent jComponent) {
        if (this.tracked != jComponent) {
            if (this.tracked != null) {
                Window window = this.window;
                this.tracked.removeHierarchyListener(this.hierarchyListener);
                this.tracked.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.removeComponentListener(this.componentListener);
                this.tracked = null;
                this.window = null;
                this.windowIsDisplayable = false;
                this.detached(window);
            }
            if (jComponent != null) {
                this.tracked = jComponent;
                this.tracked.addHierarchyListener(this.hierarchyListener);
                this.tracked.addHierarchyBoundsListener(this.hierarchyBoundsListener);
                this.tracked.addComponentListener(this.componentListener);
                this.window = SwingUtilities.getWindowAncestor(this.tracked);
                this.windowIsDisplayable = this.window != null && this.window.isDisplayable();
                this.attached(this.window);
            }
        }
    }

    protected void detached(@Nullable Window window) {
    }

    protected void attached(@Nullable Window window) {
    }

    protected void windowChanged(@Nullable Window window, @Nullable Window window2) {
    }

    protected void visibleBoundsChanged(@Nullable Window window) {
    }
}

