/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComboBoxRendererInternal;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.ColumnView;
import org.violetlib.aqua.fc.FileChooserView;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileRenderer;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.FileTransferHandler;
import org.violetlib.aqua.fc.FilenameDocument;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.ListView;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SavedSearchFileSystemTreeModel;
import org.violetlib.aqua.fc.SidebarTreeModel;
import org.violetlib.aqua.fc.SidebarTreeNode;
import org.violetlib.aqua.fc.SubtreeTreeModel;
import org.violetlib.aqua.fc.ViewModeControl;

public class AquaFileChooserUI
extends BasicFileChooserUI
implements AquaComponentUI {
    public static final String PACKAGE_TRAVERSABLE_PROPERTY = "JFileChooser.packageIsTraversable";
    public static final String APPLICATION_TRAVERSABLE_PROPERTY = "JFileChooser.appBundleIsTraversable";
    private JFileChooser fc;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private Action optionsAction = new OptionsAction();
    private FileView fileView;
    private FilterComboBoxModel filterComboBoxModel;
    private FileSystemTreeModel model = null;
    private SubtreeTreeModel subtreeModel = null;
    private static final boolean isOptionsAvailable = OSXSystemProperties.OSVersion >= 1011;
    private boolean isOptionsEnabled = !isOptionsAvailable;
    @Nullable
    private String windowStyle;
    private boolean useToolBar;
    private Map<File, FileSystemTreeModel> savedSearches;
    private FileSystemTreeModel fileSystemModel = null;
    protected String optionsButtonText = null;
    protected String optionsButtonToolTipText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private String newFolderButtonText = null;
    private String newFolderToolTipText = null;
    protected String chooseButtonText = null;
    private String newFolderDialogPrompt;
    private String newFolderDefaultName;
    private String newFolderErrorText;
    private String newFolderExistsErrorText;
    private String newFolderTitleText;
    private String goToFolderDialogPrompt;
    private String goToFolderCancelButtonText;
    private String goToFolderAcceptButtonText;
    private String goToFolderErrorText;
    private String defaultInitialSaveFileName;
    private SidebarTreeModel sidebarTreeModel;
    private HierarchyListener hierarchyListener;
    private FileTransferHandler fileTransferHandler;
    private Action newFolderAction = new NewFolderAction();
    private Action approveSelectionAction = new AquaApproveSelectionAction();
    private int isAdjusting = 0;
    private int viewMode = 2;
    private boolean isViewInstalled;
    private FileChooserView activeView;
    private boolean isRecursiveLayoutCall;
    private static String goToFolderText = "";
    private KeyStroke[] KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(65, 5), KeyStroke.getKeyStroke(67, 5), KeyStroke.getKeyStroke(68, 4), KeyStroke.getKeyStroke(68, 5), KeyStroke.getKeyStroke(71, 5), KeyStroke.getKeyStroke(72, 5), KeyStroke.getKeyStroke(73, 5), KeyStroke.getKeyStroke(79, 5), KeyStroke.getKeyStroke(75, 5), KeyStroke.getKeyStroke(85, 5), KeyStroke.getKeyStroke(46, 5)};
    private AbstractAction keyListenerAction = new KeyListenerAction();
    protected TopPanel topPanel;
    protected SavePanel savePanel;
    protected JPanel fileNameLine;
    protected JLabel fileNameLabel;
    protected JTextField fileNameTextField;
    protected JPanel fileNameSpringPanel;
    protected JSeparator separator;
    protected NavigationPanel navigationPanel;
    protected ViewModeControl viewModeControl;
    protected JComboBox directoryComboBox;
    protected JSplitPane splitPane;
    protected JScrollPane sidebarScrollPane;
    protected JPanel viewsPanel;
    protected JPanel controlsPanel;
    protected OptionsPanel optionsPanel;
    protected JPanel accessoryPanel;
    protected JPanel formatPanel;
    protected JLabel filesOfTypeLabel;
    protected JComboBox filterComboBox;
    protected JPanel formatSpringPanel;
    protected JSeparator optionsSeparator;
    protected ButtonPanel buttonsPanel;
    protected JButton newFolderButton;
    protected JButton optionsButton;
    protected JButton cancelButton;
    protected JButton approveButton;
    protected ListView listView;
    protected ColumnView columnView;
    protected JTree sidebarTree;
    protected final int SELECT_DIRECTORY_FROM_API = 1;
    protected final int SELECT_DIRECTORY_FROM_COMBO_BOX = 2;
    protected final int SELECT_DIRECTORY_BY_DOUBLE_CLICK = 3;
    protected final int SELECT_DIRECTORY_BY_KEYSTROKE = 4;
    protected final int SELECT_DIRECTORY_FROM_SIDEBAR = 5;
    protected final int SELECT_DIRECTORY_TO_INITIALIZE = 6;
    protected final int SELECT_DIRECTORY_NEW_VIEW = 7;
    static final int space = 10;

    protected void requestFileSelectionPath(String string) {
        Window window = SwingUtilities.getWindowAncestor(this.fc);
        String string2 = this.goToFolderDialogPrompt;
        String string3 = this.goToFolderCancelButtonText;
        String string4 = this.goToFolderAcceptButtonText;
        String string5 = this.goToFolderErrorText;
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window) : new JDialog((Dialog)window);
        RequestFileSelectionPathPane requestFileSelectionPathPane = new RequestFileSelectionPathPane(jDialog, string, string2, string3, string4, string5){

            @Override
            protected void canceled() {
            }

            @Override
            protected void accepted() {
                File file = this.getSelection();
                if (file.isDirectory()) {
                    AquaFileChooserUI.this.selectDirectory(file, 4, null);
                } else if (AquaFileChooserUI.this.isAcceptable(file)) {
                    AquaFileChooserUI.this.fc.setSelectedFile(file);
                }
            }
        };
        requestFileSelectionPathPane.setBorder(new EmptyBorder(20, 15, 10, 15));
        requestFileSelectionPathPane.setComponentOrientation(window.getComponentOrientation());
        jDialog.setContentPane(requestFileSelectionPathPane);
        jDialog.pack();
        AquaSheetSupport.displayAsSheet(jDialog, null);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaFileChooserUI((JFileChooser)jComponent);
    }

    public AquaFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.fc = (JFileChooser)jComponent;
        super.installUI(jComponent);
        this.installSelectedView(false, true);
    }

    private void configureTopPanel() {
        if (this.fc.getDialogType() == 1) {
            this.navigationPanel.setToolBar(this.useToolBar);
            this.topPanel.setToolBar(false);
        } else {
            this.navigationPanel.setToolBar(false);
            this.topPanel.setToolBar(this.useToolBar);
        }
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        boolean bl;
        int n;
        Component[] componentArray;
        this.sidebarTree = new SidebarTree();
        ChangeListener changeListener = this.createViewSelectionChangeListener(jFileChooser);
        FileChooserView.SelectListener selectListener = this.createViewSelectListener(jFileChooser);
        this.topPanel = new TopPanel();
        this.savePanel = new SavePanel();
        this.fileNameLine = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = this.createTextField("File Name Text Field");
        this.fileNameSpringPanel = new JPanel();
        this.separator = this.createSeparator();
        this.navigationPanel = new NavigationPanel();
        this.directoryComboBox = this.createDirectoryComboBox();
        this.splitPane = new JSplitPane();
        this.sidebarScrollPane = new JScrollPane();
        this.viewsPanel = new JPanel();
        this.columnView = ColumnView.create(jFileChooser);
        this.viewModeControl = ViewModeControl.create();
        this.listView = ListView.create(jFileChooser);
        this.controlsPanel = new ControlsPanel();
        this.optionsSeparator = this.createOptionsSeparator();
        this.optionsPanel = new OptionsPanel();
        this.accessoryPanel = new JPanel();
        this.formatPanel = new JPanel();
        this.filesOfTypeLabel = new JLabel();
        this.filterComboBox = this.createComboBox();
        this.formatSpringPanel = new JPanel();
        this.buttonsPanel = new ButtonPanel();
        this.newFolderButton = this.createButton();
        this.optionsButton = this.createButton();
        this.cancelButton = this.createButton();
        this.approveButton = this.createButton();
        GroupLayout groupLayout = new GroupLayout(jFileChooser);
        jFileChooser.setLayout(groupLayout);
        this.fileNameLine.setLayout(new GridBagLayout());
        this.fileNameLabel.setHorizontalAlignment(4);
        this.fileNameLabel.setText("Save As:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.fileNameLine.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.fileNameLine.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileNameSpringPanel.setLayout(null);
        this.fileNameSpringPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.fileNameLine.add((Component)this.fileNameSpringPanel, gridBagConstraints);
        if (OSXSystemProperties.OSVersion >= 1013) {
            this.fileNameLine.setBorder(new EmptyBorder(5, 0, 7, 0));
        } else if (OSXSystemProperties.OSVersion >= 1011) {
            this.fileNameLine.setBorder(new EmptyBorder(12, 0, 7, 0));
        } else {
            this.fileNameLine.setBorder(new EmptyBorder(12, 0, 14, 0));
        }
        this.savePanel.add(this.fileNameLine);
        if (OSXSystemProperties.OSVersion != 1013) {
            this.savePanel.add(this.separator);
        }
        this.viewsPanel.setLayout(new CardLayout());
        this.viewsPanel.add((Component)this.columnView, "browser");
        this.columnView.addSelectionChangeListener(changeListener);
        this.columnView.addSelectListener(selectListener);
        if (this.viewModeControl != null && this.listView != null) {
            this.listView.addSelectionChangeListener(changeListener);
            this.listView.addSelectListener(selectListener);
            this.viewModeControl.setAlignmentY(0.5f);
            this.navigationPanel.add(this.viewModeControl);
            this.navigationPanel.add(Box.createHorizontalGlue());
            this.viewModeControl.addChangeListener(new ViewModeChangeListener());
            this.viewsPanel.add((Component)this.listView, "list");
        }
        this.navigationPanel.add(this.directoryComboBox);
        this.navigationPanel.add(Box.createHorizontalGlue());
        this.navigationPanel.add(Box.createRigidArea(new Dimension(42, 0)));
        this.configureTopPanel();
        this.topPanel.add(this.savePanel);
        this.topPanel.add(this.navigationPanel);
        int n2 = UIManager.getInt("FileChooser.sideBarWidth");
        int n3 = n2 > 0 ? n2 : 134;
        this.sidebarScrollPane.setMinimumSize(new Dimension(n3, 0));
        this.splitPane.setDividerLocation(n3);
        this.splitPane.putClientProperty("JSplitPane.style", "thin");
        this.sidebarScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarTree.setRootVisible(false);
        this.sidebarTree.setShowsRootHandles(true);
        this.sidebarScrollPane.setViewportView(this.sidebarTree);
        this.sidebarScrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.style", "sidebar");
        this.splitPane.setLeftComponent(this.sidebarScrollPane);
        this.splitPane.setRightComponent(this.viewsPanel);
        this.accessoryPanel.setLayout(new BorderLayout());
        this.optionsPanel.add(this.accessoryPanel);
        this.controlsPanel.add(this.optionsPanel);
        this.accessoryPanel.setOpaque(false);
        this.formatPanel.setOpaque(false);
        this.buttonsPanel.setOpaque(false);
        this.formatPanel.setLayout(new GridBagLayout());
        this.formatPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
        this.filesOfTypeLabel.setHorizontalAlignment(4);
        this.filesOfTypeLabel.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.formatPanel.add((Component)this.filesOfTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        this.formatPanel.add((Component)this.filterComboBox, gridBagConstraints);
        this.formatSpringPanel.setLayout(null);
        this.formatSpringPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.formatPanel.add((Component)this.formatSpringPanel, gridBagConstraints);
        this.optionsPanel.add(this.formatPanel);
        this.optionsPanel.add(this.optionsSeparator);
        this.newFolderButton.setText("New Folder");
        this.optionsButton.setText("Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.buttonsPanel.add((Component)this.optionsButton, gridBagConstraints);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.cancelButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(8));
        this.buttonsPanel.add(this.approveButton);
        this.controlsPanel.add(this.buttonsPanel);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.topPanel, -2, -2, -2).addComponent(this.splitPane, -1, -2, Short.MAX_VALUE).addComponent(this.controlsPanel, -2, -2, -2));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this.topPanel, -1, -2, Short.MAX_VALUE).addComponent(this.splitPane, -1, -2, Short.MAX_VALUE).addComponent(this.controlsPanel, -1, -2, Short.MAX_VALUE));
        this.separator.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 0, 3, 0));
        TreeUI treeUI = this.createSidebarTreeUI();
        this.sidebarTree.setUI(treeUI);
        this.sidebarTree.putClientProperty("JTree.style", "sideBar");
        this.sidebarTree.setSelectionModel(new SidebarTreeSelectionModel());
        InputMap inputMap = this.sidebarTree.getInputMap(0).getParent();
        Serializable serializable = KeyStroke.getKeyStroke("shift meta A");
        Object object = inputMap.get((KeyStroke)serializable);
        if (object != null && object.equals("clearSelection")) {
            componentArray = new InputMap();
            componentArray.setParent(inputMap);
            componentArray.put((KeyStroke)serializable, "selectApplicationsFolder");
            SwingUtilities.replaceUIInputMap(this.sidebarTree, 0, (InputMap)componentArray);
        }
        if ((n = UIManager.getInt("FileChooser.sideBarRowHeight")) > 0) {
            this.sidebarTree.setRowHeight(n);
        }
        n = this.fileNameLabel.getPreferredSize().height;
        this.fileNameLabel.setMinimumSize(new Dimension(0, n));
        this.fileNameLabel.setPreferredSize(new Dimension(0, n));
        this.fileNameLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        n = this.fileNameTextField.getPreferredSize().height;
        this.fileNameTextField.setPreferredSize(new Dimension(0, n));
        this.fileNameTextField.setMinimumSize(new Dimension(0, n));
        this.fileNameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        n = this.filesOfTypeLabel.getPreferredSize().height;
        this.filesOfTypeLabel.setMinimumSize(new Dimension(0, n));
        this.filesOfTypeLabel.setPreferredSize(new Dimension(0, n));
        this.filesOfTypeLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        n = this.filterComboBox.getPreferredSize().height;
        this.filterComboBox.setPreferredSize(new Dimension(0, n));
        this.filterComboBox.setMinimumSize(new Dimension(0, n));
        this.filterComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
        serializable = new FileRenderer(jFileChooser);
        this.columnView.setFileRenderer((GenericCellRenderer)((Object)serializable));
        this.columnView.setMultipleSelection(this.isMultipleSelection());
        if (this.listView != null) {
            this.listView.setFileRenderer((GenericCellRenderer)((Object)serializable));
            this.listView.setMultipleSelection(this.isMultipleSelection());
        }
        this.columnView.setModel(this.subtreeModel);
        if (this.listView != null) {
            this.listView.setModel(this.subtreeModel);
        }
        this.sidebarScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.installChoosableFileFilters(jFileChooser.getChoosableFileFilters());
        this.installAccessory(jFileChooser.getAccessory());
        this.newFolderButton.setText(this.newFolderButtonText);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.fileNameLabel.setText(this.fileNameLabelText);
        this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.optionsButton.setText(this.optionsButtonText);
        this.optionsButton.setToolTipText(this.optionsButtonToolTipText);
        this.optionsButton.addActionListener(this.optionsAction);
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        object = this.optionsButton.getPreferredSize();
        componentArray = this.cancelButton.getPreferredSize();
        Dimension dimension = this.approveButton.getPreferredSize();
        int n4 = Math.max(Math.max(Math.max(((Dimension)object).width, componentArray.width), dimension.width), 69);
        this.optionsButton.setPreferredSize(new Dimension(n4, ((Dimension)object).height));
        this.cancelButton.setPreferredSize(new Dimension(n4, componentArray.height));
        this.approveButton.setPreferredSize(new Dimension(n4, dimension.height));
        this.newFolderButton.setMargin(new Insets(0, 10, 0, 10));
        if (!jFileChooser.getControlButtonsAreShown()) {
            this.optionsButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.approveButton.setVisible(false);
        }
        this.fileNameTextField.setDocument(new FilenameDocument());
        if (this.defaultInitialSaveFileName != null) {
            this.setFileNameTextField(this.defaultInitialSaveFileName);
        }
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(this.directoryComboBox));
        this.sidebarTreeModel = new SidebarTreeModel(jFileChooser, new TreePath(this.model.getRoot()), this.model);
        this.sidebarTree.setModel(this.sidebarTreeModel);
        this.sidebarTree.setCellRenderer(this.createSidebarCellRenderer(jFileChooser));
        for (int i = this.sidebarTree.getRowCount() - 1; i >= 0; --i) {
            this.sidebarTree.expandRow(i);
        }
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer(this.filterComboBox));
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.fileNameTextField.addFocusListener(new SaveTextFocusListener());
        this.fileNameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.sidebarTree.addTreeSelectionListener(this.createSidebarSelectionListener(jFileChooser));
        this.sidebarScrollPane.setFocusable(false);
        this.sidebarScrollPane.getVerticalScrollBar().setFocusable(false);
        this.sidebarScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.fileTransferHandler = new FileTransferHandler(jFileChooser);
        TextKeyListener textKeyListener = new TextKeyListener();
        componentArray = new Component[]{jFileChooser, this.accessoryPanel, this.approveButton, this.columnView, this.buttonsPanel, this.optionsButton, this.cancelButton, this.controlsPanel, this.directoryComboBox, this.fileNameLabel, this.savePanel, this.fileNameSpringPanel, this.fileNameTextField, this.filesOfTypeLabel, this.filterComboBox, this.formatPanel, this.formatSpringPanel, this.listView, this.navigationPanel, this.newFolderButton, this.separator, this.splitPane, this.viewModeControl, this.viewsPanel, this.sidebarTree, this.sidebarScrollPane};
        for (bl = false; bl < componentArray.length; bl += 1) {
            Component component = componentArray[bl];
            if (component == null) continue;
            new DropTarget(component, 1, this.fileTransferHandler);
            component.addKeyListener(textKeyListener);
        }
        bl = jFileChooser.getDialogType() == 1 || jFileChooser.getDialogType() == 2;
        this.fileNameTextField.setEnabled(bl);
        this.savePanel.setVisible(bl);
        this.doPreviewComponentChanged(null);
        this.updateApproveButtonState();
        this.updateOptionsPanel();
        n4 = 223;
        this.splitPane.setPreferredSize(new Dimension(n3 + 2 * n4, 298));
        this.splitPane.setMaximumSize(new Dimension(100000, 100000));
        ActionMap actionMap = jFileChooser.getActionMap();
        InputMap inputMap2 = jFileChooser.getInputMap(2);
        for (KeyStroke keyStroke : this.KEYSTROKES) {
            if ((keyStroke.getModifiers() & 4) != 0) {
                inputMap2.put(keyStroke, keyStroke);
            }
            actionMap.put(keyStroke, this.keyListenerAction);
        }
        Dimension dimension2 = jFileChooser.getPreferredSize();
        jFileChooser.setBounds(0, 0, dimension2.width, dimension2.height);
        jFileChooser.doLayout();
    }

    protected TreeUI createSidebarTreeUI() {
        return new SidebarTreeUI();
    }

    protected JTextField createTextField(final String string) {
        JTextField jTextField = new JTextField(){

            @Override
            public String toString() {
                return string;
            }
        };
        jTextField.setOpaque(false);
        return jTextField;
    }

    protected JButton createButton() {
        return this.createButton(null);
    }

    protected JButton createButton(String string) {
        JButton jButton = new JButton(string);
        return jButton;
    }

    protected JComboBox createDirectoryComboBox() {
        return new DirectoryComboBox();
    }

    protected JComboBox createComboBox() {
        JComboBox jComboBox = new JComboBox();
        return jComboBox;
    }

    protected JSeparator createSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBorder(AquaLookAndFeel.NOTHING_BORDER);
        return jSeparator;
    }

    protected JSeparator createOptionsSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBorder(AquaLookAndFeel.NOTHING_BORDER);
        return jSeparator;
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.fileSystemModel.dispose();
        for (FileSystemTreeModel fileSystemTreeModel : this.savedSearches.values()) {
            fileSystemTreeModel.dispose();
        }
        this.optionsButton.removeActionListener(this.optionsAction);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.hierarchyListener = this.createHierarchyListener(jFileChooser);
        if (this.hierarchyListener != null) {
            jFileChooser.addHierarchyListener(this.hierarchyListener);
        }
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        AppearanceManager.installListener(jFileChooser);
    }

    @Override
    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        AppearanceManager.uninstallListener(jFileChooser);
        if (this.hierarchyListener != null) {
            jFileChooser.removeHierarchyListener(this.hierarchyListener);
        }
        jFileChooser.removePropertyChangeListener(this.filterComboBoxModel);
    }

    private Locale getLocale() {
        try {
            return this.fc.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return Locale.getDefault();
        }
    }

    @Override
    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        boolean bl = OSXSystemProperties.isShowAllFiles();
        jFileChooser.setFileHidingEnabled(!bl);
        this.setPackageTraversable(UIManager.getBoolean(PACKAGE_TRAVERSABLE_PROPERTY));
        this.setApplicationTraversable(UIManager.getBoolean(APPLICATION_TRAVERSABLE_PROPERTY));
    }

    @Override
    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale;
        super.installStrings(jFileChooser);
        try {
            locale = this.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            locale = Locale.getDefault();
        }
        this.chooseButtonText = UIManager.getString("FileChooser.chooseButtonText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.optionsButtonText = UIManager.getString("FileChooser.optionsButtonText");
        this.optionsButtonToolTipText = UIManager.getString("FileChooser.optionsToolTipText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelToolTipText");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", locale, "Error occurred during folder creation");
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", locale, "That name is already taken");
        this.newFolderButtonText = this.getString("FileChooser.newFolderButtonText", locale, "New Folder");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", locale, "New Folder");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", locale, "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", locale, "untitled folder");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.goToFolderDialogPrompt = this.getString("FileChooser.goToFolderPromptText", locale, "Go to the folder:");
        this.goToFolderCancelButtonText = this.getString("FileChooser.goToFolderCancelButtonText", locale, "Cancel");
        this.goToFolderAcceptButtonText = this.getString("FileChooser.goToFolderAcceptButtonText", locale, "Accept");
        this.goToFolderErrorText = this.getString("FileChooser.goToFolderErrorText", locale, "The folder can\u2019t be found.");
        this.defaultInitialSaveFileName = this.getString("FileChooser.defaultSaveFileName", locale, "Untitled");
    }

    @Override
    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    private String getString(String string, Locale locale, String string2) {
        String string3 = UIManager.getString(string);
        return string3 == null ? string2 : string3;
    }

    protected HierarchyListener createHierarchyListener(JFileChooser jFileChooser) {
        return new FileChooserHierarchyListener();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.reconfigureChooser();
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.reconfigure(this.optionsPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.isRecursiveLayoutCall) {
            return null;
        }
        this.isRecursiveLayoutCall = true;
        try {
            Dimension dimension = jComponent.getPreferredSize();
            if (!this.optionsPanel.isVisible()) {
                Dimension dimension2 = this.optionsPanel.getPreferredSize();
                Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
                return dimension3;
            }
            Dimension dimension4 = dimension;
            return dimension4;
        }
        finally {
            this.isRecursiveLayoutCall = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isRecursiveLayoutCall) {
            return null;
        }
        this.isRecursiveLayoutCall = true;
        try {
            Dimension dimension = jComponent.getMinimumSize();
            if (!this.optionsPanel.isVisible()) {
                Dimension dimension2 = this.optionsPanel.getMinimumSize();
                Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
                return dimension3;
            }
            Dimension dimension4 = dimension;
            return dimension4;
        }
        finally {
            this.isRecursiveLayoutCall = false;
        }
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(100000, 100000);
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int n) {
        if ((n == 2 || this.listView != null && n == 1) && n != this.viewMode) {
            this.viewMode = n;
            this.installSelectedView(false, false);
            if (this.activeView != null) {
                this.activeView.requestFocusInWindow();
            }
        }
    }

    private void installSelectedView(boolean bl, boolean bl2) {
        if (!this.fc.isShowing() && !bl) {
            this.isViewInstalled = false;
        } else {
            FileChooserView fileChooserView;
            this.isViewInstalled = true;
            CardLayout cardLayout = (CardLayout)this.viewsPanel.getLayout();
            FileChooserView fileChooserView2 = this.getViewForMode(this.viewMode);
            if (fileChooserView2 != (fileChooserView = this.activeView)) {
                if (fileChooserView != null) {
                    fileChooserView.setActive(false);
                }
                this.activeView = fileChooserView2;
                String string = this.getViewNameForMode(this.viewMode);
                cardLayout.show(this.viewsPanel, string);
                this.activeView.setActive(true);
                bl2 = true;
            }
            if (bl2) {
                this.activeView.reconfigure();
                this.model.invalidateAll();
            }
            int n = fileChooserView != null ? 7 : 6;
            this.updateSelection(n);
        }
    }

    private FileChooserView getViewForMode(int n) {
        if (n == 1) {
            return this.listView;
        }
        return this.columnView;
    }

    private String getViewNameForMode(int n) {
        if (n == 1) {
            return "list";
        }
        return "browser";
    }

    @Override
    public void createModel() {
        this.fc.setFileSystemView(AquaFileSystemView.getAquaFileSystemView());
        this.fileView = UIManager.getBoolean("FileChooser.speed") ? new BasicFileChooserUI.BasicFileView(this) : AquaFileSystemView.getAquaFileSystemView().createFileView(this.fc);
        this.fc.setFileView(this.fileView);
        this.model = this.fileSystemModel = new FileSystemTreeModel(this.fc);
        this.subtreeModel = new SubtreeTreeModel(this.model);
        this.savedSearches = new HashMap<File, FileSystemTreeModel>();
    }

    public FileSystemTreeModel getSavedSearchTreeModel(File file) {
        FileSystemTreeModel fileSystemTreeModel = this.savedSearches.get(file);
        if (fileSystemTreeModel == null) {
            fileSystemTreeModel = this.createSavedSearchTreeModel(file);
            this.savedSearches.put(file, fileSystemTreeModel);
        }
        return fileSystemTreeModel;
    }

    protected FileSystemTreeModel createSavedSearchTreeModel(File file) {
        return new SavedSearchFileSystemTreeModel(this.fc, file);
    }

    private void updateSelection(final int n) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Object object2;
        if (this.activeView == null) {
            return;
        }
        List<File> list = null;
        TreePath treePath = null;
        if (this.fc.getDialogType() == 1 && this.fileNameTextField != null && this.isFileNameFieldVisible() && !(list = this.getChooserSelection()).isEmpty()) {
            object2 = list.get(0);
            list.clear();
            serializable2 = ((File)object2).getParentFile();
            if (this.fc.isTraversable((File)serializable2)) {
                list.add((File)serializable2);
                treePath = this.model.toPath((File)serializable2, null);
                ++this.isAdjusting;
                this.setFileName(((File)object2).getName());
                --this.isAdjusting;
            }
        }
        if (list == null) {
            list = this.getNormalizedChooserSelection();
        }
        object2 = list;
        serializable2 = new ArrayList(list.size());
        TreePath treePath2 = null;
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            serializable = this.model.toPath((File)object, null);
            if (i == 0) {
                treePath2 = serializable.getParentPath();
            } else {
                TreePath treePath3 = serializable.getParentPath();
                if (!AquaFileChooserUI.Object_equals(treePath2, treePath3)) continue;
            }
            serializable2.add(serializable);
        }
        if (treePath == null) {
            treePath = treePath2;
        }
        if (treePath != null) {
            Runnable runnable = new Runnable((List)((Object)serializable2), (List)object2){
                final /* synthetic */ List val$list;
                final /* synthetic */ List val$originalFiles;
                {
                    this.val$list = list;
                    this.val$originalFiles = list2;
                }

                @Override
                public void run() {
                    List list = AquaFileChooserUI.this.getSubtreePaths(this.val$list);
                    AquaFileChooserUI.this.setViewSelection(list);
                    AquaFileChooserUI.this.finishUpdateSelection(this.val$originalFiles, this.val$list);
                }
            };
            object = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
            serializable = object != null ? ((FileSystemTreeModel.Node)object).getResolvedFile() : new File("/");
            SwingUtilities.invokeLater(new Runnable((File)serializable, n, runnable){
                final /* synthetic */ File val$dir;
                final /* synthetic */ int val$source;
                final /* synthetic */ Runnable val$r;
                {
                    this.val$dir = file;
                    this.val$source = n;
                    this.val$r = runnable;
                }

                @Override
                public void run() {
                    AquaFileChooserUI.this.selectDirectory(this.val$dir, this.val$source, this.val$r);
                }
            });
        } else {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.updateSelectedFiles(null);
                    AquaFileChooserUI.this.updateApproveButtonState();
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    File file = AquaFileChooserUI.this.fc.getCurrentDirectory();
                    AquaFileChooserUI.this.selectDirectory(file, n, runnable);
                }
            });
        }
    }

    private void finishUpdateSelection(List<File> list, List<TreePath> list2) {
        if (list.size() != list2.size()) {
            int n = list2.size();
            ArrayList<File> arrayList = new ArrayList<File>(n);
            for (TreePath treePath : list2) {
                File file = ((FileInfo)treePath.getLastPathComponent()).getFile();
                arrayList.add(file);
            }
            this.updateSelectedFiles(arrayList);
        }
        this.updateApproveButtonState();
    }

    private List<TreePath> getSubtreePaths(List<TreePath> list) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (TreePath treePath : list) {
            TreePath treePath2 = this.subtreeModel.toSubPath(treePath);
            if (treePath2 == null) continue;
            arrayList.add(treePath2);
        }
        return arrayList;
    }

    private TreePath getSubtreePath(File file) {
        TreePath treePath;
        if (file != null && (treePath = this.model.toPath(file, this.subtreeModel.getPathToRoot())) != null) {
            return this.subtreeModel.toSubPath(treePath);
        }
        return null;
    }

    public static boolean Object_equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private boolean isFileNameFieldValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    private boolean isFileNameFieldVisible() {
        return this.fc.getDialogType() == 1 || this.fc.getDialogType() == 2;
    }

    private void updateApproveButtonState() {
        if (this.fc.getControlButtonsAreShown()) {
            boolean bl = this.computeApproveButtonEnabled();
            this.setApproveButtonEnabled(bl);
        }
    }

    private boolean computeApproveButtonEnabled() {
        if (this.fc.getDialogType() == 1) {
            return this.isAcceptableSaveDialogState();
        }
        if (this.isFileNameFieldVisible() && this.isFileNameFieldValid() && this.fc.getFileSelectionMode() == 0) {
            return true;
        }
        List<File> list = this.getChooserSelection();
        if (list.isEmpty()) {
            return this.fc.isDirectorySelectionEnabled() && this.isAcceptable(this.fc.getCurrentDirectory());
        }
        for (File file : list) {
            if (this.isAcceptable(file)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableSaveDialogState() {
        File file = this.fc.getCurrentDirectory();
        if (file == null || !file.isDirectory()) {
            return false;
        }
        return this.isFileNameFieldValid();
    }

    private boolean isSelected(File file) {
        File[] fileArray;
        if (file != null && (fileArray = this.fc.getSelectedFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file.equals(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAcceptable(File file) {
        FileInfo fileInfo;
        Object object;
        if (file == null) {
            return false;
        }
        TreePath treePath = this.model.toPath(file, null);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof FileInfo && (fileInfo = (FileInfo)object).getFile().equals(file)) {
            return fileInfo.isAcceptable();
        }
        return false;
    }

    private boolean isMultipleSelection() {
        return this.fc != null && this.fc.isMultiSelectionEnabled() && this.fc.getDialogType() != 1;
    }

    private void setApproveButtonEnabled(boolean bl) {
        if (this.fc.getControlButtonsAreShown()) {
            JRootPane jRootPane;
            this.approveButton.setEnabled(bl);
            if (bl && (jRootPane = this.approveButton.getRootPane()) != null) {
                jRootPane.setDefaultButton(this.approveButton);
            }
        }
    }

    private void updateApproveButtonText() {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.fc));
    }

    private void respondToUISelectionChange() {
        Object object;
        List<TreePath> list = this.getNormalizedUISelection();
        if (this.viewMode == 2 && (object = this.getColumnViewCurrentDirectoryPath(list)) != null) {
            this.updateCurrentDirectory((TreePath)object);
            this.updateComboBoxModel((TreePath)object);
        }
        object = this.getFileSelectionFromViewSelection(list);
        this.installSelectedFiles((List<File>)object);
        if (!list.isEmpty()) {
            TreePath treePath = list.get(0);
            this.model.lazyInvalidatePath(treePath);
            if (this.fc.isDisplayable()) {
                this.model.validatePath(treePath);
            }
        }
        this.updateApproveButtonState();
    }

    private TreePath getColumnViewCurrentDirectoryPath(List<TreePath> list) {
        if (list.isEmpty()) {
            return null;
        }
        TreePath treePath = list.get(0);
        FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
        if (list.size() == 1 && fileInfo.isTraversable()) {
            return treePath;
        }
        return treePath.getParentPath();
    }

    private List<File> getFileSelectionFromViewSelection(List<TreePath> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (TreePath treePath : list) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
            if (list.size() == 1 && !node.isAcceptable()) {
                return new ArrayList<File>();
            }
            File file = node.getFile();
            arrayList.add(file);
        }
        return arrayList;
    }

    private void updateCurrentDirectory(TreePath treePath) {
        if (this.isAdjusting == 0) {
            FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
            File file = fileInfo.getResolvedFile();
            File file2 = this.fc.getCurrentDirectory();
            if (!AquaFileChooserUI.Object_equals(file2, file)) {
                ++this.isAdjusting;
                this.fc.setSelectedFiles(null);
                this.fc.setCurrentDirectory(file);
                --this.isAdjusting;
            }
        }
    }

    private void updateSelectedFile(File file) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            if (this.isMultipleSelection()) {
                this.fc.setSelectedFiles(new File[]{file});
            } else {
                this.fc.setSelectedFile(file);
            }
            --this.isAdjusting;
        }
    }

    private void updateSelectedFiles(List<File> list) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            if (this.isMultipleSelection()) {
                File[] fileArray = list != null ? list.toArray(new File[list.size()]) : null;
                this.fc.setSelectedFiles(fileArray);
            } else {
                this.fc.setSelectedFile(list != null && !list.isEmpty() ? list.get(0) : null);
            }
            --this.isAdjusting;
        }
    }

    private void installSelectedFiles(List<File> list) {
        if (this.isAdjusting == 0) {
            ++this.isAdjusting;
            File file = this.fc.getCurrentDirectory();
            this.fc.setSelectedFiles(list.toArray(new File[list.size()]));
            this.fc.setCurrentDirectory(file);
            --this.isAdjusting;
        }
    }

    private TreePath first(List<TreePath> list) {
        return list.isEmpty() ? null : list.get(0);
    }

    protected ChangeListener createViewSelectionChangeListener(JFileChooser jFileChooser) {
        return new ViewSelectionChangeListener();
    }

    protected FileChooserView.SelectListener createViewSelectListener(JFileChooser jFileChooser) {
        return new ViewSelectListener();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.updateSelection(1);
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.updateSelection(1);
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.activeView == null) {
            return;
        }
        File file = (File)propertyChangeEvent.getNewValue();
        this.selectDirectory(file, 1, null);
    }

    private void updateModel() {
        this.model.invalidateAll();
        if (this.fc.isShowing() && this.activeView != null) {
            this.reconfigureView();
            List<TreePath> list = this.activeView.getSelection();
            List<TreePath> list2 = this.getNormalizedUISelection();
            if (list.equals(list2)) {
                this.model.validatePath(this.subtreeModel.toFullPath(this.first(list)));
                this.updateApproveButtonState();
            } else {
                File file;
                TreePath treePath;
                if (this.viewMode == 2 && list2.isEmpty() && (treePath = this.getSubtreePath(file = this.fc.getCurrentDirectory())) != null) {
                    list2.add(treePath);
                }
                this.setViewSelection(list2);
                this.respondToUISelectionChange();
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
        this.updateModel();
    }

    private void doFileHidingChanged(PropertyChangeEvent propertyChangeEvent) {
        this.updateModel();
    }

    private void doPackageTraversableChanged(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        this.setPackageTraversable(bl != null ? bl : false);
    }

    private void doApplicationTraversableChanged(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        this.setApplicationTraversable(bl != null ? bl : false);
    }

    private void setPackageTraversable(boolean bl) {
        AquaFileView aquaFileView;
        FileView fileView = this.fc.getFileView();
        if (fileView instanceof AquaFileView && bl != (aquaFileView = (AquaFileView)fileView).isPackageTraversable()) {
            aquaFileView.setPackageTraversable(bl);
            this.updateModel();
        }
    }

    private void setApplicationTraversable(boolean bl) {
        AquaFileView aquaFileView;
        FileView fileView = this.fc.getFileView();
        if (fileView instanceof AquaFileView && bl != (aquaFileView = (AquaFileView)fileView).isApplicationTraversable()) {
            aquaFileView.setApplicationTraversable(bl);
            this.updateModel();
        }
    }

    private void doFileViewChanged(PropertyChangeEvent propertyChangeEvent) {
        this.updateModel();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.updateApproveButtonText();
        this.updateApproveButtonState();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isMultipleSelection()) {
            this.fc.setSelectedFiles(null);
        }
    }

    private void doChoosableFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.installChoosableFileFilters((FileFilter[])propertyChangeEvent.getNewValue());
        this.updateModel();
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        this.installAccessory((JComponent)propertyChangeEvent.getNewValue());
    }

    private void installChoosableFileFilters(FileFilter[] fileFilterArray) {
        this.formatPanel.setVisible(fileFilterArray.length > 1);
        this.accessoryPanel.revalidate();
        this.accessoryPanel.repaint();
        this.updateOptionsPanel();
    }

    private void installAccessory(JComponent jComponent) {
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
            if (jComponent != null) {
                Border border = jComponent.getBorder();
                if (!(border instanceof EmptyBorder)) {
                    jComponent.setBorder(null);
                    jComponent.revalidate();
                }
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setLayout(new BorderLayout());
                jPanel.setBorder(new EmptyBorder(5, 15, 5, 15));
                jPanel.add((Component)jComponent, "Center");
                jPanel.revalidate();
                this.accessoryPanel.add((Component)jPanel, "Center");
            }
            this.accessoryPanel.setVisible(jComponent != null);
            this.updateOptionsPanel();
        }
    }

    private void updateOptionsPanel() {
        this.optionsPanel.setVisible(!(isOptionsAvailable && this.fc.getDialogType() == 0 && !this.isOptionsEnabled || !this.accessoryPanel.isVisible() && !this.formatPanel.isVisible()));
        this.optionsPanel.revalidate();
        this.optionsPanel.repaint();
        this.updateButtons();
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setText(this.getApproveButtonText(this.fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.fc));
        boolean bl = this.isFileNameFieldVisible();
        this.fileNameTextField.setEnabled(bl);
        this.savePanel.setVisible(bl);
        this.updateApproveButtonState();
        this.updateOptionsPanel();
        this.reconfigureChooser();
        this.configureDialog();
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.fc.getControlButtonsAreShown()) {
            this.showControlButtons();
        } else {
            this.hideControlButtons();
        }
    }

    private void doFileSystemViewChanged(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = this.model == this.fileSystemModel;
        this.fileSystemModel = new FileSystemTreeModel(this.fc);
        this.sidebarTreeModel = new SidebarTreeModel(this.fc, new TreePath(this.fileSystemModel.getRoot()), this.fileSystemModel);
        this.sidebarTree.setModel(this.sidebarTreeModel);
        if (bl) {
            this.installModel(this.fileSystemModel);
        }
    }

    private void updateButtons() {
        this.optionsButton.setVisible(isOptionsAvailable && this.fc.getDialogType() == 0 && (this.accessoryPanel.isVisible() || this.formatPanel.isVisible()));
        this.newFolderButton.setVisible(this.fc.getDialogType() == 1);
        this.updateButton(this.cancelButton);
        this.updateButton(this.approveButton);
    }

    private void updateButton(JButton jButton) {
        String string = null;
        if (this.fc.getDialogType() == 0 && OSXSystemProperties.OSVersion >= 1011 && OSXSystemProperties.OSVersion <= 1012) {
            string = "textured";
        }
        jButton.putClientProperty("JButton.buttonType", string);
    }

    private void ensureFileSystemModel() {
        this.installModel(this.fileSystemModel);
    }

    private void installModel(FileSystemTreeModel fileSystemTreeModel) {
        if (fileSystemTreeModel != this.model) {
            this.model = fileSystemTreeModel;
            this.subtreeModel = new SubtreeTreeModel(fileSystemTreeModel);
            this.columnView.setModel(this.subtreeModel);
            if (this.listView != null) {
                this.listView.setModel(this.subtreeModel);
            }
        }
    }

    private void doPreviewComponentChanged(PropertyChangeEvent propertyChangeEvent) {
        this.reconfigureView();
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new FileChooserPropertyChangeListener();
    }

    protected void hideControlButtons() {
        this.optionsButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.approveButton.setVisible(false);
    }

    protected void showControlButtons() {
        this.optionsButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.approveButton.setVisible(true);
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String string) {
        this.setFileNameTextField(string);
    }

    private void selectRootFromSidebarSelection() {
        Object object;
        TreePath treePath = this.sidebarTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof SidebarTreeNode) {
            File file;
            SidebarTreeNode sidebarTreeNode = (SidebarTreeNode)object;
            for (file = sidebarTreeNode.getResolvedFile(); file != null && !file.isDirectory() && !this.fc.isTraversable(file); file = file.getParentFile()) {
            }
            if (file != null) {
                this.selectDirectory(file, 5, null);
            }
        }
    }

    protected void selectDirectory(File file, final int n, final Runnable runnable) {
        if ((n == 5 || n == 6 || n == 7) && OSXFile.isSavedSearch(file)) {
            this.installModel(this.getSavedSearchTreeModel(file));
        } else {
            file = this.toTraversableFile(file);
            if (this.viewMode != 2 || n == 5 || this.model.toPath(file, null) == null) {
                this.ensureFileSystemModel();
            }
        }
        final TreePath treePath = this.model.toPath(file, null);
        if (n == 5) {
            this.setViewRoot(treePath);
            this.finishSelectDirectory(n, treePath, runnable);
        } else if (!(this.model instanceof SavedSearchFileSystemTreeModel)) {
            final File file2 = file;
            this.sidebarTreeModel.invokeWhenValid(new Runnable(){

                @Override
                public void run() {
                    final TreePath treePath2 = AquaFileChooserUI.this.selectViewRoot(file2, AquaFileChooserUI.this.viewMode == 2);
                    AquaFileChooserUI.this.finishSelectDirectory(n, treePath, runnable);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AquaFileChooserUI.this.setSidebarSelection(treePath2);
                        }
                    });
                }
            });
        }
    }

    private void finishSelectDirectory(int n, TreePath treePath, Runnable runnable) {
        TreePath treePath2;
        if (treePath != null) {
            this.model.lazyInvalidatePath(treePath);
        } else {
            this.model.invalidateAll();
        }
        TreePath treePath3 = treePath2 = treePath != null ? this.subtreeModel.toSubPath(treePath) : null;
        if (treePath2 == null) {
            treePath2 = this.subtreeModel.getPathToRoot();
        }
        this.setViewSelection(treePath2);
        if (this.viewMode == 1) {
            treePath2 = this.subtreeModel.getPathToRoot();
        }
        if (n != 1 && n != 6 && n != 7) {
            this.updateCurrentDirectory(treePath2);
        }
        this.updateComboBoxModel(treePath2);
        if (runnable != null) {
            runnable.run();
        }
    }

    private File toTraversableFile(File file) {
        while (file != null && !this.fc.isTraversable(file)) {
            file = file.getParentFile();
        }
        return file != null ? file : new File(System.getProperty("user.home"));
    }

    protected TreePath selectViewRoot(File file, boolean bl) {
        if (file.getPath().equals("/Network")) {
            this.setViewRoot(this.fileSystemModel.toPath(file, null));
            return null;
        }
        if (!bl) {
            TreePath treePath = this.selectRootOneStep(file);
            if (treePath == null) {
                TreePath treePath2 = this.model.toPath(file, null);
                this.setViewRoot(treePath2);
            }
            return treePath;
        }
        FileSystemTreeModel.Node node = this.fileSystemModel.getRoot();
        while (file != null) {
            TreePath treePath = this.selectRootOneStep(file);
            if (treePath != null) {
                return treePath;
            }
            if (file.equals(node.getFile())) break;
            file = file.getParentFile();
        }
        this.setViewRoot(new TreePath(this.model.getRoot()));
        return null;
    }

    private TreePath selectRootOneStep(File file) {
        if (file == null) {
            return null;
        }
        TreePath treePath = this.searchSidebarTreeForFile((TreeNode)this.sidebarTreeModel.getRoot(), file);
        if (treePath != null) {
            TreePath treePath2 = this.fileSystemModel.toPath(file, null);
            this.setViewRoot(treePath2);
            return treePath;
        }
        return null;
    }

    private TreePath searchSidebarTreeForFile(TreeNode treeNode, File file) {
        Serializable serializable;
        Object object;
        SidebarTreeNode sidebarTreeNode;
        File file2;
        if (treeNode instanceof SidebarTreeNode && (file2 = (sidebarTreeNode = (SidebarTreeNode)treeNode).getResolvedFile()) != null && ((File)(object = OSXFile.resolve(file))).equals(serializable = OSXFile.resolve(file2))) {
            return new TreePath(this.sidebarTreeModel.getPathToRoot(treeNode));
        }
        if (treeNode != null) {
            int n = this.sidebarTreeModel.getChildCount(treeNode);
            for (int i = 0; i < n; ++i) {
                object = this.sidebarTreeModel.getChild(treeNode, i);
                if (!(object instanceof TreeNode) || (serializable = this.searchSidebarTreeForFile((TreeNode)object, file)) == null) continue;
                return serializable;
            }
        }
        return null;
    }

    protected void setViewRoot(TreePath treePath) {
        ++this.isAdjusting;
        this.subtreeModel.setPathToRoot(treePath);
        --this.isAdjusting;
    }

    protected void setViewSelection(TreePath treePath) {
        this.setViewSelection(Arrays.asList(treePath));
    }

    protected void setViewSelection(List<TreePath> list) {
        if (this.activeView != null) {
            ++this.isAdjusting;
            this.activeView.setSelection(list);
            --this.isAdjusting;
            if (!list.isEmpty()) {
                this.ensurePathIsVisible(list.get(0));
            }
        }
    }

    protected void setSidebarSelection(TreePath treePath) {
        ++this.isAdjusting;
        if (treePath != null) {
            this.sidebarTree.setSelectionPath(treePath);
            if (this.sidebarTree.isVisible(treePath)) {
                this.sidebarTree.scrollPathToVisible(treePath);
            }
        } else {
            this.sidebarTree.clearSelection();
        }
        --this.isAdjusting;
    }

    protected void setFileNameTextField(String string) {
        ++this.isAdjusting;
        if (!(this.fileNameTextField == null || string != null && this.fileNameTextField.getText().equals(string))) {
            this.fileNameTextField.setText(string);
        }
        --this.isAdjusting;
    }

    protected void updateComboBoxModel(TreePath treePath) {
        TreePath treePath2;
        if (this.model instanceof SavedSearchFileSystemTreeModel && treePath.getPathCount() > 1) {
            FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
            File file = fileInfo.getResolvedFile();
            treePath2 = this.fileSystemModel.toPath(file, null);
        } else {
            treePath2 = this.subtreeModel.toFullPath(treePath);
        }
        ++this.isAdjusting;
        this.directoryComboBoxModel.setPath(treePath2);
        --this.isAdjusting;
    }

    private void ensurePathIsVisible(final TreePath treePath) {
        if (this.activeView != null && treePath != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.activeView.ensurePathIsVisible(treePath);
                }
            };
            this.runAfterValidation(treePath, 0, treePath.getPathCount() - 2, runnable);
        }
    }

    private void runAfterValidation(final TreePath treePath, final int n, final int n2, final Runnable runnable) {
        if (n > n2) {
            runnable.run();
        } else {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getPathComponent(n);
            node.invokeWhenValid(new Runnable(){

                @Override
                public void run() {
                    AquaFileChooserUI.this.runAfterValidation(treePath, n + 1, n2, runnable);
                }
            });
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JComboBox jComboBox) {
        return new DirectoryComboBoxRenderer(jComboBox);
    }

    private SidebarRenderer createSidebarCellRenderer(JFileChooser jFileChooser) {
        return new SidebarRenderer();
    }

    protected TreeSelectionListener createSidebarSelectionListener(JFileChooser jFileChooser) {
        return new SidebarSelectionListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer(JComboBox jComboBox) {
        return new FilterComboBoxRenderer(jComboBox);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void maybeApproveSelection() {
        assert (this.isAdjusting == 0);
        String string = null;
        if (this.isFileNameFieldVisible() && (string = this.getFileName()).equals("")) {
            string = null;
        }
        List<File> list = this.getUISelection(true);
        if (string != null && list.size() == 1) {
            File file = list.get(0);
            if (this.isDirectorySelectedInSaveDialogListView(file)) {
                this.selectDirectory(file, 3, null);
                return;
            }
            File file2 = file.isDirectory() ? file : file.getParentFile();
            File file3 = new File(file2, string);
            list = new ArrayList<File>();
            list.add(file3);
        }
        if (list.isEmpty()) {
            return;
        }
        if (this.isMultipleSelection()) {
            this.updateSelectedFiles(list);
        } else if (list.size() == 1) {
            this.updateSelectedFile(list.get(0));
        } else {
            return;
        }
        this.fc.approveSelection();
    }

    private boolean isDirectorySelectedInSaveDialogListView(File file) {
        if (this.viewMode == 1 && this.fc.isTraversable(file)) {
            File file2 = this.fc.getCurrentDirectory();
            return !file.equals(file2);
        }
        return false;
    }

    protected List<TreePath> getNormalizedUISelection() {
        List<TreePath> list = this.activeView.getSelection();
        if (!list.isEmpty()) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            List<TreePath> list2 = new ArrayList();
            boolean bl = false;
            for (TreePath treePath : list) {
                FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
                if (fileInfo.getFile() == null) {
                    bl = true;
                    continue;
                }
                if (fileInfo.isAcceptable()) {
                    arrayList.add(treePath);
                    continue;
                }
                if (fileInfo.isTraversable()) {
                    list2.add(treePath);
                    continue;
                }
                bl = true;
            }
            if (!list2.isEmpty()) {
                if (arrayList.isEmpty()) {
                    if (list2.size() > 1) {
                        list2 = list2.subList(0, 1);
                        bl = true;
                    }
                } else {
                    list2 = new ArrayList();
                    bl = true;
                }
            }
            List<TreePath> list3 = new ArrayList();
            list3.addAll(arrayList);
            list3.addAll(list2);
            if (list3.size() > 1 && !this.isMultipleSelection()) {
                list3 = list3.subList(0, 1);
                bl = true;
            }
            if (bl) {
                ++this.isAdjusting;
                this.activeView.setSelection(list3);
                --this.isAdjusting;
            }
            return list3;
        }
        return list;
    }

    protected List<File> getUISelection(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        List<TreePath> list = this.activeView.getSelection();
        for (Serializable serializable : list) {
            File file = ((FileSystemTreeModel.Node)serializable.getLastPathComponent()).getFile();
            arrayList.add(file);
        }
        if (bl && arrayList.isEmpty()) {
            Serializable serializable;
            FileInfo fileInfo = (FileInfo)this.subtreeModel.getRoot();
            serializable = fileInfo.getFile();
            arrayList.add((File)serializable);
        }
        return arrayList;
    }

    protected List<File> getNormalizedChooserSelection() {
        List<File> list = this.getChooserSelection();
        if (!list.isEmpty()) {
            ArrayList<File> arrayList = new ArrayList<File>();
            List<File> list2 = new ArrayList<File>();
            boolean bl = false;
            for (File file : list) {
                if (this.isAcceptable(file)) {
                    arrayList.add(file);
                    continue;
                }
                if (this.fc.isTraversable(file)) {
                    list2.add(file);
                    continue;
                }
                bl = true;
            }
            if (!list2.isEmpty()) {
                if (arrayList.isEmpty()) {
                    if (list2.size() > 1) {
                        list2 = list2.subList(0, 1);
                        bl = true;
                    }
                } else {
                    list2 = new ArrayList();
                    bl = true;
                }
            }
            List list3 = new ArrayList();
            list3.addAll(arrayList);
            list3.addAll(list2);
            if (list3.size() > 1 && !this.isMultipleSelection()) {
                list3 = list3.subList(0, 1);
                bl = true;
            }
            if (bl) {
                ++this.isAdjusting;
                this.fc.setSelectedFiles(list3.toArray(new File[list3.size()]));
                --this.isAdjusting;
            }
            return list3;
        }
        return list;
    }

    private List<File> getChooserSelection() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = this.fc.getCurrentDirectory();
        if (this.isMultipleSelection()) {
            File[] fileArray;
            for (File file2 : fileArray = this.fc.getSelectedFiles()) {
                if (file2 == null) continue;
                if (!file2.isAbsolute()) {
                    file2 = new File(file, file2.getPath());
                }
                arrayList.add(file2);
            }
        } else {
            File file3 = this.fc.getSelectedFile();
            if (file3 != null) {
                if (!file3.isAbsolute()) {
                    file3 = new File(file, file3.getPath());
                }
                arrayList.add(file3);
            }
        }
        return arrayList;
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    protected JDialog getStandardDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.fc);
        if (window instanceof JDialog) {
            Component component;
            JDialog jDialog = (JDialog)window;
            JRootPane jRootPane = jDialog.getRootPane();
            int n = jRootPane.getWindowDecorationStyle();
            if (n == 6) {
                return jDialog;
            }
            Container container = jDialog.getContentPane();
            int n2 = container.getComponentCount();
            if (n2 == 1 && (component = container.getComponent(0)) == this.fc) {
                return jDialog;
            }
        }
        return null;
    }

    protected void configureForShowing() {
        this.installSelectedView(true, true);
        if (this.fileNameTextField != null && this.isFileNameFieldVisible()) {
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocusInWindow();
        } else {
            this.activeView.requestFocusInWindow();
        }
        if (this.model != null) {
            this.model.setAutoValidate(UIManager.getBoolean("FileChooser.autovalidate"));
            TreePath treePath = this.first(this.activeView.getSelection());
            TreePath treePath2 = this.subtreeModel.toFullPath(treePath);
            this.model.validatePath(treePath2);
            if (this.sidebarTreeModel != null) {
                this.sidebarTreeModel.lazyValidate();
            }
        }
        this.updateApproveButtonState();
        if (this.fc.getSelectedFile() != null) {
            this.ensureFileIsVisible(this.fc, this.fc.getSelectedFile());
        }
        this.reconfigure(this.optionsPanel);
    }

    protected void configureForHiding() {
        if (this.model != null) {
            this.model.setAutoValidate(false);
            this.model.stopValidation();
            TreePath treePath = this.first(this.activeView.getSelection());
            TreePath treePath2 = this.subtreeModel.toFullPath(treePath);
            this.model.invalidatePath(treePath2);
            this.clearIconCache();
        }
    }

    protected void reconfigureChooser() {
        this.reconfigure(this.navigationPanel);
        this.reconfigure(this.buttonsPanel);
        this.reconfigure(this.topPanel);
        this.reconfigure(this.optionsPanel);
        this.reconfigureView();
    }

    protected void reconfigureView() {
        if (this.activeView != null) {
            this.activeView.reconfigure();
        }
    }

    private void reconfigure(@Nullable JComponent jComponent) {
        if (jComponent instanceof Reconfigurable) {
            Reconfigurable reconfigurable = (Reconfigurable)((Object)jComponent);
            reconfigurable.reconfigure();
        }
    }

    private void updateWindowStyleParameters() {
        JDialog jDialog = this.getStandardDialog();
        if (jDialog != null) {
            JRootPane jRootPane = jDialog.getRootPane();
            if (this.windowStyle != null) {
                Integer n = this.topPanel.getHeight();
                Integer n2 = this.controlsPanel.getHeight();
                jRootPane.putClientProperty("Aqua.windowTopMargin", n);
                jRootPane.putClientProperty("Aqua.windowBottomMargin", n2);
            } else {
                jRootPane.putClientProperty("Aqua.windowStyle", null);
                jRootPane.putClientProperty("Aqua.windowTopMargin", null);
            }
        }
    }

    protected void configureDialog() {
        Object object;
        Object object2;
        boolean bl = false;
        this.useToolBar = false;
        this.windowStyle = null;
        JDialog jDialog = this.getStandardDialog();
        if (jDialog != null) {
            bl = true;
            object2 = jDialog.getRootPane();
            this.windowStyle = this.fc.getDialogType() == 0 ? "texturedToolBar" : "overlayTitleBar";
            this.useToolBar = true;
            object = AquaRootPaneUI.getWindowStyleKey((JRootPane)object2);
            if (!"undecorated".equals(object)) {
                ((JComponent)object2).putClientProperty("Aqua.windowStyle", this.windowStyle);
                ((JComponent)object2).revalidate();
                ((Component)object2).repaint();
            }
        }
        this.configureTopPanel();
        object2 = AppearanceManager.ensureAppearance(this.fc);
        if (bl) {
            this.splitPane.setBorder(null);
        } else {
            object = ((AquaAppearance)object2).getColor("separator");
            this.splitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, (Color)object));
        }
        this.configureDialogSize();
    }

    public void configureDialogSize() {
        Window window = SwingUtilities.getWindowAncestor(this.fc);
        if (window != null && this.isDefaultWindowSize(window)) {
            window.setMinimumSize(null);
            Dimension dimension = window.getMinimumSize();
            this.installMinimumSize(window, dimension.width, dimension.height);
            Dimension dimension2 = window.getSize();
            if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
                dimension2 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
                window.setSize(dimension2);
                try {
                    Point point = window.getLocationOnScreen();
                    int n = point.x;
                    int n2 = point.y;
                    Rectangle rectangle = this.getScreenBounds(window);
                    if (n + dimension2.width > rectangle.x + rectangle.width) {
                        n = Math.max(rectangle.x, rectangle.x + rectangle.width - dimension2.width);
                    }
                    if (n2 + dimension2.height > rectangle.y + rectangle.height) {
                        n2 = Math.max(rectangle.y, rectangle.y + rectangle.height - dimension2.height);
                    }
                    window.setLocation(n, n2);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
    }

    protected void installMinimumSize(@NotNull Window window, int n, int n2) {
        DimensionUIResource dimensionUIResource = new DimensionUIResource(n, n2);
        window.setMinimumSize(dimensionUIResource);
    }

    protected boolean isDefaultWindowSize(@NotNull Window window) {
        if (!window.isMinimumSizeSet()) {
            return true;
        }
        MinimumSizeTester minimumSizeTester = new MinimumSizeTester(window);
        return minimumSizeTester.isUIResource();
    }

    @NotNull
    protected Rectangle getScreenBounds(@NotNull Window window) {
        Point point = window.getLocationOnScreen();
        return AquaUtils.getScreenBounds(point, window);
    }

    @Override
    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        TreePath treePath;
        if (this.activeView != null && (treePath = this.getSubtreePath(file)) != null) {
            this.ensurePathIsVisible(treePath);
        }
    }

    @Override
    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.isDirectorySelectionEnabled() && this.chooseButtonText != null) {
            return this.chooseButtonText;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        if (jFileChooser.isShowing()) {
            TreePath treePath = this.first(this.activeView.getSelection());
            TreePath treePath2 = this.subtreeModel.toFullPath(treePath);
            this.model.lazyInvalidatePath(treePath2);
            this.model.validatePath(treePath2);
        }
    }

    @Override
    public void clearIconCache() {
        if (this.fileView instanceof BasicFileChooserUI.BasicFileView) {
            BasicFileChooserUI.BasicFileView basicFileView = (BasicFileChooserUI.BasicFileView)this.fileView;
            basicFileView.clearIconCache();
        }
    }

    protected class AquaApproveSelectionAction
    extends AbstractAction {
        protected AquaApproveSelectionAction() {
            super("approveSelection");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaFileChooserUI.this.maybeApproveSelection();
        }
    }

    private class SidebarSelectionListener
    implements TreeSelectionListener {
        private SidebarSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            if (AquaFileChooserUI.this.sidebarTree != null) {
                AquaFileChooserUI.this.selectRootFromSidebarSelection();
            }
        }
    }

    private static class MinimumSizeTester
    implements PropertyChangeListener {
        private Component c;
        private Dimension value;

        public MinimumSizeTester(@NotNull Component component) {
            this.c = component;
        }

        public boolean isUIResource() {
            Dimension dimension = this.c.getMinimumSize();
            this.c.addPropertyChangeListener(this);
            this.c.setMinimumSize(new Dimension(dimension.width + 1, dimension.height));
            this.c.removePropertyChangeListener(this);
            this.c.setMinimumSize(dimension);
            return this.value instanceof DimensionUIResource;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.value = (Dimension)propertyChangeEvent.getOldValue();
        }
    }

    protected class FileChooserHierarchyListener
    implements HierarchyListener {
        protected FileChooserHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Component component = hierarchyEvent.getChanged();
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 1L) != 0L) {
                AquaFileChooserUI.this.configureDialog();
            }
            if ((l & 4L) != 0L) {
                if (component.isVisible()) {
                    AquaFileChooserUI.this.configureForShowing();
                } else {
                    AquaFileChooserUI.this.configureForHiding();
                }
            }
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void textChanged() {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath treePath = AquaFileChooserUI.this.first(AquaFileChooserUI.this.activeView.getSelection());
                    FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
                    File file = node.getResolvedFile();
                    if (AquaFileChooserUI.this.fileNameTextField.getText().length() != 0) {
                        if (!node.isLeaf()) {
                            AquaFileChooserUI.this.updateApproveButtonState();
                            return;
                        }
                        file = new File(AquaFileChooserUI.this.fc.getFileSystemView().getParentDirectory(file), AquaFileChooserUI.this.fileNameTextField.getText());
                    }
                    AquaFileChooserUI.this.updateSelectedFile(file);
                    AquaFileChooserUI.this.updateApproveButtonState();
                }
            });
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AquaFileChooserUI.this.updateApproveButtonState();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        private String showNewFolderDialog() {
            JOptionPane jOptionPane = new JOptionPane(AquaFileChooserUI.this.newFolderDialogPrompt, -1, 2);
            jOptionPane.setWantsInput(true);
            jOptionPane.putClientProperty("JOptionPane.textFieldDocument", new FilenameDocument());
            jOptionPane.setInitialSelectionValue(AquaFileChooserUI.this.newFolderDefaultName);
            jOptionPane.setOptions(new Object[]{UIManager.getString("FileChooser.createFolderButtonText"), UIManager.getString("FileChooser.cancelButtonText")});
            jOptionPane.setInitialValue(UIManager.getString("FileChooser.createFolderButtonText"));
            JDialog jDialog = jOptionPane.createDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderTitleText);
            jDialog.setVisible(true);
            jDialog.dispose();
            return jOptionPane.getValue() == UIManager.getString("FileChooser.createFolderButtonText") ? (String)jOptionPane.getInputValue() : null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.showNewFolderDialog();
            if (string != null) {
                File file;
                TreePath treePath = AquaFileChooserUI.this.first(AquaFileChooserUI.this.activeView.getSelection());
                FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
                File file2 = node.getResolvedFile();
                if (node.isLeaf()) {
                    file2 = file2.getParentFile();
                }
                if ((file = new File(file2, string)).exists()) {
                    JOptionPane.showMessageDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderExistsErrorText, AquaFileChooserUI.this.newFolderTitleText, 0);
                    return;
                }
                try {
                    if (!file.mkdir() && !file.isDirectory()) {
                        throw new IOException("Couldn't create folder \"" + file.getName() + "\".");
                    }
                    AquaFileChooserUI.this.fc.rescanCurrentDirectory();
                    AquaFileChooserUI.this.selectDirectory(file, 4, null);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(AquaFileChooserUI.this.fc, AquaFileChooserUI.this.newFolderErrorText, AquaFileChooserUI.this.newFolderTitleText, 0);
                }
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AquaFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            TreePath treePath = AquaFileChooserUI.this.directoryComboBoxModel.getSelectedPath();
            if (treePath != null) {
                FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
                final File file = fileInfo.getResolvedFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AquaFileChooserUI.this.selectDirectory(file, 2, null);
                    }
                });
            }
        }
    }

    protected class OptionsAction
    extends AbstractAction {
        protected OptionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaFileChooserUI.this.isOptionsEnabled = !AquaFileChooserUI.this.isOptionsEnabled;
            AquaFileChooserUI.this.updateOptionsPanel();
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = AquaFileChooserUI.this.fc.getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object != null) {
                AquaFileChooserUI.this.fc.setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter[] fileFilterArray = AquaFileChooserUI.this.fc.getChoosableFileFilters();
            if (fileFilterArray.length > 1) {
                FileFilter fileFilter = AquaFileChooserUI.this.fc.getFileFilter();
                boolean bl = false;
                if (fileFilter != null) {
                    for (int i = 0; i < fileFilterArray.length; ++i) {
                        if (fileFilterArray[i] != fileFilter) continue;
                        bl = true;
                    }
                    if (!bl) {
                        AquaFileChooserUI.this.fc.addChoosableFileFilter(fileFilter);
                    }
                }
            }
            return AquaFileChooserUI.this.fc.getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return AquaFileChooserUI.this.fc.getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    protected static class FilterComboBoxRenderer
    extends AquaComboBoxRendererInternal {
        public FilterComboBoxRenderer(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof FileFilter) {
                object = ((FileFilter)object).getDescription();
            }
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        TreePath path;
        FileSystemTreeModel.Node selectedDirectory = null;

        private void setPath(TreePath treePath) {
            if (this.path != null && this.path.getPathCount() > 0) {
                this.fireIntervalRemoved(this, 0, this.path.getPathCount() - 1);
            }
            this.path = treePath;
            if (this.path.getPathCount() > 0) {
                this.fireIntervalAdded(this, 0, this.path.getPathCount() - 1);
            }
            this.setSelectedItem(this.path.getLastPathComponent());
        }

        @Override
        public void setSelectedItem(Object object) {
            FileSystemTreeModel.Node node;
            this.selectedDirectory = node = (FileSystemTreeModel.Node)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public TreePath getSelectedPath() {
            int n = this.path.getPathCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.path.getPathComponent(i);
                if (!object.equals(this.selectedDirectory)) continue;
                return this.pathPrefix(this.path, i + 1);
            }
            return null;
        }

        private TreePath pathPrefix(TreePath treePath, int n) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = treePath.getPathComponent(i);
            }
            return new TreePath(objectArray);
        }

        @Override
        public int getSize() {
            return this.path == null ? 0 : this.path.getPathCount();
        }

        @Override
        public Object getElementAt(int n) {
            return this.path.getPathComponent(this.path.getPathCount() - n - 1);
        }
    }

    private static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        private IndentIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.icon != null) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
                } else {
                    this.icon.paintIcon(component, graphics, n, n2);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? this.depth * 10 : this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    public static class SidebarTreeUI
    extends AquaTreeUI {
        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            InputMap inputMap = this.tree.getInputMap(0).getParent();
            KeyStroke keyStroke = KeyStroke.getKeyStroke("shift meta A");
            Object object = inputMap.get(keyStroke);
            if (object != null && object.equals("clearSelection")) {
                InputMap inputMap2 = new InputMap();
                inputMap2.setParent(inputMap);
                inputMap2.put(keyStroke, "selectApplicationsFolder");
                SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap2);
            }
        }
    }

    private static class SidebarRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
            if (object instanceof SidebarTreeNode) {
                SidebarTreeNode sidebarTreeNode = (SidebarTreeNode)object;
                this.setText(sidebarTreeNode.getUserName());
                AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(jTree);
                this.setIcon(sidebarTreeNode.getIcon(aquaAppearance));
            }
            return this;
        }
    }

    private static class SidebarTreeSelectionModel
    extends DefaultTreeSelectionModel {
        public SidebarTreeSelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void setSelectionPaths(TreePath[] treePathArray) {
            TreePath treePath;
            Object object;
            if (treePathArray != null && treePathArray.length > 0 && !((object = (treePath = treePathArray[0]).getLastPathComponent()) instanceof SidebarTreeNode)) {
                return;
            }
            super.setSelectionPaths(treePathArray);
        }
    }

    static class DirectoryComboBoxRenderer
    extends AquaComboBoxRendererInternal {
        IndentIcon ii = new IndentIcon();
        private JSeparator separator = new JSeparator();

        public DirectoryComboBoxRenderer(JComboBox jComboBox) {
            super(jComboBox);
            this.separator.setPreferredSize(new Dimension(9, 9));
        }

        @Override
        public Insets getInsets(Insets insets) {
            Insets insets2 = super.getInsets(insets);
            if (this.fInList) {
                ++insets2.top;
                ++insets2.bottom;
            }
            return insets2;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof String) {
                super.getListCellRendererComponent(jList, object, n, false, bl2);
                this.setText((String)object);
                this.setPreferredSize(new Dimension(10, 14));
                return this;
            }
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setPreferredSize(null);
            if (object instanceof File) {
                this.setText(object + " " + n);
                return this;
            }
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)object;
            if (node == null) {
                return this.separator;
            }
            this.setText(node.getUserName());
            this.ii.icon = node.getIcon();
            this.ii.depth = 0;
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileChooserPropertyChangeListener
    implements PropertyChangeListener {
        protected FileChooserPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (AquaFileChooserUI.this.isAdjusting > 0) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("SelectedFileChangedProperty")) {
                AquaFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFilesChangedProperty")) {
                AquaFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                AquaFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
            } else if (string.equals("fileFilterChanged")) {
                AquaFileChooserUI.this.doFilterChanged(propertyChangeEvent);
            } else if (string.equals("FileSystemViewChanged")) {
                AquaFileChooserUI.this.doFileSystemViewChanged(propertyChangeEvent);
            } else if (string.equals("fileSelectionChanged")) {
                AquaFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
            } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                AquaFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
            } else if (string.equals("AccessoryChangedProperty")) {
                AquaFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
            } else if (string.equals("ChoosableFileFilterChangedProperty")) {
                AquaFileChooserUI.this.doChoosableFilterChanged(propertyChangeEvent);
            } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                AquaFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
            } else if (string.equals("DialogTypeChangedProperty")) {
                AquaFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
            } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                AquaFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
            } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                AquaFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
            } else if (string.equals("fileViewChanged")) {
                AquaFileChooserUI.this.doFileViewChanged(propertyChangeEvent);
            } else if (string.equals("FileHidingChanged")) {
                AquaFileChooserUI.this.doFileHidingChanged(propertyChangeEvent);
            } else if (string.equals(AquaFileChooserUI.PACKAGE_TRAVERSABLE_PROPERTY)) {
                AquaFileChooserUI.this.doPackageTraversableChanged(propertyChangeEvent);
            } else if (string.equals(AquaFileChooserUI.APPLICATION_TRAVERSABLE_PROPERTY)) {
                AquaFileChooserUI.this.doApplicationTraversableChanged(propertyChangeEvent);
            } else if (string.equals("Aqua.FileChooser.preview")) {
                AquaFileChooserUI.this.doPreviewComponentChanged(propertyChangeEvent);
            }
        }
    }

    protected class ViewModeChangeListener
    implements ChangeListener {
        protected ViewModeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AquaFileChooserUI.this.setViewMode(AquaFileChooserUI.this.viewModeControl.getSelectedViewMode());
        }
    }

    protected class ViewSelectListener
    implements FileChooserView.SelectListener {
        protected ViewSelectListener() {
        }

        @Override
        public void select(TreePath treePath) {
            FileInfo fileInfo = (FileInfo)treePath.getLastPathComponent();
            File file = fileInfo.getFile();
            if (fileInfo.isTraversable()) {
                if (AquaFileChooserUI.this.viewMode == 1) {
                    AquaFileChooserUI.this.selectDirectory(file, 3, null);
                }
            } else if (fileInfo.isAcceptable()) {
                if (!AquaFileChooserUI.this.isSelected(file)) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    arrayList.add(file);
                    AquaFileChooserUI.this.installSelectedFiles(arrayList);
                }
                AquaFileChooserUI.this.maybeApproveSelection();
            } else if (AquaFileChooserUI.this.fc.getDialogType() == 1) {
                AquaFileChooserUI.this.setFileName(file.getName());
            }
        }
    }

    protected class ViewSelectionChangeListener
    implements ChangeListener {
        protected ViewSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (AquaFileChooserUI.this.isAdjusting == 0) {
                AquaFileChooserUI.this.respondToUISelectionChange();
            }
        }
    }

    private class DirectoryComboBox
    extends JComboBox {
        public DirectoryComboBox() {
            this.putClientProperty("JComboBox.style", "textured");
            this.setAlignmentY(0.5f);
            this.putClientProperty("Quaqua.Component.visualMargin", new Insets(1, 1, 1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = Math.max(dimension.width, 300);
            int n2 = dimension.height;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class SidebarTree
    extends JTree {
        private SidebarTree() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 10;
            return dimension;
        }

        @Override
        public String toString() {
            return "SidebarTree";
        }
    }

    private class ButtonPanel
    extends JPanel
    implements Reconfigurable {
        public ButtonPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.reconfigure();
        }

        @Override
        public void reconfigure() {
            if (AquaFileChooserUI.this.fc.getDialogType() == 1 || OSXSystemProperties.OSVersion < 1011) {
                this.setBorder(BorderFactory.createEmptyBorder(10, 23, 9, 10));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(8, 8, 9, 8));
            }
        }
    }

    private class ControlsPanel
    extends JPanel {
        public ControlsPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(AquaLookAndFeel.NOTHING_BORDER);
            this.setOpaque(false);
        }
    }

    private class OptionsPanel
    extends JPanel
    implements Reconfigurable {
        public OptionsPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.reconfigure();
        }

        @Override
        public void reconfigure() {
            this.setOpaque(false);
            if (this.useGroupBox()) {
                AquaGroupBorder aquaGroupBorder = new AquaGroupBorder(new Insets(10, 10, 1, 10), new Insets(18, 22, 18, 22));
                this.setBorder(aquaGroupBorder);
                AquaFileChooserUI.this.optionsSeparator.setVisible(false);
            } else {
                EffectName effectName;
                boolean bl;
                String string;
                AquaAppearance aquaAppearance;
                Color color;
                this.setBorder(null);
                AquaFileChooserUI.this.optionsSeparator.setVisible(true);
                if (!AquaSheetSupport.isSheet(AquaFileChooserUI.this.fc) && (color = (aquaAppearance = AppearanceManager.getAppearance(AquaFileChooserUI.this.fc)).getColorForEffect(string = (bl = AquaFileChooserUI.this.fc.getDialogType() == 1) ? "saveOptionsArea" : "openOptionsArea", effectName = AquaFocusHandler.isActive(AquaFileChooserUI.this.fc) ? EffectName.EFFECT_NONE : EffectName.EFFECT_DISABLED)) != null) {
                    this.setOpaque(true);
                    this.setBackground(AquaColors.getOrdinaryColor(color));
                }
            }
        }

        boolean useGroupBox() {
            if (OSXSystemProperties.OSVersion < 1013) {
                return OSXSystemProperties.OSVersion == 1010 || AquaFileChooserUI.this.fc.getDialogType() == 1;
            }
            return false;
        }
    }

    private class NavigationPanel
    extends JPanel
    implements Reconfigurable {
        public NavigationPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.reconfigure();
        }

        public void setToolBar(boolean bl) {
            this.putClientProperty("Aqua.isToolBarPanel", bl);
        }

        @Override
        public void reconfigure() {
            if (AquaFileChooserUI.this.fc.getDialogType() == 1) {
                if (OSXSystemProperties.OSVersion >= 1011) {
                    this.setBorder(new EmptyBorder(9, 11, 6, 11));
                } else {
                    this.setBorder(new EmptyBorder(17, 11, 6, 11));
                }
            } else if (OSXSystemProperties.OSVersion >= 1014) {
                this.setBorder(new EmptyBorder(5, 8, 6, 8));
            } else {
                this.setBorder(new EmptyBorder(3, 8, 2, 8));
            }
        }
    }

    private class SavePanel
    extends JPanel {
        public SavePanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
        }
    }

    private class TopPanel
    extends JPanel {
        public TopPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(4, 0, 4, 0));
        }

        public void setToolBar(boolean bl) {
            this.putClientProperty("Aqua.isToolBarPanel", bl);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            AquaFileChooserUI.this.updateWindowStyleParameters();
        }
    }

    private static interface Reconfigurable {
        public void reconfigure();
    }

    protected class RequestFileSelectionPathPane
    extends JPanel
    implements DocumentListener {
        private JLabel messageLabel;
        private JTextField inputField;
        private JLabel errorLabel;
        private JButton cancelButton;
        private JButton acceptButton;
        private File selection;

        public RequestFileSelectionPathPane(final JDialog jDialog, String string, String string2, String string3, String string4, final String string5) {
            this.messageLabel = new JLabel(string2);
            this.errorLabel = new JLabel();
            this.inputField = AquaFileChooserUI.this.createTextField("Request File Input Field");
            this.cancelButton = AquaFileChooserUI.this.createButton(string3);
            this.acceptButton = AquaFileChooserUI.this.createButton(string4);
            this.inputField.putClientProperty("Quaqua.TextComponent.autoSelect", false);
            this.messageLabel.setAlignmentX(0.0f);
            this.inputField.setAlignmentX(0.0f);
            this.inputField.setColumns(32);
            this.errorLabel.setMaximumSize(new Dimension(100000, 100000));
            Serializable serializable = UIManager.getFont("FileChooser.sheetErrorFont");
            if (serializable == null) {
                serializable = UIManager.getFont("SmallSystemFont");
            }
            this.errorLabel.setFont((Font)serializable);
            if (jDialog != null) {
                jDialog.getRootPane().setDefaultButton(this.acceptButton);
            }
            if (string != null) {
                this.inputField.setText(string);
            } else {
                this.inputField.setText(goToFolderText);
                if (!AquaFileChooserUI.this.goToFolderErrorText.isEmpty()) {
                    this.inputField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            RequestFileSelectionPathPane.this.inputField.selectAll();
                        }
                    });
                }
            }
            serializable = new JPanel();
            ((JComponent)serializable).setAlignmentX(0.0f);
            ((JComponent)serializable).setBorder(new EmptyBorder(12, 0, 6, 0));
            ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
            ((Container)serializable).add(this.errorLabel);
            ((Container)serializable).add(this.cancelButton);
            ((Container)serializable).add(Box.createHorizontalStrut(6));
            ((Container)serializable).add(this.acceptButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.messageLabel);
            this.add(this.inputField);
            this.add((Component)serializable);
            this.inputField.getDocument().addDocumentListener(this);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jDialog != null) {
                        jDialog.setVisible(false);
                    }
                    RequestFileSelectionPathPane.this.canceled();
                }
            });
            this.acceptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    String string = RequestFileSelectionPathPane.this.inputField.getText();
                    File file2 = OSXFile.resolvePath(string, file = AquaFileChooserUI.this.fc.getCurrentDirectory());
                    if (!file2.isDirectory()) {
                        RequestFileSelectionPathPane.this.errorLabel.setText(string5);
                        RequestFileSelectionPathPane.this.inputField.selectAll();
                    } else {
                        RequestFileSelectionPathPane.this.selection = file2;
                        goToFolderText = string;
                        if (jDialog != null) {
                            jDialog.setVisible(false);
                        }
                        RequestFileSelectionPathPane.this.accepted();
                    }
                }
            });
            this.pathChanged();
        }

        public File getSelection() {
            return this.selection;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.pathChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.pathChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.pathChanged();
        }

        protected void pathChanged() {
            this.errorLabel.setText("");
            this.acceptButton.setEnabled(!this.inputField.getText().isEmpty());
        }

        protected void canceled() {
        }

        protected void accepted() {
        }
    }

    private class TextKeyListener
    extends KeyAdapter {
        private TextKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '/' || c == '~') {
                String string = "" + c;
                AquaFileChooserUI.this.requestFileSelectionPath(string);
                keyEvent.consume();
            }
        }
    }

    private class KeyListenerAction
    extends AbstractAction {
        private KeyListenerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            switch (actionEvent.getActionCommand().charAt(0)) {
                case 'd': {
                    file = new File(System.getProperty("user.home") + "/Desktop");
                    break;
                }
                case 'c': {
                    FileSystemTreeModel.Node node = AquaFileChooserUI.this.fileSystemModel.getRoot();
                    file = node.getResolvedFile();
                    break;
                }
                case 'h': {
                    file = new File(System.getProperty("user.home"));
                    break;
                }
                case 'k': {
                    file = new File("/Network");
                    break;
                }
                case 'i': {
                    file = null;
                    return;
                }
                case 'a': {
                    file = new File("/Applications");
                    break;
                }
                case 'u': {
                    file = new File("/Applications/Utilities");
                    break;
                }
                case 'g': {
                    AquaFileChooserUI.this.requestFileSelectionPath(null);
                    return;
                }
                case 'o': {
                    file = new File(System.getProperty("user.home") + "/Documents");
                    break;
                }
                case '.': {
                    boolean bl = AquaFileChooserUI.this.fc.isFileHidingEnabled();
                    AquaFileChooserUI.this.fc.setFileHidingEnabled(!bl);
                    return;
                }
            }
            if (file != null) {
                if (file.isDirectory()) {
                    AquaFileChooserUI.this.selectDirectory(file, 4, null);
                } else if (AquaFileChooserUI.this.isAcceptable(file)) {
                    AquaFileChooserUI.this.fc.setSelectedFile(file);
                }
            }
        }
    }
}

