/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.util.LinkedList;

public abstract class EventLoop {
    private Thread eventProcessor;
    private int threadPriority;
    private final LinkedList eventQueue = new LinkedList();
    private boolean isCoalesce;
    private volatile boolean isAlive = true;
    private volatile boolean isLIFO = false;

    public EventLoop() {
        this(5);
    }

    public EventLoop(int n) {
        this.threadPriority = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectEvent(Object object) {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (!this.isCoalesce || !this.eventQueue.contains(object)) {
                if (this.isLIFO) {
                    this.eventQueue.addFirst(object);
                } else {
                    this.eventQueue.addLast(object);
                }
                if (this.isAlive) {
                    this.startProcessor();
                }
            }
        }
    }

    public void setCoalesce(boolean bl) {
        this.isCoalesce = bl;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    public void setLIFO(boolean bl) {
        this.isLIFO = bl;
    }

    public boolean isLIFO() {
        return this.isLIFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.isAlive = true;
            this.startProcessor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.isAlive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.clear();
        }
    }

    public void dispose() {
        this.stop();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessor() {
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.eventProcessor == null) {
                this.eventProcessor = new Thread(this + " Event Processor"){

                    @Override
                    public void run() {
                        EventLoop.this.processEvents();
                    }
                };
                try {
                    this.eventProcessor.setDaemon(false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    this.eventProcessor.setPriority(this.threadPriority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.eventProcessor.start();
            }
        }
    }

    protected abstract void processEvent(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (true) {
            Object e;
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                if (this.eventQueue.isEmpty() || !this.isAlive) {
                    this.eventProcessor = null;
                    return;
                }
                e = this.eventQueue.removeFirst();
            }
            try {
                this.processEvent(e);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }
}

