/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.fc.FileChooserView;
import org.violetlib.aqua.fc.ListViewImpl;
import org.violetlib.aqua.fc.SubtreeTreeModel;

public abstract class ListView
extends JPanel
implements FileChooserView {
    protected SubtreeTreeModel model;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private FileChooserView.SelectListener selectListener;

    public static ListView create(JFileChooser jFileChooser) {
        return new ListViewImpl(jFileChooser);
    }

    @Override
    public void setModel(SubtreeTreeModel subtreeTreeModel) {
        if (subtreeTreeModel != this.model) {
            this.model = subtreeTreeModel;
            this.updateForNewModel();
        }
    }

    @Override
    public void addSelectionChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void addSelectListener(FileChooserView.SelectListener selectListener) {
        this.selectListener = selectListener;
    }

    protected void selectionChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    protected abstract void updateForNewModel();

    protected final void select(TreePath treePath) {
        if (this.selectListener != null) {
            this.selectListener.select(treePath);
        }
    }

    @Override
    public void ensureSelectionIsVisible() {
        List<TreePath> list = this.getSelection();
        if (!list.isEmpty()) {
            this.ensurePathIsVisible(list.get(0));
        }
    }
}

