/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SequentialDispatcher;
import org.violetlib.aqua.fc.SidebarTreeNode;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private TreePath volumesPath;
    private FileSystemTreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode favoritesNode;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private static final File[] defaultUserItems = new File[]{new File(AquaUtils.getProperty("user.home"), "Desktop"), new File(AquaUtils.getProperty("user.home"), "Documents"), new File(AquaUtils.getProperty("user.home"))};

    public SidebarTreeModel(JFileChooser jFileChooser, TreePath treePath, FileSystemTreeModel fileSystemTreeModel) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = jFileChooser;
        this.volumesPath = treePath;
        this.model = fileSystemTreeModel;
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.favoritesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.favorites"));
        this.favoritesNode.setAllowsChildren(true);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        defaultMutableTreeNode.add(this.favoritesNode);
        defaultMutableTreeNode.add(this.devicesNode);
        this.updateUserNode();
        this.updateDevicesNode();
        fileSystemTreeModel.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    public void invokeWhenValid(Runnable runnable) {
        runnable.run();
    }

    private void updateUserNode() {
        List<SidebarTreeNode> list = this.getUserFavorites();
        this.replaceNodes(this.favoritesNode, list, false);
    }

    private void updateDevicesNode() {
        Map<String, OSXFile.SystemItemInfo> map = this.readVolumes();
        boolean[] blArray = new boolean[1];
        ArrayList<SidebarTreeNode> arrayList = new ArrayList<SidebarTreeNode>();
        OSXFile.SystemItemInfo systemItemInfo = map.get("Computer");
        if (systemItemInfo != null && systemItemInfo.isVisible()) {
            arrayList.add(this.createOrFindDeviceNode(systemItemInfo, blArray));
        }
        for (OSXFile.SystemItemInfo systemItemInfo2 : map.values()) {
            if (systemItemInfo2 == systemItemInfo) continue;
            String string = systemItemInfo2.getPath();
            File file = new File(string);
            SidebarTreeNode sidebarTreeNode = this.createOrFindDeviceNode(systemItemInfo2, blArray);
            if (arrayList.contains(sidebarTreeNode)) continue;
            arrayList.add(sidebarTreeNode);
        }
        Collections.sort(arrayList, new SidebarTreeNodeComparator());
        this.replaceNodes(this.devicesNode, arrayList, blArray[0]);
    }

    private SidebarTreeNode createOrFindDeviceNode(@NotNull OSXFile.SystemItemInfo systemItemInfo, boolean[] blArray) {
        File file = new File(systemItemInfo.getPath());
        int n = this.devicesNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            SidebarTreeNode sidebarTreeNode;
            TreeNode treeNode = this.devicesNode.getChildAt(i);
            if (!(treeNode instanceof SidebarTreeNode) || !file.equals((sidebarTreeNode = (SidebarTreeNode)treeNode).getResolvedFile())) continue;
            Icon icon = systemItemInfo.getIcon();
            if (icon != null && icon != sidebarTreeNode.getBasicIcon()) {
                blArray[0] = true;
            }
            sidebarTreeNode.update(systemItemInfo);
            return sidebarTreeNode;
        }
        return this.createNode(systemItemInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<? extends DefaultMutableTreeNode> list, boolean bl) {
        int n;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList3 = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n2 = defaultMutableTreeNode.getChildCount();
        for (n = 0; n < n2; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            if (!list.contains(defaultMutableTreeNode2)) {
                arrayList.add(defaultMutableTreeNode2);
                arrayList4.add(n);
                continue;
            }
            arrayList3.add(defaultMutableTreeNode2);
            arrayList6.add(list.indexOf(defaultMutableTreeNode2));
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode objectArray2 = list.get(i);
            if (objectArray2 == null || arrayList3.contains(objectArray2)) continue;
            arrayList2.add(objectArray2);
            arrayList5.add(i);
        }
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            defaultMutableTreeNode.removeAllChildren();
            for (DefaultMutableTreeNode i : list) {
                defaultMutableTreeNode.add(i);
            }
        }
        if (!arrayList.isEmpty()) {
            void objectArray3;
            int[] nArray = new int[arrayList.size()];
            boolean i = false;
            while (objectArray3 < nArray.length) {
                nArray[objectArray3] = (Integer)arrayList4.get((int)objectArray3);
                ++objectArray3;
            }
            Object[] objectArray = arrayList.toArray();
            this.fireTreeNodesRemoved(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
        if (!arrayList2.isEmpty()) {
            void var13_26;
            int[] nArray = new int[arrayList2.size()];
            boolean bl2 = false;
            while (var13_26 < nArray.length) {
                nArray[var13_26] = (Integer)arrayList5.get((int)var13_26);
                ++var13_26;
            }
            Object[] objectArray = arrayList2.toArray();
            this.fireTreeNodesInserted(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
        if (bl && !arrayList3.isEmpty()) {
            void var13_30;
            int[] nArray = new int[arrayList3.size()];
            boolean bl3 = false;
            while (var13_30 < nArray.length) {
                nArray[var13_30] = (Integer)arrayList6.get((int)var13_30);
                ++var13_30;
            }
            Object[] objectArray = arrayList3.toArray();
            this.fireTreeNodesChanged(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
    }

    private List<SidebarTreeNode> getUserFavorites() {
        ArrayList<SidebarTreeNode> arrayList = new ArrayList<SidebarTreeNode>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(0);
        for (OSXFile.SystemItemInfo systemItemInfo : list) {
            SidebarTreeNode sidebarTreeNode = this.createNode(systemItemInfo);
            arrayList.add(sidebarTreeNode);
        }
        return arrayList;
    }

    @NotNull
    private SidebarTreeNode createNode(@NotNull OSXFile.SystemItemInfo systemItemInfo) {
        String string = systemItemInfo.getPath();
        File file = new File(string);
        Icon icon = systemItemInfo.getIcon();
        if (icon == null) {
            icon = this.isTraversable(file) ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
        }
        return new SidebarTreeNode(systemItemInfo, icon);
    }

    private Map<String, OSXFile.SystemItemInfo> readVolumes() {
        HashMap<String, OSXFile.SystemItemInfo> hashMap = new HashMap<String, OSXFile.SystemItemInfo>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(1);
        for (OSXFile.SystemItemInfo systemItemInfo : list) {
            String string = systemItemInfo.getName();
            if (systemItemInfo.isComputer()) {
                string = "Computer";
            }
            hashMap.put(string, systemItemInfo);
        }
        return hashMap;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    public boolean isTraversable(File file) {
        if (OSXFile.isAvailable()) {
            return OSXFile.isTraversable(file);
        }
        return file.isDirectory();
    }

    private class SidebarTreeNodeComparator
    implements Comparator<SidebarTreeNode> {
        private SidebarTreeNodeComparator() {
        }

        @Override
        public int compare(@NotNull SidebarTreeNode sidebarTreeNode, @NotNull SidebarTreeNode sidebarTreeNode2) {
            return sidebarTreeNode.getSequenceNumber() - sidebarTreeNode2.getSequenceNumber();
        }
    }
}

