/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class SliderLayoutConfiguration
extends LayoutConfiguration {
    @NotNull
    private final AquaUIPainter.SliderWidget sw;
    @NotNull
    private final AquaUIPainter.Size size;
    private final int numberOfTickMarks;
    @NotNull
    private final AquaUIPainter.TickMarkPosition position;

    public SliderLayoutConfiguration(@NotNull AquaUIPainter.SliderWidget sliderWidget, @NotNull AquaUIPainter.Size size, int n, @NotNull AquaUIPainter.TickMarkPosition tickMarkPosition) {
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if (tickMarkPosition == AquaUIPainter.TickMarkPosition.LEFT || tickMarkPosition == AquaUIPainter.TickMarkPosition.RIGHT) {
                tickMarkPosition = AquaUIPainter.TickMarkPosition.BELOW;
            }
        } else if (!(sliderWidget != AquaUIPainter.SliderWidget.SLIDER_VERTICAL && sliderWidget != AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN || tickMarkPosition != AquaUIPainter.TickMarkPosition.ABOVE && tickMarkPosition != AquaUIPainter.TickMarkPosition.BELOW)) {
            tickMarkPosition = AquaUIPainter.TickMarkPosition.LEFT;
        }
        this.sw = sliderWidget;
        this.size = size;
        this.numberOfTickMarks = n;
        this.position = tickMarkPosition;
    }

    protected SliderLayoutConfiguration(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        this.sw = sliderLayoutConfiguration.getWidget();
        this.size = sliderLayoutConfiguration.getSize();
        this.numberOfTickMarks = sliderLayoutConfiguration.getNumberOfTickMarks();
        this.position = sliderLayoutConfiguration.getTickMarkPosition();
    }

    @NotNull
    public AquaUIPainter.SliderWidget getWidget() {
        return this.sw;
    }

    @NotNull
    public AquaUIPainter.Size getSize() {
        return this.size;
    }

    public int getNumberOfTickMarks() {
        return this.numberOfTickMarks;
    }

    public boolean hasTickMarks() {
        return this.numberOfTickMarks > 0;
    }

    @NotNull
    public AquaUIPainter.TickMarkPosition getTickMarkPosition() {
        return this.position;
    }

    public boolean isVertical() {
        return this.sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL || this.sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN;
    }

    public boolean isHorizontal() {
        return this.sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || this.sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SliderLayoutConfiguration sliderLayoutConfiguration = (SliderLayoutConfiguration)object;
        return this.sw == sliderLayoutConfiguration.sw && this.size == sliderLayoutConfiguration.size && this.numberOfTickMarks == sliderLayoutConfiguration.numberOfTickMarks && this.position == sliderLayoutConfiguration.position;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sw, this.size, this.numberOfTickMarks, this.position});
    }

    @NotNull
    public String toString() {
        String string = "";
        if (this.numberOfTickMarks > 0) {
            string = " " + (Object)((Object)this.position);
        }
        return (Object)((Object)this.sw) + " " + (Object)((Object)this.size) + string;
    }
}

