/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;

public class TitleBarConfiguration
extends TitleBarLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State titleBarState;
    @NotNull
    private final AquaUIPainter.State closeButtonState;
    @NotNull
    private final AquaUIPainter.State minimizeButtonState;
    @NotNull
    private final AquaUIPainter.State resizeButtonState;
    @NotNull
    private final ResizeAction resizeAction;
    private final boolean isDirty;

    public TitleBarConfiguration(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.State state2, @NotNull AquaUIPainter.State state3, @NotNull AquaUIPainter.State state4, @NotNull ResizeAction resizeAction, boolean bl) {
        super(titleBarWidget);
        boolean bl2 = state != AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.DISABLED_INACTIVE;
        AquaUIPainter.State state5 = state = bl2 ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
        if (bl2 && state2 == AquaUIPainter.State.INACTIVE) {
            state2 = AquaUIPainter.State.ACTIVE;
        }
        if (titleBarWidget != AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW) {
            if (resizeAction == ResizeAction.FULL_SCREEN_ENTER) {
                resizeAction = ResizeAction.ZOOM_ENTER;
            } else if (resizeAction == ResizeAction.FULL_SCREEN_EXIT) {
                resizeAction = ResizeAction.ZOOM_EXIT;
            }
        }
        this.titleBarState = state;
        this.closeButtonState = state2;
        this.minimizeButtonState = state3;
        this.resizeButtonState = state4;
        this.resizeAction = resizeAction;
        this.isDirty = bl;
    }

    @NotNull
    public AquaUIPainter.State getTitleBarState() {
        return this.titleBarState;
    }

    @NotNull
    public AquaUIPainter.State getCloseButtonState() {
        return this.closeButtonState;
    }

    @NotNull
    public AquaUIPainter.State getMinimizeButtonState() {
        return this.minimizeButtonState;
    }

    @NotNull
    public AquaUIPainter.State getResizeButtonState() {
        return this.resizeButtonState;
    }

    @NotNull
    public ResizeAction getResizeAction() {
        return this.resizeAction;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TitleBarConfiguration titleBarConfiguration = (TitleBarConfiguration)object;
        return this.titleBarState == titleBarConfiguration.titleBarState && this.closeButtonState == titleBarConfiguration.closeButtonState && this.minimizeButtonState == titleBarConfiguration.minimizeButtonState && this.resizeButtonState == titleBarConfiguration.resizeButtonState && this.resizeAction == titleBarConfiguration.resizeAction && this.isDirty == titleBarConfiguration.isDirty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.titleBarState, this.closeButtonState, this.minimizeButtonState, this.resizeButtonState, this.resizeAction, this.isDirty});
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.isDirty ? " dirty" : "";
        return super.toString() + " " + (Object)((Object)this.titleBarState) + string + " close:" + (Object)((Object)this.closeButtonState) + " minimize:" + (Object)((Object)this.minimizeButtonState) + " resize:" + (Object)((Object)this.resizeButtonState) + " " + (Object)((Object)this.resizeAction);
    }

    public static enum ResizeAction {
        FULL_SCREEN_ENTER,
        FULL_SCREEN_EXIT,
        ZOOM_ENTER,
        ZOOM_EXIT;

    }
}

