/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderVerticalTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x;
    protected final double y0;
    protected final double y1;
    protected final int tickCount;

    public SliderVerticalTickPainter(@NotNull Color color, double d, double d2, double d3, double d4, double d5, int n) {
        this.color = color;
        this.w = d;
        this.h = d2;
        this.x = d3;
        this.y0 = d4;
        this.y1 = d5;
        this.tickCount = n;
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(graphics2D, this.y0);
        } else {
            double d = (this.y1 - this.y0) / (double)(this.tickCount - 1);
            double d2 = this.y0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(graphics2D, d2);
                d2 += d;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D graphics2D, double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.x, d - this.w / 2.0, this.h, this.w);
        graphics2D.fill(double_);
    }
}

