/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.JNR8MultiResolutionImage;
import org.violetlib.jnr.impl.JavaSupport;

public class Java8Support
implements JavaSupport.JavaSupportImpl {
    @NotNull
    private static final WeakHashMap<Graphics, Integer> scaleMap = new WeakHashMap();

    @Override
    public int getScaleFactor(@NotNull Graphics graphics) {
        int n;
        Integer n2 = scaleMap.get(graphics);
        if (n2 != null) {
            return n2;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            n = Java8Support.getScaleFactor(graphicsConfiguration);
        } else {
            n = 1;
        }
        scaleMap.put(graphics, n);
        return n;
    }

    private static int getScaleFactor(@NotNull GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Object object = null;
        try {
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                object = field.get(graphicsDevice);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    @Override
    public Image createMultiResolutionImage(int n, int n2, @NotNull BufferedImage bufferedImage) {
        return new JNR8MultiResolutionImage(n, n2, bufferedImage);
    }
}

