/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class OffsetRendererX
extends Renderer {
    @NotNull
    private final Renderer source;
    private final float x;
    private final float y;
    private final float w;
    private final float h;

    public OffsetRendererX(@NotNull Renderer renderer, float f, float f2, float f3, float f4) {
        this.source = renderer;
        this.x = f;
        this.y = f2;
        this.w = f3;
        this.h = f4;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        if (this.source instanceof BasicRendererRenderer) {
            BasicRendererRenderer basicRendererRenderer = (BasicRendererRenderer)this.source;
            BasicRenderer basicRenderer = basicRendererRenderer.getBasicRenderer();
            RendererDescription rendererDescription = basicRendererRenderer.getRendererDescription();
            if (rendererDescription.isTrivial()) {
                int n = reusableCompositor.getScaleFactor();
                int n2 = Math.round((float)n * this.x);
                int n3 = Math.round((float)n * this.y);
                int n4 = (int)Math.ceil((float)n * this.w);
                int n5 = (int)Math.ceil((float)n * this.h);
                reusableCompositor.composeRenderer(basicRenderer, n2, n3, n4, n5);
            } else {
                int n = reusableCompositor.getScaleFactor();
                Rectangle2D.Float float_ = new Rectangle2D.Float(this.x, this.y, this.w, this.h);
                RasterDescription rasterDescription = rendererDescription.getRasterBounds(float_, n);
                int n6 = Math.round((float)n * rasterDescription.getX());
                int n7 = Math.round((float)n * rasterDescription.getY());
                int n8 = (int)Math.ceil((float)n * rasterDescription.getWidth());
                int n9 = (int)Math.ceil((float)n * rasterDescription.getHeight());
                reusableCompositor.composeRenderer(basicRenderer, n6, n7, n8, n9);
            }
        } else if (this.source instanceof PainterExtensionRenderer) {
            PainterExtensionRenderer painterExtensionRenderer = (PainterExtensionRenderer)this.source;
            PainterExtension painterExtension = painterExtensionRenderer.getPainterExtension();
            int n = reusableCompositor.getScaleFactor();
            int n10 = Math.round((float)n * this.x);
            int n11 = Math.round((float)n * this.y);
            int n12 = (int)Math.ceil((float)n * this.w);
            int n13 = (int)Math.ceil((float)n * this.h);
            reusableCompositor.composePainter(painterExtension, n10, n11, n12, n13);
        }
    }
}

