# Contributing to the KeyStore Explorer Project

First of all, thanks for taking the time to contribute! 

The following is a set of suggestions and guidelines for contributing to KSE. They make it easier for users who would like to get involved.

## How Can I Contribute?

### Reporting Bugs

One of the best ways you can help us improve KSE is to let us know about any problems you find with it.

The KSE project uses [GitHub issues](https://github.com/kaikramer/keystore-explorer/issues) to report and track bugs.

Before you file an issue, search for it to see if anyone has already reported it. If you find your issue, check if you can provide additional information, that might be useful to resolve the issue.

If no one has reported your bug, file the bug. Please describe the problem in detail. Be sure to include:
* Steps to reproduce the problem.
* What happened.
* What you think the correct behavior should be.
* Don't forget to mention which operating system and which version of Java and KSE you're using.

In general, put as much information in bugs as you can. The more detail you provide, the more likely your issue is to be resolved.

**Important:** Please be on the lookout for any follow-up questions we may have.

### Contributing to the Code 

If you want to contribute to the code, go to GitHub, fork the KSE repository, apply your changes and open a pull request (PR). GitHub provides detailed information on the process on their website:
[GitHub - Contributing to a Project](https://guides.github.com/activities/contributing-to-open-source/#contributing)

In order to make the review of the PR a pleasant experience for contributors and reviewers and to preserve the quality of the code base, it is important to:
* Make sure the code changes are well tested and that they cause no unwanted side effects.
* Verify that all existing and new tests pass.
* Check that the code formatting matches the existing code.
* Make sure no unrelated or unnecessary reformatting changes are included.

If you intend to implement a non-trivial enhancement or a new feature, please make sure there is an [issue](https://github.com/kaikramer/keystore-explorer/issues) that corresponds to your contribution &ndash; either created by you or by somebody else. Announce in the issue that you intend to work on it to make sure that the work is not done twice. This is also a good way to get some guidance on how 	to beste tackle a problem or discuss implementation ideas. It is also necessary to sign a Contributor License Agreement (CLA) in this case.

### Contributing to the Documentation or Website

Good documentation is crucial for any kind of software. You can help improving the documentation:
* Please report missing, incorrect, or out-dated documentation as an [issue](https://github.com/kaikramer/keystore-explorer/issues).
* The [KSE website](http://keystore-explorer.org) is in a [GitHub repository](https://github.com/kaikramer/kaikramer.github.io) just like the KSE source code, which means improvements for the website can be contributed in the same way as code contributions. Or you could open an [issue](https://github.com/kaikramer/keystore-explorer/issues) if you think the website could be improved, but don't want to do it yourself.

### Translations

You are welcome to translate the KSE application or documentation into your own language. Just create an [issue](https://github.com/kaikramer/keystore-explorer/issues) where you announce that you want to work on translating KSE in a certain language.

Also, if you find any problems with existing translations, either create a new [issue](https://github.com/kaikramer/keystore-explorer/issues) or fix them and create a pull request.

It is highly recommended to use [ResourceBundle Editor](https://essiembre.github.io/eclipse-rbe/) when working on the translation files. 