%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: September 30, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedCoreProperties-6.1.0.txt
# Date: 2011-12-11, 18:26:55 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

% ================================================
*/

unicode_xid_start(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_xid_start(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_xid_start(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_xid_start(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

% Derived Property: XID_Start
%  ID_Start modified for closure under NFKx
%  Modified as described in UAX #15
%  NOTE: Does NOT remove the non-NFKx characters.
%        Merely ensures that if isIdentifer(string) then isIdentifier(NFKx(string))
%  NOTE: See UAX #31 for more information

unicode_xid_start(0x0041, 0x005A).	% XID_Start L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_xid_start(0x0061, 0x007A).	% XID_Start L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_xid_start(0x00AA, 0x00AA).	% XID_Start Lo       FEMININE ORDINAL INDICATOR
unicode_xid_start(0x00B5, 0x00B5).	% XID_Start L&       MICRO SIGN
unicode_xid_start(0x00BA, 0x00BA).	% XID_Start Lo       MASCULINE ORDINAL INDICATOR
unicode_xid_start(0x00C0, 0x00D6).	% XID_Start L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_xid_start(0x00D8, 0x00F6).	% XID_Start L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_xid_start(0x00F8, 0x01BA).	% XID_Start L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_xid_start(0x01BB, 0x01BB).	% XID_Start Lo       LATIN LETTER TWO WITH STROKE
unicode_xid_start(0x01BC, 0x01BF).	% XID_Start L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_xid_start(0x01C0, 0x01C3).	% XID_Start Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_xid_start(0x01C4, 0x0293).	% XID_Start L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_xid_start(0x0294, 0x0294).	% XID_Start Lo       LATIN LETTER GLOTTAL STOP
unicode_xid_start(0x0295, 0x02AF).	% XID_Start L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_xid_start(0x02B0, 0x02C1).	% XID_Start Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_xid_start(0x02C6, 0x02D1).	% XID_Start Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_xid_start(0x02E0, 0x02E4).	% XID_Start Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_xid_start(0x02EC, 0x02EC).	% XID_Start Lm       MODIFIER LETTER VOICING
unicode_xid_start(0x02EE, 0x02EE).	% XID_Start Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_xid_start(0x0370, 0x0373).	% XID_Start L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_xid_start(0x0374, 0x0374).	% XID_Start Lm       GREEK NUMERAL SIGN
unicode_xid_start(0x0376, 0x0377).	% XID_Start L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_xid_start(0x037B, 0x037D).	% XID_Start L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_xid_start(0x0386, 0x0386).	% XID_Start L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_xid_start(0x0388, 0x038A).	% XID_Start L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_xid_start(0x038C, 0x038C).	% XID_Start L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_xid_start(0x038E, 0x03A1).	% XID_Start L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_xid_start(0x03A3, 0x03F5).	% XID_Start L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_xid_start(0x03F7, 0x0481).	% XID_Start L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_xid_start(0x048A, 0x0527).	% XID_Start L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_xid_start(0x0531, 0x0556).	% XID_Start L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_xid_start(0x0559, 0x0559).	% XID_Start Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_xid_start(0x0561, 0x0587).	% XID_Start L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_xid_start(0x05D0, 0x05EA).	% XID_Start Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_xid_start(0x05F0, 0x05F2).	% XID_Start Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_xid_start(0x0620, 0x063F).	% XID_Start Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_xid_start(0x0640, 0x0640).	% XID_Start Lm       ARABIC TATWEEL
unicode_xid_start(0x0641, 0x064A).	% XID_Start Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_xid_start(0x066E, 0x066F).	% XID_Start Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_xid_start(0x0671, 0x06D3).	% XID_Start Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_xid_start(0x06D5, 0x06D5).	% XID_Start Lo       ARABIC LETTER AE
unicode_xid_start(0x06E5, 0x06E6).	% XID_Start Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_xid_start(0x06EE, 0x06EF).	% XID_Start Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_xid_start(0x06FA, 0x06FC).	% XID_Start Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_xid_start(0x06FF, 0x06FF).	% XID_Start Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_xid_start(0x0710, 0x0710).	% XID_Start Lo       SYRIAC LETTER ALAPH
unicode_xid_start(0x0712, 0x072F).	% XID_Start Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_xid_start(0x074D, 0x07A5).	% XID_Start Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_xid_start(0x07B1, 0x07B1).	% XID_Start Lo       THAANA LETTER NAA
unicode_xid_start(0x07CA, 0x07EA).	% XID_Start Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_xid_start(0x07F4, 0x07F5).	% XID_Start Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_xid_start(0x07FA, 0x07FA).	% XID_Start Lm       NKO LAJANYALAN
unicode_xid_start(0x0800, 0x0815).	% XID_Start Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_xid_start(0x081A, 0x081A).	% XID_Start Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_xid_start(0x0824, 0x0824).	% XID_Start Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_xid_start(0x0828, 0x0828).	% XID_Start Lm       SAMARITAN MODIFIER LETTER I
unicode_xid_start(0x0840, 0x0858).	% XID_Start Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_xid_start(0x08A0, 0x08A0).	% XID_Start Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_xid_start(0x08A2, 0x08AC).	% XID_Start Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_xid_start(0x0904, 0x0939).	% XID_Start Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_xid_start(0x093D, 0x093D).	% XID_Start Lo       DEVANAGARI SIGN AVAGRAHA
unicode_xid_start(0x0950, 0x0950).	% XID_Start Lo       DEVANAGARI OM
unicode_xid_start(0x0958, 0x0961).	% XID_Start Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_xid_start(0x0971, 0x0971).	% XID_Start Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_xid_start(0x0972, 0x0977).	% XID_Start Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_xid_start(0x0979, 0x097F).	% XID_Start Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_xid_start(0x0985, 0x098C).	% XID_Start Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_xid_start(0x098F, 0x0990).	% XID_Start Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_xid_start(0x0993, 0x09A8).	% XID_Start Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_xid_start(0x09AA, 0x09B0).	% XID_Start Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_xid_start(0x09B2, 0x09B2).	% XID_Start Lo       BENGALI LETTER LA
unicode_xid_start(0x09B6, 0x09B9).	% XID_Start Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_xid_start(0x09BD, 0x09BD).	% XID_Start Lo       BENGALI SIGN AVAGRAHA
unicode_xid_start(0x09CE, 0x09CE).	% XID_Start Lo       BENGALI LETTER KHANDA TA
unicode_xid_start(0x09DC, 0x09DD).	% XID_Start Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_xid_start(0x09DF, 0x09E1).	% XID_Start Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_xid_start(0x09F0, 0x09F1).	% XID_Start Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_xid_start(0x0A05, 0x0A0A).	% XID_Start Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_xid_start(0x0A0F, 0x0A10).	% XID_Start Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_xid_start(0x0A13, 0x0A28).	% XID_Start Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_xid_start(0x0A2A, 0x0A30).	% XID_Start Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_xid_start(0x0A32, 0x0A33).	% XID_Start Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_xid_start(0x0A35, 0x0A36).	% XID_Start Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_xid_start(0x0A38, 0x0A39).	% XID_Start Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_xid_start(0x0A59, 0x0A5C).	% XID_Start Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_xid_start(0x0A5E, 0x0A5E).	% XID_Start Lo       GURMUKHI LETTER FA
unicode_xid_start(0x0A72, 0x0A74).	% XID_Start Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_xid_start(0x0A85, 0x0A8D).	% XID_Start Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_xid_start(0x0A8F, 0x0A91).	% XID_Start Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_xid_start(0x0A93, 0x0AA8).	% XID_Start Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_xid_start(0x0AAA, 0x0AB0).	% XID_Start Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_xid_start(0x0AB2, 0x0AB3).	% XID_Start Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_xid_start(0x0AB5, 0x0AB9).	% XID_Start Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_xid_start(0x0ABD, 0x0ABD).	% XID_Start Lo       GUJARATI SIGN AVAGRAHA
unicode_xid_start(0x0AD0, 0x0AD0).	% XID_Start Lo       GUJARATI OM
unicode_xid_start(0x0AE0, 0x0AE1).	% XID_Start Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_xid_start(0x0B05, 0x0B0C).	% XID_Start Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_xid_start(0x0B0F, 0x0B10).	% XID_Start Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_xid_start(0x0B13, 0x0B28).	% XID_Start Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_xid_start(0x0B2A, 0x0B30).	% XID_Start Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_xid_start(0x0B32, 0x0B33).	% XID_Start Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_xid_start(0x0B35, 0x0B39).	% XID_Start Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_xid_start(0x0B3D, 0x0B3D).	% XID_Start Lo       ORIYA SIGN AVAGRAHA
unicode_xid_start(0x0B5C, 0x0B5D).	% XID_Start Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_xid_start(0x0B5F, 0x0B61).	% XID_Start Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_xid_start(0x0B71, 0x0B71).	% XID_Start Lo       ORIYA LETTER WA
unicode_xid_start(0x0B83, 0x0B83).	% XID_Start Lo       TAMIL SIGN VISARGA
unicode_xid_start(0x0B85, 0x0B8A).	% XID_Start Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_xid_start(0x0B8E, 0x0B90).	% XID_Start Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_xid_start(0x0B92, 0x0B95).	% XID_Start Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_xid_start(0x0B99, 0x0B9A).	% XID_Start Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_xid_start(0x0B9C, 0x0B9C).	% XID_Start Lo       TAMIL LETTER JA
unicode_xid_start(0x0B9E, 0x0B9F).	% XID_Start Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_xid_start(0x0BA3, 0x0BA4).	% XID_Start Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_xid_start(0x0BA8, 0x0BAA).	% XID_Start Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_xid_start(0x0BAE, 0x0BB9).	% XID_Start Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_xid_start(0x0BD0, 0x0BD0).	% XID_Start Lo       TAMIL OM
unicode_xid_start(0x0C05, 0x0C0C).	% XID_Start Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_xid_start(0x0C0E, 0x0C10).	% XID_Start Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_xid_start(0x0C12, 0x0C28).	% XID_Start Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_xid_start(0x0C2A, 0x0C33).	% XID_Start Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_xid_start(0x0C35, 0x0C39).	% XID_Start Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_xid_start(0x0C3D, 0x0C3D).	% XID_Start Lo       TELUGU SIGN AVAGRAHA
unicode_xid_start(0x0C58, 0x0C59).	% XID_Start Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_xid_start(0x0C60, 0x0C61).	% XID_Start Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_xid_start(0x0C85, 0x0C8C).	% XID_Start Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_xid_start(0x0C8E, 0x0C90).	% XID_Start Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_xid_start(0x0C92, 0x0CA8).	% XID_Start Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_xid_start(0x0CAA, 0x0CB3).	% XID_Start Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_xid_start(0x0CB5, 0x0CB9).	% XID_Start Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_xid_start(0x0CBD, 0x0CBD).	% XID_Start Lo       KANNADA SIGN AVAGRAHA
unicode_xid_start(0x0CDE, 0x0CDE).	% XID_Start Lo       KANNADA LETTER FA
unicode_xid_start(0x0CE0, 0x0CE1).	% XID_Start Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_xid_start(0x0CF1, 0x0CF2).	% XID_Start Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_xid_start(0x0D05, 0x0D0C).	% XID_Start Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_xid_start(0x0D0E, 0x0D10).	% XID_Start Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_xid_start(0x0D12, 0x0D3A).	% XID_Start Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_xid_start(0x0D3D, 0x0D3D).	% XID_Start Lo       MALAYALAM SIGN AVAGRAHA
unicode_xid_start(0x0D4E, 0x0D4E).	% XID_Start Lo       MALAYALAM LETTER DOT REPH
unicode_xid_start(0x0D60, 0x0D61).	% XID_Start Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_xid_start(0x0D7A, 0x0D7F).	% XID_Start Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_xid_start(0x0D85, 0x0D96).	% XID_Start Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_xid_start(0x0D9A, 0x0DB1).	% XID_Start Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_xid_start(0x0DB3, 0x0DBB).	% XID_Start Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_xid_start(0x0DBD, 0x0DBD).	% XID_Start Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_xid_start(0x0DC0, 0x0DC6).	% XID_Start Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_xid_start(0x0E01, 0x0E30).	% XID_Start Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_xid_start(0x0E32, 0x0E32).	% XID_Start Lo       THAI CHARACTER SARA AA
unicode_xid_start(0x0E40, 0x0E45).	% XID_Start Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_xid_start(0x0E46, 0x0E46).	% XID_Start Lm       THAI CHARACTER MAIYAMOK
unicode_xid_start(0x0E81, 0x0E82).	% XID_Start Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_xid_start(0x0E84, 0x0E84).	% XID_Start Lo       LAO LETTER KHO TAM
unicode_xid_start(0x0E87, 0x0E88).	% XID_Start Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_xid_start(0x0E8A, 0x0E8A).	% XID_Start Lo       LAO LETTER SO TAM
unicode_xid_start(0x0E8D, 0x0E8D).	% XID_Start Lo       LAO LETTER NYO
unicode_xid_start(0x0E94, 0x0E97).	% XID_Start Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_xid_start(0x0E99, 0x0E9F).	% XID_Start Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_xid_start(0x0EA1, 0x0EA3).	% XID_Start Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_xid_start(0x0EA5, 0x0EA5).	% XID_Start Lo       LAO LETTER LO LOOT
unicode_xid_start(0x0EA7, 0x0EA7).	% XID_Start Lo       LAO LETTER WO
unicode_xid_start(0x0EAA, 0x0EAB).	% XID_Start Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_xid_start(0x0EAD, 0x0EB0).	% XID_Start Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_xid_start(0x0EB2, 0x0EB2).	% XID_Start Lo       LAO VOWEL SIGN AA
unicode_xid_start(0x0EBD, 0x0EBD).	% XID_Start Lo       LAO SEMIVOWEL SIGN NYO
unicode_xid_start(0x0EC0, 0x0EC4).	% XID_Start Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_xid_start(0x0EC6, 0x0EC6).	% XID_Start Lm       LAO KO LA
unicode_xid_start(0x0EDC, 0x0EDF).	% XID_Start Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_xid_start(0x0F00, 0x0F00).	% XID_Start Lo       TIBETAN SYLLABLE OM
unicode_xid_start(0x0F40, 0x0F47).	% XID_Start Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_xid_start(0x0F49, 0x0F6C).	% XID_Start Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_xid_start(0x0F88, 0x0F8C).	% XID_Start Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_xid_start(0x1000, 0x102A).	% XID_Start Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_xid_start(0x103F, 0x103F).	% XID_Start Lo       MYANMAR LETTER GREAT SA
unicode_xid_start(0x1050, 0x1055).	% XID_Start Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_xid_start(0x105A, 0x105D).	% XID_Start Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_xid_start(0x1061, 0x1061).	% XID_Start Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_xid_start(0x1065, 0x1066).	% XID_Start Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_xid_start(0x106E, 0x1070).	% XID_Start Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_xid_start(0x1075, 0x1081).	% XID_Start Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_xid_start(0x108E, 0x108E).	% XID_Start Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_xid_start(0x10A0, 0x10C5).	% XID_Start L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_xid_start(0x10C7, 0x10C7).	% XID_Start L&       GEORGIAN CAPITAL LETTER YN
unicode_xid_start(0x10CD, 0x10CD).	% XID_Start L&       GEORGIAN CAPITAL LETTER AEN
unicode_xid_start(0x10D0, 0x10FA).	% XID_Start Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_xid_start(0x10FC, 0x10FC).	% XID_Start Lm       MODIFIER LETTER GEORGIAN NAR
unicode_xid_start(0x10FD, 0x1248).	% XID_Start Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_xid_start(0x124A, 0x124D).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_xid_start(0x1250, 0x1256).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_xid_start(0x1258, 0x1258).	% XID_Start Lo       ETHIOPIC SYLLABLE QHWA
unicode_xid_start(0x125A, 0x125D).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_xid_start(0x1260, 0x1288).	% XID_Start Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_xid_start(0x128A, 0x128D).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_xid_start(0x1290, 0x12B0).	% XID_Start Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_xid_start(0x12B2, 0x12B5).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_xid_start(0x12B8, 0x12BE).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_xid_start(0x12C0, 0x12C0).	% XID_Start Lo       ETHIOPIC SYLLABLE KXWA
unicode_xid_start(0x12C2, 0x12C5).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_xid_start(0x12C8, 0x12D6).	% XID_Start Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_xid_start(0x12D8, 0x1310).	% XID_Start Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_xid_start(0x1312, 0x1315).	% XID_Start Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_xid_start(0x1318, 0x135A).	% XID_Start Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_xid_start(0x1380, 0x138F).	% XID_Start Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_xid_start(0x13A0, 0x13F4).	% XID_Start Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_xid_start(0x1401, 0x166C).	% XID_Start Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_xid_start(0x166F, 0x167F).	% XID_Start Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_xid_start(0x1681, 0x169A).	% XID_Start Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_xid_start(0x16A0, 0x16EA).	% XID_Start Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_xid_start(0x16EE, 0x16F0).	% XID_Start Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_xid_start(0x1700, 0x170C).	% XID_Start Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_xid_start(0x170E, 0x1711).	% XID_Start Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_xid_start(0x1720, 0x1731).	% XID_Start Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_xid_start(0x1740, 0x1751).	% XID_Start Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_xid_start(0x1760, 0x176C).	% XID_Start Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_xid_start(0x176E, 0x1770).	% XID_Start Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_xid_start(0x1780, 0x17B3).	% XID_Start Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_xid_start(0x17D7, 0x17D7).	% XID_Start Lm       KHMER SIGN LEK TOO
unicode_xid_start(0x17DC, 0x17DC).	% XID_Start Lo       KHMER SIGN AVAKRAHASANYA
unicode_xid_start(0x1820, 0x1842).	% XID_Start Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_xid_start(0x1843, 0x1843).	% XID_Start Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_xid_start(0x1844, 0x1877).	% XID_Start Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_xid_start(0x1880, 0x18A8).	% XID_Start Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_xid_start(0x18AA, 0x18AA).	% XID_Start Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_xid_start(0x18B0, 0x18F5).	% XID_Start Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_xid_start(0x1900, 0x191C).	% XID_Start Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_xid_start(0x1950, 0x196D).	% XID_Start Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_xid_start(0x1970, 0x1974).	% XID_Start Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_xid_start(0x1980, 0x19AB).	% XID_Start Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_xid_start(0x19C1, 0x19C7).	% XID_Start Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_xid_start(0x1A00, 0x1A16).	% XID_Start Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_xid_start(0x1A20, 0x1A54).	% XID_Start Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_xid_start(0x1AA7, 0x1AA7).	% XID_Start Lm       TAI THAM SIGN MAI YAMOK
unicode_xid_start(0x1B05, 0x1B33).	% XID_Start Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_xid_start(0x1B45, 0x1B4B).	% XID_Start Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_xid_start(0x1B83, 0x1BA0).	% XID_Start Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_xid_start(0x1BAE, 0x1BAF).	% XID_Start Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_xid_start(0x1BBA, 0x1BE5).	% XID_Start Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_xid_start(0x1C00, 0x1C23).	% XID_Start Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_xid_start(0x1C4D, 0x1C4F).	% XID_Start Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_xid_start(0x1C5A, 0x1C77).	% XID_Start Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_xid_start(0x1C78, 0x1C7D).	% XID_Start Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_xid_start(0x1CE9, 0x1CEC).	% XID_Start Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_xid_start(0x1CEE, 0x1CF1).	% XID_Start Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_xid_start(0x1CF5, 0x1CF6).	% XID_Start Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_xid_start(0x1D00, 0x1D2B).	% XID_Start L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_xid_start(0x1D2C, 0x1D6A).	% XID_Start Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_xid_start(0x1D6B, 0x1D77).	% XID_Start L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_xid_start(0x1D78, 0x1D78).	% XID_Start Lm       MODIFIER LETTER CYRILLIC EN
unicode_xid_start(0x1D79, 0x1D9A).	% XID_Start L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_xid_start(0x1D9B, 0x1DBF).	% XID_Start Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_xid_start(0x1E00, 0x1F15).	% XID_Start L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_xid_start(0x1F18, 0x1F1D).	% XID_Start L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_xid_start(0x1F20, 0x1F45).	% XID_Start L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_xid_start(0x1F48, 0x1F4D).	% XID_Start L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_xid_start(0x1F50, 0x1F57).	% XID_Start L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_xid_start(0x1F59, 0x1F59).	% XID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_xid_start(0x1F5B, 0x1F5B).	% XID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_xid_start(0x1F5D, 0x1F5D).	% XID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_xid_start(0x1F5F, 0x1F7D).	% XID_Start L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_xid_start(0x1F80, 0x1FB4).	% XID_Start L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_xid_start(0x1FB6, 0x1FBC).	% XID_Start L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_xid_start(0x1FBE, 0x1FBE).	% XID_Start L&       GREEK PROSGEGRAMMENI
unicode_xid_start(0x1FC2, 0x1FC4).	% XID_Start L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_xid_start(0x1FC6, 0x1FCC).	% XID_Start L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_xid_start(0x1FD0, 0x1FD3).	% XID_Start L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_xid_start(0x1FD6, 0x1FDB).	% XID_Start L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_xid_start(0x1FE0, 0x1FEC).	% XID_Start L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_xid_start(0x1FF2, 0x1FF4).	% XID_Start L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_xid_start(0x1FF6, 0x1FFC).	% XID_Start L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_xid_start(0x2071, 0x2071).	% XID_Start Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_xid_start(0x207F, 0x207F).	% XID_Start Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_xid_start(0x2090, 0x209C).	% XID_Start Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_xid_start(0x2102, 0x2102).	% XID_Start L&       DOUBLE-STRUCK CAPITAL C
unicode_xid_start(0x2107, 0x2107).	% XID_Start L&       EULER CONSTANT
unicode_xid_start(0x210A, 0x2113).	% XID_Start L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_xid_start(0x2115, 0x2115).	% XID_Start L&       DOUBLE-STRUCK CAPITAL N
unicode_xid_start(0x2118, 0x2118).	% XID_Start Sm       SCRIPT CAPITAL P
unicode_xid_start(0x2119, 0x211D).	% XID_Start L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_xid_start(0x2124, 0x2124).	% XID_Start L&       DOUBLE-STRUCK CAPITAL Z
unicode_xid_start(0x2126, 0x2126).	% XID_Start L&       OHM SIGN
unicode_xid_start(0x2128, 0x2128).	% XID_Start L&       BLACK-LETTER CAPITAL Z
unicode_xid_start(0x212A, 0x212D).	% XID_Start L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_xid_start(0x212E, 0x212E).	% XID_Start So       ESTIMATED SYMBOL
unicode_xid_start(0x212F, 0x2134).	% XID_Start L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_xid_start(0x2135, 0x2138).	% XID_Start Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_xid_start(0x2139, 0x2139).	% XID_Start L&       INFORMATION SOURCE
unicode_xid_start(0x213C, 0x213F).	% XID_Start L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_xid_start(0x2145, 0x2149).	% XID_Start L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_xid_start(0x214E, 0x214E).	% XID_Start L&       TURNED SMALL F
unicode_xid_start(0x2160, 0x2182).	% XID_Start Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_xid_start(0x2183, 0x2184).	% XID_Start L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_xid_start(0x2185, 0x2188).	% XID_Start Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_xid_start(0x2C00, 0x2C2E).	% XID_Start L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_xid_start(0x2C30, 0x2C5E).	% XID_Start L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_xid_start(0x2C60, 0x2C7B).	% XID_Start L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_xid_start(0x2C7C, 0x2C7D).	% XID_Start Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_xid_start(0x2C7E, 0x2CE4).	% XID_Start L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_xid_start(0x2CEB, 0x2CEE).	% XID_Start L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_xid_start(0x2CF2, 0x2CF3).	% XID_Start L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_xid_start(0x2D00, 0x2D25).	% XID_Start L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_xid_start(0x2D27, 0x2D27).	% XID_Start L&       GEORGIAN SMALL LETTER YN
unicode_xid_start(0x2D2D, 0x2D2D).	% XID_Start L&       GEORGIAN SMALL LETTER AEN
unicode_xid_start(0x2D30, 0x2D67).	% XID_Start Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_xid_start(0x2D6F, 0x2D6F).	% XID_Start Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_xid_start(0x2D80, 0x2D96).	% XID_Start Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_xid_start(0x2DA0, 0x2DA6).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_xid_start(0x2DA8, 0x2DAE).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_xid_start(0x2DB0, 0x2DB6).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_xid_start(0x2DB8, 0x2DBE).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_xid_start(0x2DC0, 0x2DC6).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_xid_start(0x2DC8, 0x2DCE).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_xid_start(0x2DD0, 0x2DD6).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_xid_start(0x2DD8, 0x2DDE).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_xid_start(0x3005, 0x3005).	% XID_Start Lm       IDEOGRAPHIC ITERATION MARK
unicode_xid_start(0x3006, 0x3006).	% XID_Start Lo       IDEOGRAPHIC CLOSING MARK
unicode_xid_start(0x3007, 0x3007).	% XID_Start Nl       IDEOGRAPHIC NUMBER ZERO
unicode_xid_start(0x3021, 0x3029).	% XID_Start Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_xid_start(0x3031, 0x3035).	% XID_Start Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_xid_start(0x3038, 0x303A).	% XID_Start Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_xid_start(0x303B, 0x303B).	% XID_Start Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_xid_start(0x303C, 0x303C).	% XID_Start Lo       MASU MARK
unicode_xid_start(0x3041, 0x3096).	% XID_Start Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_xid_start(0x309D, 0x309E).	% XID_Start Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_xid_start(0x309F, 0x309F).	% XID_Start Lo       HIRAGANA DIGRAPH YORI
unicode_xid_start(0x30A1, 0x30FA).	% XID_Start Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_xid_start(0x30FC, 0x30FE).	% XID_Start Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_xid_start(0x30FF, 0x30FF).	% XID_Start Lo       KATAKANA DIGRAPH KOTO
unicode_xid_start(0x3105, 0x312D).	% XID_Start Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_xid_start(0x3131, 0x318E).	% XID_Start Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_xid_start(0x31A0, 0x31BA).	% XID_Start Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_xid_start(0x31F0, 0x31FF).	% XID_Start Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_xid_start(0x3400, 0x4DB5).	% XID_Start Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_xid_start(0x4E00, 0x9FCC).	% XID_Start Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_xid_start(0xA000, 0xA014).	% XID_Start Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_xid_start(0xA015, 0xA015).	% XID_Start Lm       YI SYLLABLE WU
unicode_xid_start(0xA016, 0xA48C).	% XID_Start Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_xid_start(0xA4D0, 0xA4F7).	% XID_Start Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_xid_start(0xA4F8, 0xA4FD).	% XID_Start Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_xid_start(0xA500, 0xA60B).	% XID_Start Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_xid_start(0xA60C, 0xA60C).	% XID_Start Lm       VAI SYLLABLE LENGTHENER
unicode_xid_start(0xA610, 0xA61F).	% XID_Start Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_xid_start(0xA62A, 0xA62B).	% XID_Start Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_xid_start(0xA640, 0xA66D).	% XID_Start L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_xid_start(0xA66E, 0xA66E).	% XID_Start Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_xid_start(0xA67F, 0xA67F).	% XID_Start Lm       CYRILLIC PAYEROK
unicode_xid_start(0xA680, 0xA697).	% XID_Start L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_xid_start(0xA6A0, 0xA6E5).	% XID_Start Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_xid_start(0xA6E6, 0xA6EF).	% XID_Start Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_xid_start(0xA717, 0xA71F).	% XID_Start Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_xid_start(0xA722, 0xA76F).	% XID_Start L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_xid_start(0xA770, 0xA770).	% XID_Start Lm       MODIFIER LETTER US
unicode_xid_start(0xA771, 0xA787).	% XID_Start L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_xid_start(0xA788, 0xA788).	% XID_Start Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_xid_start(0xA78B, 0xA78E).	% XID_Start L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_xid_start(0xA790, 0xA793).	% XID_Start L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_xid_start(0xA7A0, 0xA7AA).	% XID_Start L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_xid_start(0xA7F8, 0xA7F9).	% XID_Start Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_xid_start(0xA7FA, 0xA7FA).	% XID_Start L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_xid_start(0xA7FB, 0xA801).	% XID_Start Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_xid_start(0xA803, 0xA805).	% XID_Start Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_xid_start(0xA807, 0xA80A).	% XID_Start Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_xid_start(0xA80C, 0xA822).	% XID_Start Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_xid_start(0xA840, 0xA873).	% XID_Start Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_xid_start(0xA882, 0xA8B3).	% XID_Start Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_xid_start(0xA8F2, 0xA8F7).	% XID_Start Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_xid_start(0xA8FB, 0xA8FB).	% XID_Start Lo       DEVANAGARI HEADSTROKE
unicode_xid_start(0xA90A, 0xA925).	% XID_Start Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_xid_start(0xA930, 0xA946).	% XID_Start Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_xid_start(0xA960, 0xA97C).	% XID_Start Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_xid_start(0xA984, 0xA9B2).	% XID_Start Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_xid_start(0xA9CF, 0xA9CF).	% XID_Start Lm       JAVANESE PANGRANGKEP
unicode_xid_start(0xAA00, 0xAA28).	% XID_Start Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_xid_start(0xAA40, 0xAA42).	% XID_Start Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_xid_start(0xAA44, 0xAA4B).	% XID_Start Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_xid_start(0xAA60, 0xAA6F).	% XID_Start Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_xid_start(0xAA70, 0xAA70).	% XID_Start Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_xid_start(0xAA71, 0xAA76).	% XID_Start Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_xid_start(0xAA7A, 0xAA7A).	% XID_Start Lo       MYANMAR LETTER AITON RA
unicode_xid_start(0xAA80, 0xAAAF).	% XID_Start Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_xid_start(0xAAB1, 0xAAB1).	% XID_Start Lo       TAI VIET VOWEL AA
unicode_xid_start(0xAAB5, 0xAAB6).	% XID_Start Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_xid_start(0xAAB9, 0xAABD).	% XID_Start Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_xid_start(0xAAC0, 0xAAC0).	% XID_Start Lo       TAI VIET TONE MAI NUENG
unicode_xid_start(0xAAC2, 0xAAC2).	% XID_Start Lo       TAI VIET TONE MAI SONG
unicode_xid_start(0xAADB, 0xAADC).	% XID_Start Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_xid_start(0xAADD, 0xAADD).	% XID_Start Lm       TAI VIET SYMBOL SAM
unicode_xid_start(0xAAE0, 0xAAEA).	% XID_Start Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_xid_start(0xAAF2, 0xAAF2).	% XID_Start Lo       MEETEI MAYEK ANJI
unicode_xid_start(0xAAF3, 0xAAF4).	% XID_Start Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_xid_start(0xAB01, 0xAB06).	% XID_Start Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_xid_start(0xAB09, 0xAB0E).	% XID_Start Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_xid_start(0xAB11, 0xAB16).	% XID_Start Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_xid_start(0xAB20, 0xAB26).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_xid_start(0xAB28, 0xAB2E).	% XID_Start Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_xid_start(0xABC0, 0xABE2).	% XID_Start Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_xid_start(0xAC00, 0xD7A3).	% XID_Start Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_xid_start(0xD7B0, 0xD7C6).	% XID_Start Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_xid_start(0xD7CB, 0xD7FB).	% XID_Start Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_xid_start(0xF900, 0xFA6D).	% XID_Start Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_xid_start(0xFA70, 0xFAD9).	% XID_Start Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_xid_start(0xFB00, 0xFB06).	% XID_Start L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_xid_start(0xFB13, 0xFB17).	% XID_Start L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_xid_start(0xFB1D, 0xFB1D).	% XID_Start Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_xid_start(0xFB1F, 0xFB28).	% XID_Start Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_xid_start(0xFB2A, 0xFB36).	% XID_Start Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_xid_start(0xFB38, 0xFB3C).	% XID_Start Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_xid_start(0xFB3E, 0xFB3E).	% XID_Start Lo       HEBREW LETTER MEM WITH DAGESH
unicode_xid_start(0xFB40, 0xFB41).	% XID_Start Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_xid_start(0xFB43, 0xFB44).	% XID_Start Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_xid_start(0xFB46, 0xFBB1).	% XID_Start Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_xid_start(0xFBD3, 0xFC5D).	% XID_Start Lo [139] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
unicode_xid_start(0xFC64, 0xFD3D).	% XID_Start Lo [218] ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_xid_start(0xFD50, 0xFD8F).	% XID_Start Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_xid_start(0xFD92, 0xFDC7).	% XID_Start Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_xid_start(0xFDF0, 0xFDF9).	% XID_Start Lo  [10] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE SALLA ISOLATED FORM
unicode_xid_start(0xFE71, 0xFE71).	% XID_Start Lo       ARABIC TATWEEL WITH FATHATAN ABOVE
unicode_xid_start(0xFE73, 0xFE73).	% XID_Start Lo       ARABIC TAIL FRAGMENT
unicode_xid_start(0xFE77, 0xFE77).	% XID_Start Lo       ARABIC FATHA MEDIAL FORM
unicode_xid_start(0xFE79, 0xFE79).	% XID_Start Lo       ARABIC DAMMA MEDIAL FORM
unicode_xid_start(0xFE7B, 0xFE7B).	% XID_Start Lo       ARABIC KASRA MEDIAL FORM
unicode_xid_start(0xFE7D, 0xFE7D).	% XID_Start Lo       ARABIC SHADDA MEDIAL FORM
unicode_xid_start(0xFE7F, 0xFEFC).	% XID_Start Lo [126] ARABIC SUKUN MEDIAL FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_xid_start(0xFF21, 0xFF3A).	% XID_Start L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_xid_start(0xFF41, 0xFF5A).	% XID_Start L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_xid_start(0xFF66, 0xFF6F).	% XID_Start Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_xid_start(0xFF70, 0xFF70).	% XID_Start Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_xid_start(0xFF71, 0xFF9D).	% XID_Start Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_xid_start(0xFFA0, 0xFFBE).	% XID_Start Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_xid_start(0xFFC2, 0xFFC7).	% XID_Start Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_xid_start(0xFFCA, 0xFFCF).	% XID_Start Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_xid_start(0xFFD2, 0xFFD7).	% XID_Start Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_xid_start(0xFFDA, 0xFFDC).	% XID_Start Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_xid_start(0x10000, 0x1000B).	% XID_Start Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_xid_start(0x1000D, 0x10026).	% XID_Start Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_xid_start(0x10028, 0x1003A).	% XID_Start Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_xid_start(0x1003C, 0x1003D).	% XID_Start Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_xid_start(0x1003F, 0x1004D).	% XID_Start Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_xid_start(0x10050, 0x1005D).	% XID_Start Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_xid_start(0x10080, 0x100FA).	% XID_Start Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_xid_start(0x10140, 0x10174).	% XID_Start Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_xid_start(0x10280, 0x1029C).	% XID_Start Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_xid_start(0x102A0, 0x102D0).	% XID_Start Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_xid_start(0x10300, 0x1031E).	% XID_Start Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_xid_start(0x10330, 0x10340).	% XID_Start Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_xid_start(0x10341, 0x10341).	% XID_Start Nl       GOTHIC LETTER NINETY
unicode_xid_start(0x10342, 0x10349).	% XID_Start Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_xid_start(0x1034A, 0x1034A).	% XID_Start Nl       GOTHIC LETTER NINE HUNDRED
unicode_xid_start(0x10380, 0x1039D).	% XID_Start Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_xid_start(0x103A0, 0x103C3).	% XID_Start Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_xid_start(0x103C8, 0x103CF).	% XID_Start Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_xid_start(0x103D1, 0x103D5).	% XID_Start Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_xid_start(0x10400, 0x1044F).	% XID_Start L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_xid_start(0x10450, 0x1049D).	% XID_Start Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_xid_start(0x10800, 0x10805).	% XID_Start Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_xid_start(0x10808, 0x10808).	% XID_Start Lo       CYPRIOT SYLLABLE JO
unicode_xid_start(0x1080A, 0x10835).	% XID_Start Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_xid_start(0x10837, 0x10838).	% XID_Start Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_xid_start(0x1083C, 0x1083C).	% XID_Start Lo       CYPRIOT SYLLABLE ZA
unicode_xid_start(0x1083F, 0x10855).	% XID_Start Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_xid_start(0x10900, 0x10915).	% XID_Start Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_xid_start(0x10920, 0x10939).	% XID_Start Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_xid_start(0x10980, 0x109B7).	% XID_Start Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_xid_start(0x109BE, 0x109BF).	% XID_Start Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_xid_start(0x10A00, 0x10A00).	% XID_Start Lo       KHAROSHTHI LETTER A
unicode_xid_start(0x10A10, 0x10A13).	% XID_Start Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_xid_start(0x10A15, 0x10A17).	% XID_Start Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_xid_start(0x10A19, 0x10A33).	% XID_Start Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_xid_start(0x10A60, 0x10A7C).	% XID_Start Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_xid_start(0x10B00, 0x10B35).	% XID_Start Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_xid_start(0x10B40, 0x10B55).	% XID_Start Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_xid_start(0x10B60, 0x10B72).	% XID_Start Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_xid_start(0x10C00, 0x10C48).	% XID_Start Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_xid_start(0x11003, 0x11037).	% XID_Start Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_xid_start(0x11083, 0x110AF).	% XID_Start Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_xid_start(0x110D0, 0x110E8).	% XID_Start Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_xid_start(0x11103, 0x11126).	% XID_Start Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_xid_start(0x11183, 0x111B2).	% XID_Start Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_xid_start(0x111C1, 0x111C4).	% XID_Start Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_xid_start(0x11680, 0x116AA).	% XID_Start Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_xid_start(0x12000, 0x1236E).	% XID_Start Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_xid_start(0x12400, 0x12462).	% XID_Start Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_xid_start(0x13000, 0x1342E).	% XID_Start Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_xid_start(0x16800, 0x16A38).	% XID_Start Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_xid_start(0x16F00, 0x16F44).	% XID_Start Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_xid_start(0x16F50, 0x16F50).	% XID_Start Lo       MIAO LETTER NASALIZATION
unicode_xid_start(0x16F93, 0x16F9F).	% XID_Start Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_xid_start(0x1B000, 0x1B001).	% XID_Start Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_xid_start(0x1D400, 0x1D454).	% XID_Start L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_xid_start(0x1D456, 0x1D49C).	% XID_Start L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_xid_start(0x1D49E, 0x1D49F).	% XID_Start L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_xid_start(0x1D4A2, 0x1D4A2).	% XID_Start L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_xid_start(0x1D4A5, 0x1D4A6).	% XID_Start L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_xid_start(0x1D4A9, 0x1D4AC).	% XID_Start L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_xid_start(0x1D4AE, 0x1D4B9).	% XID_Start L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_xid_start(0x1D4BB, 0x1D4BB).	% XID_Start L&       MATHEMATICAL SCRIPT SMALL F
unicode_xid_start(0x1D4BD, 0x1D4C3).	% XID_Start L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_xid_start(0x1D4C5, 0x1D505).	% XID_Start L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_xid_start(0x1D507, 0x1D50A).	% XID_Start L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_xid_start(0x1D50D, 0x1D514).	% XID_Start L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_xid_start(0x1D516, 0x1D51C).	% XID_Start L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_xid_start(0x1D51E, 0x1D539).	% XID_Start L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_xid_start(0x1D53B, 0x1D53E).	% XID_Start L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_xid_start(0x1D540, 0x1D544).	% XID_Start L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_xid_start(0x1D546, 0x1D546).	% XID_Start L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_xid_start(0x1D54A, 0x1D550).	% XID_Start L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_xid_start(0x1D552, 0x1D6A5).	% XID_Start L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_xid_start(0x1D6A8, 0x1D6C0).	% XID_Start L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_xid_start(0x1D6C2, 0x1D6DA).	% XID_Start L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_xid_start(0x1D6DC, 0x1D6FA).	% XID_Start L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_xid_start(0x1D6FC, 0x1D714).	% XID_Start L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_xid_start(0x1D716, 0x1D734).	% XID_Start L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_xid_start(0x1D736, 0x1D74E).	% XID_Start L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_xid_start(0x1D750, 0x1D76E).	% XID_Start L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_xid_start(0x1D770, 0x1D788).	% XID_Start L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_xid_start(0x1D78A, 0x1D7A8).	% XID_Start L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_xid_start(0x1D7AA, 0x1D7C2).	% XID_Start L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_xid_start(0x1D7C4, 0x1D7CB).	% XID_Start L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_xid_start(0x1EE00, 0x1EE03).	% XID_Start Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_xid_start(0x1EE05, 0x1EE1F).	% XID_Start Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_xid_start(0x1EE21, 0x1EE22).	% XID_Start Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_xid_start(0x1EE24, 0x1EE24).	% XID_Start Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_xid_start(0x1EE27, 0x1EE27).	% XID_Start Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_xid_start(0x1EE29, 0x1EE32).	% XID_Start Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_xid_start(0x1EE34, 0x1EE37).	% XID_Start Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_xid_start(0x1EE39, 0x1EE39).	% XID_Start Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_xid_start(0x1EE3B, 0x1EE3B).	% XID_Start Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_xid_start(0x1EE42, 0x1EE42).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_xid_start(0x1EE47, 0x1EE47).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_xid_start(0x1EE49, 0x1EE49).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_xid_start(0x1EE4B, 0x1EE4B).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_xid_start(0x1EE4D, 0x1EE4F).	% XID_Start Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_xid_start(0x1EE51, 0x1EE52).	% XID_Start Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_xid_start(0x1EE54, 0x1EE54).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_xid_start(0x1EE57, 0x1EE57).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_xid_start(0x1EE59, 0x1EE59).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_xid_start(0x1EE5B, 0x1EE5B).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_xid_start(0x1EE5D, 0x1EE5D).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_xid_start(0x1EE5F, 0x1EE5F).	% XID_Start Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_xid_start(0x1EE61, 0x1EE62).	% XID_Start Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_xid_start(0x1EE64, 0x1EE64).	% XID_Start Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_xid_start(0x1EE67, 0x1EE6A).	% XID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_xid_start(0x1EE6C, 0x1EE72).	% XID_Start Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_xid_start(0x1EE74, 0x1EE77).	% XID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_xid_start(0x1EE79, 0x1EE7C).	% XID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_xid_start(0x1EE7E, 0x1EE7E).	% XID_Start Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_xid_start(0x1EE80, 0x1EE89).	% XID_Start Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_xid_start(0x1EE8B, 0x1EE9B).	% XID_Start Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_xid_start(0x1EEA1, 0x1EEA3).	% XID_Start Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_xid_start(0x1EEA5, 0x1EEA9).	% XID_Start Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_xid_start(0x1EEAB, 0x1EEBB).	% XID_Start Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_xid_start(0x20000, 0x2A6D6).	% XID_Start Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_xid_start(0x2A700, 0x2B734).	% XID_Start Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_xid_start(0x2B740, 0x2B81D).	% XID_Start Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_xid_start(0x2F800, 0x2FA1D).	% XID_Start Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 101217
