/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifactCoordinates
implements ArtifactCoordinates {
    @Nonnull
    private final InternalSession session;
    @Nonnull
    private final Artifact coordinates;

    public DefaultArtifactCoordinates(@Nonnull InternalSession session, @Nonnull Artifact coordinates) {
        this.session = Objects.requireNonNull(session, "session");
        this.coordinates = Objects.requireNonNull(coordinates, "coordinates");
    }

    public Artifact getCoordinates() {
        return this.coordinates;
    }

    @Nonnull
    public String getGroupId() {
        return this.coordinates.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.coordinates.getArtifactId();
    }

    @Nonnull
    public VersionConstraint getVersionConstraint() {
        return this.session.parseVersionConstraint(this.coordinates.getVersion());
    }

    public String getExtension() {
        return this.coordinates.getExtension();
    }

    @Nonnull
    public String getClassifier() {
        return this.coordinates.getClassifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArtifactCoordinates that = (DefaultArtifactCoordinates)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getVersionConstraint(), that.getVersionConstraint()) && Objects.equals(this.getClassifier(), that.getClassifier());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getVersionConstraint(), this.getClassifier());
    }

    public String toString() {
        return this.coordinates.toString();
    }
}

