C***********************************************************************
c*SPPDI -- Determinant and inverse of real symmetric positive definite matrix.
c:LINPACK
c+
      SUBROUTINE SPPDI(AP,N,DET,JOB)
      INTEGER N,JOB
      REAL AP(1)
      REAL DET(2)
C
C     SPPDI COMPUTES THE DETERMINANT AND INVERSE
C     OF A REAL SYMMETRIC POSITIVE DEFINITE MATRIX
C     USING THE FACTORS COMPUTED BY SPPCO OR SPPFA .
C
C     ON ENTRY
C
C	 AP	 REAL (N*(N+1)/2)
C		 THE OUTPUT FROM SPPCO OR SPPFA.
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C	 JOB	 INTEGER
C		 = 11	BOTH DETERMINANT AND INVERSE.
C		 = 01	INVERSE ONLY.
C		 = 10	DETERMINANT ONLY.
C
C     ON RETURN
C
C	 AP	 THE UPPER TRIANGULAR HALF OF THE INVERSE .
C		 THE STRICT LOWER TRIANGLE IS UNALTERED.
C
C	 DET	 REAL(2)
C		 DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.
C		 OTHERWISE NOT REFERENCED.
C		 DETERMINANT = DET(1) * 10.0**DET(2)
C		 WITH  1.0 .LE. DET(1) .LT. 10.0
C		 OR  DET(1) .EQ. 0.0 .
C
C     ERROR CONDITION
C
C	 A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS
C	 A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.
C	 IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY
C	 AND IF SPOCO OR SPOFA HAS SET INFO .EQ. 0 .
C
C--
C     LINPACK.	THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS SAXPY,SSCAL
C     FORTRAN MOD
C
C     INTERNAL VARIABLES
C
      REAL T
      REAL S
      INTEGER I,II,J,JJ,JM1,J1,K,KJ,KK,KP1,K1
C
C     COMPUTE DETERMINANT
C
      IF (JOB/10 .EQ. 0) GO TO 70
	 DET(1) = 1.0E0
	 DET(2) = 0.0E0
	 S = 10.0E0
	 II = 0
	 DO 50 I = 1, N
	    II = II + I
	    DET(1) = AP(II)**2*DET(1)
C	 ...EXIT
	    IF (DET(1) .EQ. 0.0E0) GO TO 60
   10	    IF (DET(1) .GE. 1.0E0) GO TO 20
	       DET(1) = S*DET(1)
	       DET(2) = DET(2) - 1.0E0
	    GO TO 10
   20	    CONTINUE
   30	    IF (DET(1) .LT. S) GO TO 40
	       DET(1) = DET(1)/S
	       DET(2) = DET(2) + 1.0E0
	    GO TO 30
   40	    CONTINUE
   50	 CONTINUE
   60	 CONTINUE
   70 CONTINUE
C
C     COMPUTE INVERSE(R)
C
      IF (MOD(JOB,10) .EQ. 0) GO TO 140
	 KK = 0
	 DO 100 K = 1, N
	    K1 = KK + 1
	    KK = KK + K
	    AP(KK) = 1.0E0/AP(KK)
	    T = -AP(KK)
	    CALL SSCAL(K-1,T,AP(K1),1)
	    KP1 = K + 1
	    J1 = KK + 1
	    KJ = KK + K
	    IF (N .LT. KP1) GO TO 90
	    DO 80 J = KP1, N
	       T = AP(KJ)
	       AP(KJ) = 0.0E0
	       CALL SAXPY(K,T,AP(K1),1,AP(J1),1)
	       J1 = J1 + J
	       KJ = KJ + J
   80	    CONTINUE
   90	    CONTINUE
  100	 CONTINUE
C
C	 FORM  INVERSE(R) * TRANS(INVERSE(R))
C
	 JJ = 0
	 DO 130 J = 1, N
	    J1 = JJ + 1
	    JJ = JJ + J
	    JM1 = J - 1
	    K1 = 1
	    KJ = J1
	    IF (JM1 .LT. 1) GO TO 120
	    DO 110 K = 1, JM1
	       T = AP(KJ)
	       CALL SAXPY(K,T,AP(J1),1,AP(K1),1)
	       K1 = K1 + K
	       KJ = KJ + 1
  110	    CONTINUE
  120	    CONTINUE
	    T = AP(JJ)
	    CALL SSCAL(J,T,AP(J1),1)
  130	 CONTINUE
  140 CONTINUE
      RETURN
      END
