C***********************************************************************
c*CGBDI -- Determinant of a band matrix.
c:LINPACK
c+
      SUBROUTINE CGBDI(ABD,LDA,N,ML,MU,IPVT,DET)
      INTEGER LDA,N,ML,MU,IPVT(1)
      COMPLEX ABD(LDA,1),DET(2)
C
C     CGBDI COMPUTES THE DETERMINANT OF A BAND MATRIX
C     USING THE FACTORS COMPUTED BY CGBCO OR CGBFA.
C     IF THE INVERSE IS NEEDED, USE CGBSL  N  TIMES.
C
C     ON ENTRY
C
C	 ABD	 COMPLEX(LDA, N)
C		 THE OUTPUT FROM CGBCO OR CGBFA.
C
C	 LDA	 INTEGER
C		 THE LEADING DIMENSION OF THE ARRAY  ABD .
C
C	 N	 INTEGER
C		 THE ORDER OF THE ORIGINAL MATRIX.
C
C	 ML	 INTEGER
C		 NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.
C
C	 MU	 INTEGER
C		 NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.
C
C	 IPVT	 INTEGER(N)
C		 THE PIVOT VECTOR FROM CGBCO OR CGBFA.
C
C     ON RETURN
C
C	 DET	 COMPLEX(2)
C		 DETERMINANT OF ORIGINAL MATRIX.
C		 DETERMINANT = DET(1) * 10.0**DET(2)
C		 WITH  1.0 .LE. CABS1(DET(1)) .LT. 10.0
C		 OR  DET(1) = 0.0 .
C
C--
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     FORTRAN ABS,AIMAG,CMPLX,REAL
C
C     INTERNAL VARIABLES
C
      REAL TEN
      INTEGER I,M
C
      COMPLEX ZDUM
      REAL CABS1
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))
C
      M = ML + MU + 1
      DET(1) = (1.0E0,0.0E0)
      DET(2) = (0.0E0,0.0E0)
      TEN = 10.0E0
      DO 50 I = 1, N
	 IF (IPVT(I) .NE. I) DET(1) = -DET(1)
	 DET(1) = ABD(M,I)*DET(1)
C     ...EXIT
	 IF (CABS1(DET(1)) .EQ. 0.0E0) GO TO 60
   10	 IF (CABS1(DET(1)) .GE. 1.0E0) GO TO 20
	    DET(1) = CMPLX(TEN,0.0E0)*DET(1)
	    DET(2) = DET(2) - (1.0E0,0.0E0)
	 GO TO 10
   20	 CONTINUE
   30	 IF (CABS1(DET(1)) .LT. TEN) GO TO 40
	    DET(1) = DET(1)/CMPLX(TEN,0.0E0)
	    DET(2) = DET(2) + (1.0E0,0.0E0)
	 GO TO 30
   40	 CONTINUE
   50 CONTINUE
   60 CONTINUE
      RETURN
      END
