C***********************************************************************
c*CSPSL -- Solve complex symmetric system.
c:LINPACK
c+
      SUBROUTINE CSPSL(AP,N,KPVT,B)
      INTEGER N,KPVT(1)
      COMPLEX AP(1),B(1)
C
C     CSISL SOLVES THE COMPLEX SYMMETRIC SYSTEM
C     A * X = B
C     USING THE FACTORS COMPUTED BY CSPFA.
C
C     ON ENTRY
C
C	 AP	 COMPLEX(N*(N+1)/2)
C		 THE OUTPUT FROM CSPFA.
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C	 KPVT	 INTEGER(N)
C		 THE PIVOT VECTOR FROM CSPFA.
C
C	 B	 COMPLEX(N)
C		 THE RIGHT HAND SIDE VECTOR.
C
C     ON RETURN
C
C	 B	 THE SOLUTION VECTOR  X .
C
C     ERROR CONDITION
C
C	 A DIVISION BY ZERO MAY OCCUR IF  CSPCO	 HAS SET RCOND .EQ. 0.0
C	 OR  CSPFA  HAS SET INFO .NE. 0	 .
C
C     TO COMPUTE  INVERSE(A) * C  WHERE	 C  IS A MATRIX
C     WITH  P  COLUMNS
C	    CALL CSPFA(AP,N,KPVT,INFO)
C	    IF (INFO .NE. 0) GO TO ...
C	    DO 10 J = 1, P
C	       CALL CSPSL(AP,N,KPVT,C(1,J))
C	 10 CONTINUE
C
C--
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS CAXPY,CDOTU
C     FORTRAN IABS
C
C     INTERNAL VARIABLES.
C
      COMPLEX AK,AKM1,BK,BKM1,CDOTU,DENOM,TEMP
      INTEGER IK,IKM1,IKP1,K,KK,KM1K,KM1KM1,KP
C
C     LOOP BACKWARD APPLYING THE TRANSFORMATIONS AND
C     D INVERSE TO B.
C
      K = N
      IK = (N*(N - 1))/2
   10 IF (K .EQ. 0) GO TO 80
	 KK = IK + K
	 IF (KPVT(K) .LT. 0) GO TO 40
C
C	    1 X 1 PIVOT BLOCK.
C
	    IF (K .EQ. 1) GO TO 30
	       KP = KPVT(K)
	       IF (KP .EQ. K) GO TO 20
C
C		  INTERCHANGE.
C
		  TEMP = B(K)
		  B(K) = B(KP)
		  B(KP) = TEMP
   20	       CONTINUE
C
C	       APPLY THE TRANSFORMATION.
C
	       CALL CAXPY(K-1,B(K),AP(IK+1),1,B(1),1)
   30	    CONTINUE
C
C	    APPLY D INVERSE.
C
	    B(K) = B(K)/AP(KK)
	    K = K - 1
	    IK = IK - K
	 GO TO 70
   40	 CONTINUE
C
C	    2 X 2 PIVOT BLOCK.
C
	    IKM1 = IK - (K - 1)
	    IF (K .EQ. 2) GO TO 60
	       KP = IABS(KPVT(K))
	       IF (KP .EQ. K - 1) GO TO 50
C
C		  INTERCHANGE.
C
		  TEMP = B(K-1)
		  B(K-1) = B(KP)
		  B(KP) = TEMP
   50	       CONTINUE
C
C	       APPLY THE TRANSFORMATION.
C
	       CALL CAXPY(K-2,B(K),AP(IK+1),1,B(1),1)
	       CALL CAXPY(K-2,B(K-1),AP(IKM1+1),1,B(1),1)
   60	    CONTINUE
C
C	    APPLY D INVERSE.
C
	    KM1K = IK + K - 1
	    KK = IK + K
	    AK = AP(KK)/AP(KM1K)
	    KM1KM1 = IKM1 + K - 1
	    AKM1 = AP(KM1KM1)/AP(KM1K)
	    BK = B(K)/AP(KM1K)
	    BKM1 = B(K-1)/AP(KM1K)
	    DENOM = AK*AKM1 - 1.0E0
	    B(K) = (AKM1*BK - BKM1)/DENOM
	    B(K-1) = (AK*BKM1 - BK)/DENOM
	    K = K - 2
	    IK = IK - (K + 1) - K
   70	 CONTINUE
      GO TO 10
   80 CONTINUE
C
C     LOOP FORWARD APPLYING THE TRANSFORMATIONS.
C
      K = 1
      IK = 0
   90 IF (K .GT. N) GO TO 160
	 IF (KPVT(K) .LT. 0) GO TO 120
C
C	    1 X 1 PIVOT BLOCK.
C
	    IF (K .EQ. 1) GO TO 110
C
C	       APPLY THE TRANSFORMATION.
C
	       B(K) = B(K) + CDOTU(K-1,AP(IK+1),1,B(1),1)
	       KP = KPVT(K)
	       IF (KP .EQ. K) GO TO 100
C
C		  INTERCHANGE.
C
		  TEMP = B(K)
		  B(K) = B(KP)
		  B(KP) = TEMP
  100	       CONTINUE
  110	    CONTINUE
	    IK = IK + K
	    K = K + 1
	 GO TO 150
  120	 CONTINUE
C
C	    2 X 2 PIVOT BLOCK.
C
	    IF (K .EQ. 1) GO TO 140
C
C	       APPLY THE TRANSFORMATION.
C
	       B(K) = B(K) + CDOTU(K-1,AP(IK+1),1,B(1),1)
	       IKP1 = IK + K
	       B(K+1) = B(K+1) + CDOTU(K-1,AP(IKP1+1),1,B(1),1)
	       KP = IABS(KPVT(K))
	       IF (KP .EQ. K) GO TO 130
C
C		  INTERCHANGE.
C
		  TEMP = B(K)
		  B(K) = B(KP)
		  B(KP) = TEMP
  130	       CONTINUE
  140	    CONTINUE
	    IK = IK + K + K + 1
	    K = K + 2
  150	 CONTINUE
      GO TO 90
  160 CONTINUE
      RETURN
      END
