C***********************************************************************
c*CGECO -- Factor complex matrix
c:LINPACK
c+
      SUBROUTINE CGECO(A,LDA,N,IPVT,RCOND,Z)
      INTEGER LDA,N,IPVT(1)
      COMPLEX A(LDA,1),Z(1)
      REAL RCOND
C
C     CGECO FACTORS A COMPLEX MATRIX BY GAUSSIAN ELIMINATION
C     AND ESTIMATES THE CONDITION OF THE MATRIX.
C
C     IF  RCOND	 IS NOT NEEDED, CGEFA IS SLIGHTLY FASTER.
C     TO SOLVE	A*X = B , FOLLOW CGECO BY CGESL.
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CGECO BY CGESL.
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CGECO BY CGEDI.
C     TO COMPUTE  INVERSE(A) , FOLLOW CGECO BY CGEDI.
C
C     ON ENTRY
C
C	 A	 COMPLEX(LDA, N)
C		 THE MATRIX TO BE FACTORED.
C
C	 LDA	 INTEGER
C		 THE LEADING DIMENSION OF THE ARRAY  A .
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C	 A	 AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS
C		 WHICH WERE USED TO OBTAIN IT.
C		 THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE
C		 L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C		 TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C	 IPVT	 INTEGER(N)
C		 AN INTEGER VECTOR OF PIVOT INDICES.
C
C	 RCOND	 REAL
C		 AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .
C		 FOR THE SYSTEM	 A*X = B , RELATIVE PERTURBATIONS
C		 IN  A	AND  B	OF SIZE	 EPSILON  MAY CAUSE
C		 RELATIVE PERTURBATIONS IN  X  OF SIZE	EPSILON/RCOND .
C		 IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION
C			    1.0 + RCOND .EQ. 1.0
C		 IS TRUE, THEN	A  MAY BE SINGULAR TO WORKING
C		 PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF
C		 EXACT SINGULARITY IS DETECTED OR THE ESTIMATE
C		 UNDERFLOWS.
C
C	 Z	 COMPLEX(N)
C		 A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.
C		 IF  A	IS CLOSE TO A SINGULAR MATRIX, THEN  Z	IS
C		 AN APPROXIMATE NULL VECTOR IN THE SENSE THAT
C		 NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .
C
C--
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     LINPACK CGEFA
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL
C
C     INTERNAL VARIABLES
C
      COMPLEX CDOTC,EK,T,WK,WKM
      REAL ANORM,S,SCASUM,SM,YNORM
      INTEGER INFO,J,K,KB,KP1,L
C
      COMPLEX ZDUM,ZDUM1,ZDUM2,CSIGN1
      REAL CABS1
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))
C
C     COMPUTE 1-NORM OF A
C
      ANORM = 0.0E0
      DO 10 J = 1, N
	 ANORM = AMAX1(ANORM,SCASUM(N,A(1,J),1))
   10 CONTINUE
C
C     FACTOR
C
      CALL CGEFA(A,LDA,N,IPVT,INFO)
C
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE	A*Z = Y	 AND  CTRANS(A)*Y = E .
C     CTRANS(A)	 IS THE CONJUGATE TRANSPOSE OF A .
C     THE COMPONENTS OF	 E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.
C
C     SOLVE CTRANS(U)*W = E
C
      EK = (1.0E0,0.0E0)
      DO 20 J = 1, N
	 Z(J) = (0.0E0,0.0E0)
   20 CONTINUE
      DO 100 K = 1, N
	 IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))
	 IF (CABS1(EK-Z(K)) .LE. CABS1(A(K,K))) GO TO 30
	    S = CABS1(A(K,K))/CABS1(EK-Z(K))
	    CALL CSSCAL(N,S,Z,1)
	    EK = CMPLX(S,0.0E0)*EK
   30	 CONTINUE
	 WK = EK - Z(K)
	 WKM = -EK - Z(K)
	 S = CABS1(WK)
	 SM = CABS1(WKM)
	 IF (CABS1(A(K,K)) .EQ. 0.0E0) GO TO 40
	    WK = WK/CONJG(A(K,K))
	    WKM = WKM/CONJG(A(K,K))
	 GO TO 50
   40	 CONTINUE
	    WK = (1.0E0,0.0E0)
	    WKM = (1.0E0,0.0E0)
   50	 CONTINUE
	 KP1 = K + 1
	 IF (KP1 .GT. N) GO TO 90
	    DO 60 J = KP1, N
	       SM = SM + CABS1(Z(J)+WKM*CONJG(A(K,J)))
	       Z(J) = Z(J) + WK*CONJG(A(K,J))
	       S = S + CABS1(Z(J))
   60	    CONTINUE
	    IF (S .GE. SM) GO TO 80
	       T = WKM - WK
	       WK = WKM
	       DO 70 J = KP1, N
		  Z(J) = Z(J) + T*CONJG(A(K,J))
   70	       CONTINUE
   80	    CONTINUE
   90	 CONTINUE
	 Z(K) = WK
  100 CONTINUE
      S = 1.0E0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
C
C     SOLVE CTRANS(L)*Y = W
C
      DO 120 KB = 1, N
	 K = N + 1 - KB
	 IF (K .LT. N) Z(K) = Z(K) + CDOTC(N-K,A(K+1,K),1,Z(K+1),1)
	 IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 110
	    S = 1.0E0/CABS1(Z(K))
	    CALL CSSCAL(N,S,Z,1)
  110	 CONTINUE
	 L = IPVT(K)
	 T = Z(L)
	 Z(L) = Z(K)
	 Z(K) = T
  120 CONTINUE
      S = 1.0E0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
C
      YNORM = 1.0E0
C
C     SOLVE L*V = Y
C
      DO 140 K = 1, N
	 L = IPVT(K)
	 T = Z(L)
	 Z(L) = Z(K)
	 Z(K) = T
	 IF (K .LT. N) CALL CAXPY(N-K,T,A(K+1,K),1,Z(K+1),1)
	 IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 130
	    S = 1.0E0/CABS1(Z(K))
	    CALL CSSCAL(N,S,Z,1)
	    YNORM = S*YNORM
  130	 CONTINUE
  140 CONTINUE
      S = 1.0E0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
      YNORM = S*YNORM
C
C     SOLVE  U*Z = V
C
      DO 160 KB = 1, N
	 K = N + 1 - KB
	 IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 150
	    S = CABS1(A(K,K))/CABS1(Z(K))
	    CALL CSSCAL(N,S,Z,1)
	    YNORM = S*YNORM
  150	 CONTINUE
	 IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)
	 IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)
	 T = -Z(K)
	 CALL CAXPY(K-1,T,A(1,K),1,Z(1),1)
  160 CONTINUE
C     MAKE ZNORM = 1.0
      S = 1.0E0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
      YNORM = S*YNORM
C
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0
      RETURN
      END
