C**********************************************************************
c*CHIFA -- Factor complex hermitian matrix.
c:LINPACK
c+
      SUBROUTINE CHIFA(A,LDA,N,KPVT,INFO)
      INTEGER LDA,N,KPVT(1),INFO
      COMPLEX A(LDA,1)
C
C     CHIFA FACTORS A COMPLEX HERMITIAN MATRIX BY ELIMINATION
C     WITH SYMMETRIC PIVOTING.
C
C     TO SOLVE	A*X = B , FOLLOW CHIFA BY CHISL.
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CHIFA BY CHISL.
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CHIFA BY CHIDI.
C     TO COMPUTE  INERTIA(A) , FOLLOW CHIFA BY CHIDI.
C     TO COMPUTE  INVERSE(A) , FOLLOW CHIFA BY CHIDI.
C
C     ON ENTRY
C
C	 A	 COMPLEX(LDA,N)
C		 THE HERMITIAN MATRIX TO BE FACTORED.
C		 ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.
C
C	 LDA	 INTEGER
C		 THE LEADING DIMENSION OF THE ARRAY  A .
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C	 A	 A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH
C		 WERE USED TO OBTAIN IT.
C		 THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)
C		 WHERE	U  IS A PRODUCT OF PERMUTATION AND UNIT
C		 UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE
C		 CONJUGATE TRANSPOSE OF	 U , AND  D  IS BLOCK DIAGONAL
C		 WITH 1 BY 1 AND 2 BY 2 BLOCKS.
C
C	 KPVT	 INTEGER(N)
C		 AN INTEGER VECTOR OF PIVOT INDICES.
C
C	 INFO	 INTEGER
C		 = 0  NORMAL VALUE.
C		 = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS
C		      NOT AN ERROR CONDITION FOR THIS SUBROUTINE,
C		      BUT IT DOES INDICATE THAT CHISL OR CHIDI MAY
C		      DIVIDE BY ZERO IF CALLED.
C
C--
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS CAXPY,CSWAP,ICAMAX
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL,SQRT
C
C     INTERNAL VARIABLES
C
      COMPLEX AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T
      REAL ABSAKK,ALPHA,COLMAX,ROWMAX
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,ICAMAX
      LOGICAL SWAP
C
      COMPLEX ZDUM
      REAL CABS1
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))
C
C     INITIALIZE
C
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.
      ALPHA = (1.0E0 + SQRT(17.0E0))/8.0E0
C
      INFO = 0
C
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.
C
      K = N
   10 CONTINUE
C
C	 LEAVE THE LOOP IF K=0 OR K=1.
C
C     ...EXIT
	 IF (K .EQ. 0) GO TO 200
	 IF (K .GT. 1) GO TO 20
	    KPVT(1) = 1
	    IF (CABS1(A(1,1)) .EQ. 0.0E0) INFO = 1
C     ......EXIT
	    GO TO 200
   20	 CONTINUE
C
C	 THIS SECTION OF CODE DETERMINES THE KIND OF
C	 ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,
C	 KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND
C	 SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS
C	 REQUIRED.
C
	 KM1 = K - 1
	 ABSAKK = CABS1(A(K,K))
C
C	 DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN
C	 COLUMN K.
C
	 IMAX = ICAMAX(K-1,A(1,K),1)
	 COLMAX = CABS1(A(IMAX,K))
	 IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30
	    KSTEP = 1
	    SWAP = .FALSE.
	 GO TO 90
   30	 CONTINUE
C
C	    DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN
C	    ROW IMAX.
C
	    ROWMAX = 0.0E0
	    IMAXP1 = IMAX + 1
	    DO 40 J = IMAXP1, K
	       ROWMAX = AMAX1(ROWMAX,CABS1(A(IMAX,J)))
   40	    CONTINUE
	    IF (IMAX .EQ. 1) GO TO 50
	       JMAX = ICAMAX(IMAX-1,A(1,IMAX),1)
	       ROWMAX = AMAX1(ROWMAX,CABS1(A(JMAX,IMAX)))
   50	    CONTINUE
	    IF (CABS1(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60
	       KSTEP = 1
	       SWAP = .TRUE.
	    GO TO 80
   60	    CONTINUE
	    IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70
	       KSTEP = 1
	       SWAP = .FALSE.
	    GO TO 80
   70	    CONTINUE
	       KSTEP = 2
	       SWAP = IMAX .NE. KM1
   80	    CONTINUE
   90	 CONTINUE
	 IF (AMAX1(ABSAKK,COLMAX) .NE. 0.0E0) GO TO 100
C
C	    COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.
C
	    KPVT(K) = K
	    INFO = K
	 GO TO 190
  100	 CONTINUE
	 IF (KSTEP .EQ. 2) GO TO 140
C
C	    1 X 1 PIVOT BLOCK.
C
	    IF (.NOT.SWAP) GO TO 120
C
C	       PERFORM AN INTERCHANGE.
C
	       CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K),1)
	       DO 110 JJ = IMAX, K
		  J = K + IMAX - JJ
		  T = CONJG(A(J,K))
		  A(J,K) = CONJG(A(IMAX,J))
		  A(IMAX,J) = T
  110	       CONTINUE
  120	    CONTINUE
C
C	    PERFORM THE ELIMINATION.
C
	    DO 130 JJ = 1, KM1
	       J = K - JJ
	       MULK = -A(J,K)/A(K,K)
	       T = CONJG(MULK)
	       CALL CAXPY(J,T,A(1,K),1,A(1,J),1)
	       A(J,J) = CMPLX(REAL(A(J,J)),0.0E0)
	       A(J,K) = MULK
  130	    CONTINUE
C
C	    SET THE PIVOT ARRAY.
C
	    KPVT(K) = K
	    IF (SWAP) KPVT(K) = IMAX
	 GO TO 190
  140	 CONTINUE
C
C	    2 X 2 PIVOT BLOCK.
C
	    IF (.NOT.SWAP) GO TO 160
C
C	       PERFORM AN INTERCHANGE.
C
	       CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)
	       DO 150 JJ = IMAX, KM1
		  J = KM1 + IMAX - JJ
		  T = CONJG(A(J,K-1))
		  A(J,K-1) = CONJG(A(IMAX,J))
		  A(IMAX,J) = T
  150	       CONTINUE
	       T = A(K-1,K)
	       A(K-1,K) = A(IMAX,K)
	       A(IMAX,K) = T
  160	    CONTINUE
C
C	    PERFORM THE ELIMINATION.
C
	    KM2 = K - 2
	    IF (KM2 .EQ. 0) GO TO 180
	       AK = A(K,K)/A(K-1,K)
	       AKM1 = A(K-1,K-1)/CONJG(A(K-1,K))
	       DENOM = 1.0E0 - AK*AKM1
	       DO 170 JJ = 1, KM2
		  J = KM1 - JJ
		  BK = A(J,K)/A(K-1,K)
		  BKM1 = A(J,K-1)/CONJG(A(K-1,K))
		  MULK = (AKM1*BK - BKM1)/DENOM
		  MULKM1 = (AK*BKM1 - BK)/DENOM
		  T = CONJG(MULK)
		  CALL CAXPY(J,T,A(1,K),1,A(1,J),1)
		  T = CONJG(MULKM1)
		  CALL CAXPY(J,T,A(1,K-1),1,A(1,J),1)
		  A(J,K) = MULK
		  A(J,K-1) = MULKM1
		  A(J,J) = CMPLX(REAL(A(J,J)),0.0E0)
  170	       CONTINUE
  180	    CONTINUE
C
C	    SET THE PIVOT ARRAY.
C
	    KPVT(K) = 1 - K
	    IF (SWAP) KPVT(K) = -IMAX
	    KPVT(K-1) = KPVT(K)
  190	 CONTINUE
	 K = K - KSTEP
      GO TO 10
  200 CONTINUE
      RETURN
      END
