        program velsw

c= velsw -- Change the 'velocity' axis of an image.
c& rjs
c: map manipulation
c+
c       VELSW is a Miriad task used to change the type of a spectral
c       axis.  For example, a frequency axis could be changed to
c       redshift or relativistic velocity.
c
c       The resulting axis may be non-linear.  If so, it will be marked
c       by a code, e.g. VOPT-F2W, meaning that it is actually linear in
c       frequency (F) but is labelled as a spectral type that is linear
c       in wavelength (W).  Such non-linear axes are handled properly by
c       the coordinate routines.  However, when plotted, non-linear axes
c       are only correct to first-order at the reference point.
c
c       Switching between velocity and other spectral types, via the
c       Doppler formula, is only possible if a rest frequency is
c       recorded in the header.  It is also possible to change the
c       Doppler reference frame to barycentric or LSRK (only).
c
c       Note that velocity axes labelled as {VELO,FELO}-{HEL,LSR} in
c       Miriad have been Doppler-shifted to the specified frame
c       (barycentric or LSRK) as would be expected.  However, frequency
c       axes labelled as FREQ-{HEL,LSR} are actually topocentric, the
c       Doppler frame here refers only to the value of vobs recorded in
c       the header.  This convention also applies to FITS images written
c       and read by Miriad - the presence of vobs with FREQ-{HEL,LSR} in
c       the header of a Miriad image read from such a FITS file is
c       indicative.  However, there is a potential inconsistency when
c       FITS files generated by other packages are read into Miriad.
c       See option altspc below.
c@ in
c       Name of the input image data set.  No default.
c@ axis
c       The spectral type to change to:
c         FREQ: frequency,
c         ENER: photon energy (linear with frequency),
c         WAVN: wavenumber (linear with frequency),
c         VRAD: radio velocity (linear with frequency),
c         WAVE: wavelength,
c         VOPT: optical velocity (linear with wavelength),
c         ZOPT: redshift (linear with wavelength),
c         AWAV: air wavelength (applicable to optical regime only),
c         VELO: apparent radial velocity (relativistic),
c         BETA: relativistic beta factor (= VELO/c).
c
c       Note that there is no minimum-match on these four-letter
c       spectral types.  For backwards compatibility, 'frequency',
c       'radio', and 'optical' (with min-match) are understood as
c       synonyms for 'FREQ', 'VRAD', and 'VOPT'.
c
c       AIPS-convention types, {FREQ,VELO,FELO}-{HEL,LSR}, are also
c       understood and will be translated.  Here VELO means radio
c       velocity (VRAD), and FELO is optical velocity (VOPT-F2W).
c       However, these types are deprecated, and there is no way to
c       switch to them explicitly.
c
c       An optional second value defines the Doppler frame to transform
c       to (min-match applies):
c         BARYCENT: Solar System barycentre (aka BARYCENT{RE,ER,RIC},
c                   or HEL),
c             LSRK: Kinematic Local Standard of Rest.
c
c       The default for both the spectral type and the Doppler frame is
c       to leave them as is, performing only required translations.
c@ options
c       Extra processing options.
c         altspc    Force FREQ-{HEL,LSR} axes to be interpreted as
c                   barycentric or LSRK (rather than topocentric - see
c                   above).  Since vobs will normally be absent from
c                   the Miriad header of images read from FITS files
c                   generated by other packages (such as Livedata), it
c                   should not normally be necessary to use this option.
c                   However, it will not hurt.  Thus, running
c
c                      velsw in=<infile>
c
c                   should be enough to fix such headers; ctype and
c                   specsys would be relabelled while leaving crval and
c                   cdelt unchanged.
c
c$Id$
c--
c  History:
c    Refer to the RCS log, v1.1 includes prior revision information.
c-----------------------------------------------------------------------
      include 'maxnax.h'

      logical   altSpc
      integer   ispc, lIn, nsize(MAXNAX)
      character algo*3, cax*2, ctype*16, frame*16, iName*64, stype*16,
     *          version*72

      external  itoaf, versan
      character itoaf*2, versan*72
c-----------------------------------------------------------------------
      version = versan('velsw',
     *                 '$Revision$',
     *                 '$Date$')

c     Get input parameters.
      call keyini

      call keya('in',iName,' ')
      if (iName.eq.' ') call bug('f','An input must be given')

c     Spectral type and frame - coSpcSet will check validity.
      call keya('axis',stype,' ')
      call keya('axis',frame,' ')

c     Get options.
      call options('options', 'altspc', altSpc, 1)
      call keyfin

c     Open the input map.
      call xyopen(lIn,iName,'old',MAXNAX,nsize)

c     Reinterpret FREQ-{HEL,LSR}?
      if (altSpc) then
        call coInit(lIn)
        call coFindAx(lIn, 'spectral', ispc)
        if (ispc.gt.0) then
          cax = itoaf(ispc)
          call rdhda(lIn, 'ctype'//cax, ctype, ' ')
          if (ctype.eq.'FREQ-HEL') then
            call wrhda(lIn, 'ctype'//cax, 'FREQ')
            call wrhda(lIn, 'specsys', 'BARYCENT')
          else if (ctype.eq.'FREQ-LSR') then
            call wrhda(lIn, 'ctype'//cax, 'FREQ')
            call wrhda(lIn, 'specsys', 'LSRK')
          endif
        endif
        call coFin(lIn)
      endif

c     Perform the transformation.
      call coInit(lIn)
      call coSpcSet(lIn, stype, frame, ispc, algo)
      if (ispc.eq.0) call bug('f','No spectral axis in input image')
      call coWrite(lIn, lIn)
      call coFin(lIn)

c     Write history.
      call hisopen(lIn,'append')
      call hiswrite(lIn,'VELSW: Miriad '//version)
      call hisinput(lIn,'VELSW')
      call hisclose(lIn)

c     Close down.
      call xyclose(lIn)

      end
