(napari-workshops)=
# napari workshops

There have been many workshops and tutorials given about napari.
This page contains a list, to make them easier to find online.

You can find more videos of talks, tutorials and demos on the
[napari youtube channel](https://www.youtube.com/channel/UCbTgw84ew4pxTJ9qu3W2hqg/playlists).

## Workshops

*Workshops are listed from newest to oldest.*

* September 2022, Helmholtz Imaging Summer Academy
  * [Image analysis with Python and Napari](https://biapol.github.io/HIP_Introduction_to_Napari_and_image_processing_with_Python_2022/intro.html) 
  * [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.7102242.svg)](https://doi.org/10.5281/zenodo.7102242)

* July 2022, SciPy 2022
  * [watch it here](https://www.youtube.com/watch?v=vismuuc4y1I&list=PLYx7XA2nY5Gfxu98P_HL1MnFb_BSkpxLV&index=10)
  * [Workshop materials available here](https://alisterburt.github.io/napari-workshops/SciPy-0722/intro.html) 

* January to May 2022, [accelerator grantee plugin workshop](https://chanzuckerberg.github.io/napari-plugin-accel-workshops/)

* May 2022, I2K napari workshop
  * [Read the workshop materials online](https://github.com/haesleinhuepf/I2K2022-napari-workshop)

* April 2022, ABRF LMRG image analysis workshop
  * [watch it here](https://www.youtube.com/watch?v=lkw5di8NgUA) 

* March 2022, [Alt text workshop](https://hackmd.io/vDsWUBqQSxW_7TNxF-RKKA)

* February 2022, Modern microscopy guest lecture at Berkerley
  * [Watch it here](https://drive.google.com/file/d/1EjJJZ3sy4mogcGwTao97sHzU9SDJeC3r/view?usp=sharing)
  * [Slide available here](https://docs.google.com/presentation/d/1sqd_CYckEwmgQO6y9VffwnmT0RSlRYIAUBixRTMYcig/view)

* August 2021, [NDCN](https://chanzuckerberg.com/science/programs-resources/neurodegeneration-challenge/) Workshop / September 2021 [ZIDAS](https://www.zidas.org/) Workshop
  * [Read the workshop materials online](https://alisterburt.github.io/napari-workshops/home.html)
  * [Workshop materials available here](https://github.com/alisterburt/napari-workshops)

* June 2021, Bioimage analysis fundamentals in Python workshop at [SciPy 2021](https://www.scipy2021.scipy.org/)
  * [Watch it here](https://www.youtube.com/watch?v=kXdy_Tp12zA) (2 hour and 20 minute video)
  * [Workshop materials available here](https://github.com/sofroniewn/tutorial-scipy2021-bioimage-analysis-fundamentals)

* November 2020, scikit-image, napari, & friends workshop at the [I2K conference](https://www.janelia.org/you-janelia/conferences/from-images-to-knowledge-with-imagej-friends)
  * [Watch it here](https://www.youtube.com/watch?v=NZWSGXb3_Mg)
  * [Workshop materials available here](https://github.com/jni/i2k-skimage-napari)

* June 2020, [NEUBIAS Academy@Home workshop](http://eubias.org/NEUBIAS/training-schools/neubias-academy-home/neubias-academy-archive-spring2020/)
  * [Watch it here](https://www.youtube.com/watch?v=VgvDSq5aCDQ) (1 hour and 30 minute video)
  * [Workshop materials available here](https://github.com/sofroniewn/napari-training-course)

### Add your own workshop to this list

If you have organized a napari workshop and would like to see it featured here
in this page, you can
[send a Pull Request to the napari/docs repository](../developers/documentation/index.md)
or contact the core developers on [zulip chat](https://napari.zulipchat.com/login/).

### napari workshop template

If you are looking to create your own workshop, you can use the
[napari workshop template](https://github.com/napari/napari-workshop-template)
as a starting point.
