:orphan:

(nap-template)=

# NAP-X — Template and Instructions

```{eval-rst}
:Author: <list of authors' real names and, optionally, email addresses>
:Created: <date created on, in yyyy-mm-dd format>
:Resolution: <url> (required for Accepted | Rejected | Withdrawn)
:Resolved: <date resolved, in yyyy-mm-dd format>
:Status: <Draft | Provisional | Active | Accepted | Deferred | Rejected | Withdrawn | Final | Superseded>
:Type: <Standards Track | Process>
:Version effective: <version-number> (for accepted NAPs)
```

## Abstract

The abstract should be a short description of what the NAP will achieve.

## Motivation and Scope

This section describes the need for the proposed change. It should describe
the existing problem, who it affects, what it is trying to solve, and why.
This section should explicitly address the scope of and key requirements
for the proposed change.

## Detailed Description

This section should provide a detailed description of the proposed change. It
should include examples of how the new functionality would be used, intended
use-cases, and pseudocode illustrating its use.

## Related Work

This section should list relevant and/or similar technologies, possibly in
other libraries. It does not need to be comprehensive, just list the major
examples of prior and relevant art.

## Implementation

This section lists the major steps required to implement the NAP. Where
possible, it should be noted where one step is dependent on another, and which
steps may be optionally omitted. Where it makes sense, each step should
include a link to related pull requests as the implementation progresses.

Any pull requests or development branches containing work on this NAP
should be linked to from here. (A NAP does not need to be implemented in a
single pull request if it makes sense to implement it in discrete phases).

If a new NAP document is created, it should be added to the documentation Table
of Contents as an item on `napari/docs/_toc.yml`.

## Backward Compatibility

This section describes the ways in which the NAP affects backward
compatibility, including both breakages and decisions that better support
backward compatibility.

## Future Work

This section describes work that is out of scope for the NAP, but that the
NAP might suggest, or that the NAP author envisions as potential future
expansion of the work or related work.

## Alternatives

If there were any alternative solutions to solving the same problem, they
should be discussed here, along with a justification for the chosen
approach.

## Discussion

This section may just be a bullet list including links to any discussions
regarding the NAP, but could also contain additional comments about that
discussion:

- This includes links to discussion forum threads or relevant GitHub discussions.

## References and Footnotes

All NAPs should be declared as dedicated to the public domain with the CC0
license [^id3], as in `Copyright`, below, with attribution encouraged with
CC0+BY [^id4].

[^id3]: CC0 1.0 Universal (CC0 1.0) Public Domain Dedication,
    <https://creativecommons.org/publicdomain/zero/1.0/>

[^id4]: <https://dancohen.org/2013/11/26/cc0-by/>

## Copyright

This document is dedicated to the public domain with the Creative Commons CC0
license [^id3]. Attribution to this source is encouraged where appropriate, as per
CC0+BY [^id4].
