# THIS FILE IS AUTOGENERATED BY napari.utils.stubgen
# DO NOT EDIT

import collections.abc
import pathlib
import typing
from typing import Any, Dict, Union

import app_model.expressions._context

import napari.components._layer_slicer
import napari.components.camera
import napari.components.cursor
import napari.components.dims
import napari.components.grid
import napari.components.layerlist
import napari.components.overlays.base
import napari.components.tooltip
import napari.components.viewer_model
import napari.layers.base.base
import napari.layers.image.image
import napari.layers.labels.labels
import napari.layers.points.points
import napari.layers.shapes.shapes
import napari.layers.surface.surface
import napari.layers.tracks.tracks
import napari.layers.vectors.vectors
import napari.utils.events.containers._evented_dict
import napari.utils.events.event

class ViewerModel(
    napari.utils.key_bindings.KeymapProvider,
    napari.utils.mouse_bindings.MousemapProvider,
    napari.utils.events.evented_model.EventedModel,
):
    """Viewer containing the rendered scene, layers, and controlling elements
    including dimension sliders, and control bars for color limits.

    Parameters
    ----------
    title : string
        The title of the viewer window.
    ndisplay : {2, 3}
        Number of displayed dimensions.
    order : tuple of int
        Order in which dimensions are displayed where the last two or last
        three dimensions correspond to row x column or plane x row x column if
        ndisplay is 2 or 3.
    axis_labels : list of str
        Dimension names.

    Attributes
    ----------
    camera: napari.components.camera.Camera
        The camera object modeling the position and view.
    cursor: napari.components.cursor.Cursor
        The cursor object containing the position and properties of the cursor.
    dims : napari.components.dims.Dimensions
        Contains axes, indices, dimensions and sliders.
    grid: napari.components.grid.Gridcanvas
        Gridcanvas allowing for the current implementation of a gridview of the canvas.
    help: str
        A help message of the viewer model
    layers : napari.components.layerlist.LayerList
        List of contained layers.
    mouse_over_canvas: bool
        Indicating whether the mouse cursor is on the viewer canvas.
    theme: str
        Name of the Napari theme of the viewer
    title: str
        The title of the viewer model
    tooltip: napari.components.tooltip.Tooltip
        A tooltip showing extra information on the cursor
    window : napari._qt.qt_main_window.Window
        Parent window.
    _canvas_size: Tuple[int, int]
        The canvas size following the Numpy convention of height x width
    _ctx: Mapping
        Viewer object context mapping.
    _layer_slicer: napari.components._layer_slicer._Layer_Slicer
        A layer slicer object controlling the creation of a slice
    _overlays: napari.utils.events.containers._evented_dict.EventedDict[str, Overlay]
        An EventedDict with as keys the string names of different napari overlays and as values the napari.Overlay
        objects.
    """

    camera: napari.components.camera.Camera
    cursor: napari.components.cursor.Cursor
    dims: napari.components.dims.Dims
    grid: napari.components.grid.GridCanvas
    layers: napari.components.layerlist.LayerList
    help: str
    status: typing.Union
    tooltip: napari.components.tooltip.Tooltip
    theme: str
    title: str
    _overlays: napari.utils.events.containers._evented_dict.EventedDict
    _canvas_size: tuple
    _ctx: app_model.expressions._context.Context
    mouse_over_canvas: bool
    _layer_slicer: napari.components._layer_slicer._LayerSlicer
    def _add_layer_from_data(
        self,
        data,
        meta: Optional[Dict[str, Any]] = None,
        layer_type: Optional[str] = None,
    ) -> list[napari.layers.base.base.Layer]:
        """Add arbitrary layer data to the viewer.

        Primarily intended for usage by reader plugin hooks.

        Parameters
        ----------
        data : Any
            Data in a format that is valid for the corresponding `add_*` method
            of the specified ``layer_type``.
        meta : dict, optional
            Dict of keyword arguments that will be passed to the corresponding
            `add_*` method.  MUST NOT contain any keyword arguments that are
            not valid for the corresponding method.
        layer_type : str
            Type of layer to add.  MUST have a corresponding add_* method on
            on the viewer instance.  If not provided, the layer is assumed to
            be "image", unless data.dtype is one of (np.int32, np.uint32,
            np.int64, np.uint64), in which case it is assumed to be "labels".

        Returns
        -------
        layers : list of layers
            A list of layers added to the viewer.

        Raises
        ------
        ValueError
            If ``layer_type`` is not one of the recognized layer types.
        TypeError
            If any keyword arguments in ``meta`` are unexpected for the
            corresponding `add_*` method for this layer_type.

        Examples
        --------
        A typical use case might be to upack a tuple of layer data with a
        specified layer_type.

        >>> viewer = napari.Viewer()
        >>> data = (
        ...     np.random.random((10, 2)) * 20,
        ...     {'face_color': 'blue'},
        ...     'points',
        ... )
        >>> viewer._add_layer_from_data(*data)

        """

    def _add_layers_with_plugins(
        self,
        paths: list[typing.Union[str, pathlib.Path]],
        *,
        stack: bool,
        kwargs: Optional[Dict] = None,
        plugin: Optional[str] = None,
        layer_type: Optional[
            Literal[
                graph,
                image,
                labels,
                points,
                shapes,
                surface,
                tracks,
                vectors,
            ]
        ] = None,
    ) -> list[napari.layers.base.base.Layer]:
        """Load a path or a list of paths into the viewer using plugins.

        This function is mostly called from self.open_path, where the ``stack``
        argument determines whether a list of strings is handed to plugins one
        at a time, or en-masse.

        Parameters
        ----------
        paths : list of str
            A filepath, directory, or URL (or a list of any) to open. If a
            list, the assumption is that the list is to be treated as a stack.
        kwargs : dict, optional
            keyword arguments that will be used to overwrite any of those that
            are returned in the meta dict from plugins.
        plugin : str, optional
            Name of a plugin to use.  If provided, will force ``path`` to be
            read with the specified ``plugin``.  If the requested plugin cannot
            read ``path``, an exception will be raised.
        layer_type : str, optional
            If provided, will force data read from ``path`` to be passed to the
            corresponding ``add_<layer_type>`` method (along with any
            additional) ``kwargs`` provided to this function.  This *may*
            result in exceptions if the data returned from the path is not
            compatible with the layer_type.
        stack : bool
            See `open` method
            Stack=False => path is unique string, and list of len(1)
            Stack=True => path is list of path

        Returns
        -------
        List[Layer]
            A list of any layers that were added to the viewer.
        """

    def _layer_help_from_mode(layer: napari.layers.base.base.Layer):
        """
        Update layer help text base on layer mode.
        """

    def _new_labels(self):
        """Create new labels layer filling full world coordinates space."""

    def _on_active_layer(self, event):
        """Update viewer state for a new active layer."""

    def _on_add_layer(self, event):
        """Connect new layer events.

        Parameters
        ----------
        event : :class:`napari.layers.Layer`
            Layer to add.
        """

    def _on_grid_change(self):
        """Arrange the current layers is a 2D grid."""

    def _on_layer_mode_change(self, event): ...
    def _on_layer_reload(
        self, event: napari.utils.events.event.Event
    ) -> None: ...
    def _on_layers_change(self): ...
    def _on_remove_layer(self, event):
        """Disconnect old layer events.

        Parameters
        ----------
        event : napari.utils.event.Event
            Event which will remove a layer.

        Returns
        -------
        layer : :class:`napari.layers.Layer` or list
            The layer that was added (same as input).
        """

    def _open_or_raise_error(
        self,
        paths: list[typing.Union[pathlib.Path, str]],
        kwargs: Optional[Dict[str, Any]] = None,
        layer_type: Optional[
            Literal[
                graph,
                image,
                labels,
                points,
                shapes,
                surface,
                tracks,
                vectors,
            ]
        ] = None,
        stack: bool = False,
    ):
        """Open paths if plugin choice is unambiguous, raising any errors.

        This function will open paths if there is no plugin choice to be made
        i.e. there is a preferred reader associated with this file extension,
        or there is only one plugin available. Any errors that occur during
        the opening process are raised. If multiple plugins
        are available to read these paths, an error is raised specifying
        this.

        Errors are also raised by this function when the given paths are not
        a list or tuple, or if no plugins are available to read the files.
        This assumes all files have the same extension, as other cases
        are not yet supported.

        This function is called from ViewerModel.open, which raises any
        errors returned. The QtViewer also calls this method but catches
        exceptions and opens a dialog for users to make a plugin choice.

        Parameters
        ----------
        paths : List[Path | str]
            list of file paths to open
        kwargs : Dict[str, Any], optional
            keyword arguments to pass to layer adding method, by default {}
        layer_type : Optional[str], optional
            layer type for paths, by default None
        stack : bool or list[list[str]], optional
            True if files should be opened as a stack, by default False.
            Can also be a list containing lists of files to stack.

        Returns
        -------
        added
            list of layers added
        plugin
            plugin used to try opening paths, if any

        Raises
        ------
        TypeError
            when paths is *not* a list or tuple
        NoAvailableReaderError
            when no plugins are available to read path
        ReaderPluginError
            when reading with only available or prefered plugin fails
        MultipleReaderError
            when multiple readers are available to read the path
        """

    def _subplot(self, layer, position, extent):
        """Shift a layer to a specified position in a 2D grid.

        Parameters
        ----------
        layer : napari.layers.Layer
            Layer that is to be moved.
        position : 2-tuple of int
            New position of layer in grid.
        extent : array, shape (2, D)
            Extent of the world.
        """

    def _tooltip_visible_update(self, event): ...
    def _update_async(self, event: napari.utils.events.event.Event) -> None:
        """Set layer slicer to force synchronous if async is disabled."""

    def _update_cursor(self, event):
        """Set the viewer cursor with the `event.cursor` string."""

    def _update_cursor_size(self, event):
        """Set the viewer cursor_size with the `event.cursor_size` int."""

    def _update_layers(self, *, layers=None):
        """Updates the contained layers.

        Parameters
        ----------
        layers : list of napari.layers.Layer, optional
            List of layers to update. If none provided updates all.
        """

    def _update_mouse_pan(self, event):
        """Set the viewer interactive mouse panning"""

    def _update_mouse_zoom(self, event):
        """Set the viewer interactive mouse zoom"""

    def _update_status_bar_from_cursor(self, event=None):
        """Update the status bar based on the current cursor position.

        This is generally used as a callback when cursor.position is updated.
        """

    def _update_viewer_grid(self):
        """Keep viewer grid settings up to date with settings values."""

    def _valid_theme(v): ...
    def add_image(
        self,
        data=None,
        *,
        channel_axis=None,
        affine=None,
        axis_labels=None,
        attenuation=0.05,
        blending=None,
        cache=True,
        colormap=None,
        contrast_limits=None,
        custom_interpolation_kernel_2d=None,
        depiction='volume',
        experimental_clipping_planes=None,
        gamma=1.0,
        interpolation2d='nearest',
        interpolation3d='linear',
        iso_threshold=None,
        metadata=None,
        multiscale=None,
        name=None,
        opacity=1.0,
        plane=None,
        projection_mode='none',
        rendering='mip',
        rgb=None,
        rotate=None,
        scale=None,
        shear=None,
        translate=None,
        units=None,
        visible=True,
    ) -> Union[
        napari.layers.image.image.Image, list[napari.layers.image.image.Image]
    ]:
        """Add one or more Image layers to the layer list.

        Parameters
        ----------
        data : array or list of array
            Image data. Can be N >= 2 dimensional. If the last dimension has length
            3 or 4 can be interpreted as RGB or RGBA if rgb is `True`. If a
            list and arrays are decreasing in shape then the data is treated as
            a multiscale image. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        channel_axis : int, optional
            Axis to expand image along. If provided, each channel in the data
            will be added as an individual image layer. In channel_axis mode,
            other parameters MAY be provided as lists. The Nth value of the list
            will be applied to the Nth channel in the data. If a single value
            is provided, it will be broadcast to all Layers.
            All parameters except data, rgb, and multiscale can be provided as
            list of values. If a list is provided, it must be the same length as
            the axis that is being expanded as channels.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a
            napari `Affine` transform object. Applied as an extra transform on
            top of the provided scale, rotate, and shear values.
        axis_labels : tuple of str
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        attenuation : float or list of float
            Attenuation rate for attenuated maximum intensity projection.
        blending : str or list of str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'translucent', 'translucent_no_depth', 'additive', 'minimum', 'opaque'}.
        cache : bool or list of bool
            Whether slices of out-of-core datasets should be cached upon
            retrieval. Currently, this only applies to dask arrays.
        colormap : str, napari.utils.Colormap, tuple, dict, list or list of these types
            Colormaps to use for luminance images. If a string, it can be the name
            of a supported colormap from vispy or matplotlib or the name of
            a vispy color or a hexadecimal RGB color representation.
            If a tuple, the first value must be a string to assign as a name to a
            colormap and the second item must be a Colormap. If a dict, the key must
            be a string to assign as a name to a colormap and the value must be a
            Colormap.
        contrast_limits : list (2,)
            Intensity value limits to be used for determining the minimum and maximum colormap bounds for
            luminance images. If not passed, they will be calculated as the min and max intensity value of
            the image.
        custom_interpolation_kernel_2d : np.ndarray
            Convolution kernel used with the 'custom' interpolation mode in 2D rendering.
        depiction : str or list of str
            3D Depiction mode. Must be one of {'volume', 'plane'}.
            The default value is 'volume'.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        gamma : float or list of float
            Gamma correction for determining colormap linearity; defaults to 1.
        interpolation2d : str or list of str
            Interpolation mode used by vispy for rendering 2d data.
            Must be one of our supported modes.
            (for list of supported modes see Interpolation enum)
            'custom' is a special mode for 2D interpolation in which a regular grid
            of samples is taken from the texture around a position using 'linear'
            interpolation before being multiplied with a custom interpolation kernel
            (provided with 'custom_interpolation_kernel_2d').
        interpolation3d : str or list of str
            Same as 'interpolation2d' but for 3D rendering.
        iso_threshold : float or list of float
            Threshold for isosurface.
        metadata : dict or list of dict
            Layer metadata.
        multiscale : bool
            Whether the data is a multiscale image or not. Multiscale data is
            represented by a list of array-like image data. If not specified by
            the user and if the data is a list of arrays that decrease in shape,
            then it will be taken to be multiscale. The first image in the list
            should be the largest. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        name : str or list of str
            Name of the layer.
        opacity : float or list
            Opacity of the layer visual, between 0.0 and 1.0.
        plane : dict or SlicingPlane
            Properties defining plane rendering in 3D. Properties are defined in
            data coordinates. Valid dictionary keys are
            {'position', 'normal', 'thickness', and 'enabled'}.
        projection_mode : str
            How data outside the viewed dimensions, but inside the thick Dims slice will
            be projected onto the viewed dimensions. Must fit to cls._projectionclass
        rendering : str or list of str
            Rendering mode used by vispy. Must be one of our supported
            modes. If a list then must be same length as the axis that is being
            expanded as channels.
        rgb : bool, optional
            Whether the image is RGB or RGBA if rgb. If not
            specified by user, but the last dimension of the data has length 3 or 4,
            it will be set as `True`. If `False`, the image is interpreted as a
            luminance image.
        rotate : float, 3-tuple of float, n-D array or list.
            If a float, convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple, convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise, assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            'np.degrees' if needed.
        scale : tuple of float or list of tuple of float
            Scale factors for the layer.
        shear : 1-D array or list.
            A vector of shear values for an upper triangular n-D shear matrix.
        translate : tuple of float or list of tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        visible : bool or list of bool
            Whether the layer visual is currently being displayed.

        Returns
        -------
        layer : :class:`napari.layers.Image` or list
            The newly-created image layer or list of image layers.
        """

    def add_labels(
        self,
        data,
        *,
        affine=None,
        axis_labels=None,
        blending='translucent',
        cache=True,
        colormap=None,
        depiction='volume',
        experimental_clipping_planes=None,
        features=None,
        metadata=None,
        multiscale=None,
        name=None,
        opacity=0.7,
        plane=None,
        projection_mode='none',
        properties=None,
        rendering='iso_categorical',
        rotate=None,
        scale=None,
        shear=None,
        translate=None,
        units=None,
        visible=True,
    ) -> napari.layers.labels.labels.Labels:
        """Add a Labels layer to the layer list.

        Parameters
        ----------
        data : array or list of array
            Labels data as an array or multiscale. Must be integer type or bools.
            Please note multiscale rendering is only supported in 2D. In 3D, only
            the lowest resolution scale is displayed.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        colormap : CyclicLabelColormap or DirectLabelColormap or None
            Colormap to use for the labels. If None, a random colormap will be
            used.
        depiction : str
            3D Depiction mode. Must be one of {'volume', 'plane'}.
            The default value is 'volume'.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a label and each column
            is a feature. The first row corresponds to the background label.
        metadata : dict
            Layer metadata.
        multiscale : bool
            Whether the data is a multiscale image or not. Multiscale data is
            represented by a list of array like image data. If not specified by
            the user and if the data is a list of arrays that decrease in shape
            then it will be taken to be multiscale. The first image in the list
            should be the largest. Please note multiscale rendering is only
            supported in 2D. In 3D, only the lowest resolution scale is
            displayed.
        name : str
            Name of the layer.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        plane : dict or SlicingPlane
            Properties defining plane rendering in 3D. Properties are defined in
            data coordinates. Valid dictionary keys are
            {'position', 'normal', 'thickness', and 'enabled'}.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimensions
        properties : dict {str: array (N,)} or DataFrame
            Properties for each label. Each property should be an array of length
            N, where N is the number of labels, and the first property corresponds
            to background.
        rendering : str
            3D Rendering mode used by vispy. Must be one {'translucent', 'iso_categorical'}.
            'translucent' renders without lighting. 'iso_categorical' uses isosurface
            rendering to calculate lighting effects on labeled surfaces.
            The default value is 'iso_categorical'.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        translate : tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        visible : bool
            Whether the layer visual is currently being displayed.

        Returns
        -------
        layer : :class:`napari.layers.Labels`
            The newly-created labels layer."""

    def add_layer(
        self, layer: napari.layers.base.base.Layer
    ) -> napari.layers.base.base.Layer:
        """Add a layer to the viewer.

        Parameters
        ----------
        layer : :class:`napari.layers.Layer`
            Layer to add.

        Returns
        -------
        layer : :class:`napari.layers.Layer` or list
            The layer that was added (same as input).
        """

    def add_points(
        self,
        data=None,
        ndim=None,
        *,
        affine=None,
        antialiasing=1,
        axis_labels=None,
        blending='translucent',
        border_color='dimgray',
        border_color_cycle=None,
        border_colormap='viridis',
        border_contrast_limits=None,
        border_width=0.05,
        border_width_is_relative=True,
        cache=True,
        canvas_size_limits=(2, 10000),
        experimental_clipping_planes=None,
        face_color='white',
        face_color_cycle=None,
        face_colormap='viridis',
        face_contrast_limits=None,
        feature_defaults=None,
        features=None,
        metadata=None,
        n_dimensional=None,
        name=None,
        opacity=1.0,
        out_of_slice_display=False,
        projection_mode='none',
        properties=None,
        property_choices=None,
        rotate=None,
        scale=None,
        shading='none',
        shear=None,
        shown=True,
        size=10,
        symbol='o',
        text=None,
        translate=None,
        units=None,
        visible=True,
    ) -> napari.layers.points.points.Points:
        """Add a Points layer to the layer list.

        Parameters
        ----------
        data : array (N, D)
            Coordinates for N points in D dimensions.
        ndim : int
            Number of dimensions for shapes. When data is not None, ndim must be D.
            An empty points layer can be instantiated with arbitrary ndim.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        antialiasing: float
            Amount of antialiasing in canvas pixels.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', 'translucent_no_depth', 'additive', and 'minimum'}.
        border_color : str, array-like, dict
            Color of the point marker border. Numeric color values should be RGB(A).
        border_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to border_color if a
            categorical attribute is used color the vectors.
        border_colormap : str, napari.utils.Colormap
            Colormap to set border_color if a continuous attribute is used to set face_color.
        border_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        border_width : float, array
            Width of the symbol border in pixels.
        border_width_is_relative : bool
            If enabled, border_width is interpreted as a fraction of the point size.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        canvas_size_limits : tuple of float
            Lower and upper limits for the size of points in canvas pixels.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        face_color : str, array-like, dict
            Color of the point marker body. Numeric color values should be RGB(A).
        face_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to face_color if a
            categorical attribute is used color the vectors.
        face_colormap : str, napari.utils.Colormap
            Colormap to set face_color if a continuous attribute is used to set face_color.
        face_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        feature_defaults : dict[str, Any] or DataFrame
            The default value of each feature in a table with one row.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a point and each column
            is a feature.
        metadata : dict
            Layer metadata.
        n_dimensional : bool
            This property will soon be deprecated in favor of 'out_of_slice_display'.
            Use that instead.
        name : str
            Name of the layer. If not provided then will be guessed using heuristics.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        out_of_slice_display : bool
            If True, renders points not just in central plane but also slightly out of slice
            according to specified point marker size.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimensions. Must fit to cls._projectionclass.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each point. Each property should be an array of length N,
            where N is the number of points.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shading : str, Shading
            Render lighting and shading on points. Options are:

            * 'none'
              No shading is added to the points.
            * 'spherical'
              Shading and depth buffer are changed to give a 3D spherical look to the points
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        shown : 1-D array of bool
            Whether to show each point.
        size : float, array
            Size of the point marker in data pixels. If given as a scalar, all points are made
            the same size. If given as an array, size must be the same or broadcastable
            to the same shape as the data.
        symbol : str, array
            Symbols to be used for the point markers. Must be one of the
            following: arrow, clobber, cross, diamond, disc, hbar, ring,
            square, star, tailed_arrow, triangle_down, triangle_up, vbar, x.
        text : str, dict
            Text to be displayed with the points. If text is set to a key in properties,
            the value of that property will be displayed. Multiple properties can be
            composed using f-string-like syntax (e.g., '{property_1}, {float_property:.2f}).
            A dictionary can be provided with keyword arguments to set the text values
            and display properties. See TextManager.__init__() for the valid keyword arguments.
            For example usage, see /napari/examples/add_points_with_text.py.
        translate : tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        visible : bool
            Whether the layer visual is currently being displayed.

        Returns
        -------
        layer : :class:`napari.layers.Points`
            The newly-created points layer."""

    def add_shapes(
        self,
        data=None,
        ndim=None,
        *,
        affine=None,
        axis_labels=None,
        blending='translucent',
        cache=True,
        edge_color='#777777',
        edge_color_cycle=None,
        edge_colormap='viridis',
        edge_contrast_limits=None,
        edge_width=1,
        experimental_clipping_planes=None,
        face_color='white',
        face_color_cycle=None,
        face_colormap='viridis',
        face_contrast_limits=None,
        feature_defaults=None,
        features=None,
        metadata=None,
        name=None,
        opacity=0.7,
        projection_mode='none',
        properties=None,
        property_choices=None,
        rotate=None,
        scale=None,
        shape_type='rectangle',
        shear=None,
        text=None,
        translate=None,
        units=None,
        visible=True,
        z_index=0,
    ) -> napari.layers.shapes.shapes.Shapes:
        """Add a Shapes layer to the layer list.

        Parameters
        ----------
        data : list or array
            List of shape data, where each element is an (N, D) array of the
            N vertices of a shape in D dimensions. Can be an 3-dimensional
            array if each shape has the same number of vertices.
        ndim : int
            Number of dimensions for shapes. When data is not None, ndim must be D.
            An empty shapes layer can be instantiated with arbitrary ndim.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        edge_color : str, array-like
            If string can be any color name recognized by vispy or hex value if
            starting with `#`. If array-like must be 1-dimensional array with 3
            or 4 elements. If a list is supplied it must be the same length as
            the length of `data` and each element will be applied to each shape
            otherwise the same value will be used for all shapes.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set edge_color if a continuous attribute is used to set face_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        edge_width : float or list
            Thickness of lines and edges. If a list is supplied it must be the
            same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        face_color : str, array-like
            If string can be any color name recognized by vispy or hex value if
            starting with `#`. If array-like must be 1-dimensional array with 3
            or 4 elements. If a list is supplied it must be the same length as
            the length of `data` and each element will be applied to each shape
            otherwise the same value will be used for all shapes.
        face_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to face_color if a
            categorical attribute is used color the vectors.
        face_colormap : str, napari.utils.Colormap
            Colormap to set face_color if a continuous attribute is used to set face_color.
        face_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        feature_defaults : dict[str, Any] or Dataframe-like
            The default value of each feature in a table with one row.
        features : dict[str, array-like] or Dataframe-like
            Features table where each row corresponds to a shape and each column
            is a feature.
        metadata : dict
            Layer metadata.
        name : str
            Name of the layer.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimenions.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each shape. Each property should be an array of length N,
            where N is the number of shapes.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shape_type : string or list
            String of shape shape_type, must be one of "{'line', 'rectangle',
            'ellipse', 'path', 'polygon'}". If a list is supplied it must be
            the same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        text : str, dict
            Text to be displayed with the shapes. If text is set to a key in properties,
            the value of that property will be displayed. Multiple properties can be
            composed using f-string-like syntax (e.g., '{property_1}, {float_property:.2f}).
            A dictionary can be provided with keyword arguments to set the text values
            and display properties. See TextManager.__init__() for the valid keyword arguments.
            For example usage, see /napari/examples/add_shapes_with_text.py.
        translate : tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        visible : bool
            Whether the layer visual is currently being displayed.
        z_index : int or list
            Specifier of z order priority. Shapes with higher z order are
            displayed ontop of others. If a list is supplied it must be the
            same length as the length of `data` and each element will be
            applied to each shape otherwise the same value will be used for all
            shapes.

        Returns
        -------
        layer : :class:`napari.layers.Shapes`
            The newly-created shapes layer."""

    def add_surface(
        self,
        data,
        *,
        affine=None,
        axis_labels=None,
        blending='translucent',
        cache=True,
        colormap='gray',
        contrast_limits=None,
        experimental_clipping_planes=None,
        feature_defaults=None,
        features=None,
        gamma=1.0,
        metadata=None,
        name=None,
        normals=None,
        opacity=1.0,
        projection_mode='none',
        rotate=None,
        scale=None,
        shading='flat',
        shear=None,
        texcoords=None,
        texture=None,
        translate=None,
        units=None,
        vertex_colors=None,
        visible=True,
        wireframe=None,
    ) -> napari.layers.surface.surface.Surface:
        """Add a Surface layer to the layer list.

        Parameters
        ----------
        data : 2-tuple or 3-tuple of array
            The first element of the tuple is an (N, D) array of vertices of
            mesh triangles.

            The second is an (M, 3) array of int of indices of the mesh triangles.

            The optional third element is the (K0, ..., KL, N) array of values
            (vertex_values) used to color vertices where the additional L
            dimensions are used to color the same mesh with different values. If
            not provided, it defaults to ones.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        colormap : str, napari.utils.Colormap, tuple, dict
            Colormap to use for luminance images. If a string must be the name
            of a supported colormap from vispy or matplotlib. If a tuple the
            first value must be a string to assign as a name to a colormap and
            the second item must be a Colormap. If a dict the key must be a
            string to assign as a name to a colormap and the value must be a
            Colormap.
        contrast_limits : list (2,)
            Color limits to be used for determining the colormap bounds for
            luminance images. If not passed is calculated as the min and max of
            the image.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        feature_defaults : dict[str, Any] or Dataframe-like
            The default value of each feature in a table with one row.
        features : dict[str, array-like] or Dataframe-like
            Features table where each row corresponds to a shape and each column
            is a feature.
        gamma : float
            Gamma correction for determining colormap linearity. Defaults to 1.
        metadata : dict
            Layer metadata.
        name : str
            Name of the layer.
        normals : None, dict or SurfaceNormals
            Whether and how to display the face and vertex normals of the surface mesh.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimenions.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shading : str, Shading
            One of a list of preset shading modes that determine the lighting model
            using when rendering the surface in 3D.

            * ``Shading.NONE``
              Corresponds to ``shading='none'``.
            * ``Shading.FLAT``
              Corresponds to ``shading='flat'``.
            * ``Shading.SMOOTH``
              Corresponds to ``shading='smooth'``.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        texcoords: (N, 2) array
            2D coordinates for each vertex, mapping into the texture.
            The number of texture coords must match the number of vertices (N).
            Coordinates should be in [0.0, 1.0] and are scaled to sample the 2D
            texture. Coordinates outside this range will wrap, but this behavior
            should be considered an implementation detail: there are no plans to
            change it, but it's a feature of the underlying vispy visual.
        texture: (I, J) or (I, J, C) array
            A 2D texture to be mapped onto the mesh using `texcoords`.
            C may be 3 (RGB) or 4 (RGBA) channels for a color texture.
        translate : tuple of float
            Translation values for the layer
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        vertex_colors: (N, C) or (K0, ..., KL, N, C) array of color values
            Take care that the (optional) L additional dimensions match those of
            vertex_values for proper slicing.
            C may be 3 (RGB) or 4 (RGBA) channels..
        visible : bool
            Whether the layer visual is currently being displayed.
        wireframe : None, dict or SurfaceWireframe
            Whether and how to display the edges of the surface mesh with a wireframe.


        Returns
        -------
        layer : :class:`napari.layers.Surface`
            The newly-created surface layer."""

    def add_tracks(
        self,
        data,
        *,
        affine=None,
        axis_labels=None,
        blending='additive',
        cache=True,
        color_by='track_id',
        colormap='turbo',
        colormaps_dict=None,
        experimental_clipping_planes=None,
        features=None,
        graph=None,
        head_length: int = 0,
        metadata=None,
        name=None,
        opacity=1.0,
        projection_mode='none',
        properties=None,
        rotate=None,
        scale=None,
        shear=None,
        tail_length: int = 30,
        tail_width: int = 2,
        translate=None,
        units=None,
        visible=True,
    ) -> napari.layers.tracks.tracks.Tracks:
        """Add a Tracks layer to the layer list.

        Parameters
        ----------
        data : array (N, D+1)
            Coordinates for N points in D+1 dimensions. ID,T,(Z),Y,X. The first
            axis is the integer ID of the track. D is either 3 or 4 for planar
            or volumetric timeseries respectively.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        color_by : str
            Track property (from property keys) by which to color vertices.
        colormap : str
            Default colormap to use to set vertex colors. Specialized colormaps,
            relating to specified properties can be passed to the layer via
            colormaps_dict.
        colormaps_dict : dict {str: napari.utils.Colormap}
            Optional dictionary mapping each property to a colormap for that
            property. This allows each property to be assigned a specific colormap,
            rather than having a global colormap for everything.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        features : Dataframe-like
            Features table where each row corresponds to a point and each column
            is a feature.
        graph : dict {int: list}
            Graph representing associations between tracks. Dictionary defines the
            mapping between a track ID and the parents of the track. This can be
            one (the track has one parent, and the parent has >=1 child) in the
            case of track splitting, or more than one (the track has multiple
            parents, but only one child) in the case of track merging.
            See examples/tracks_3d_with_graph.py
        head_length : float
            Length of the positive (forward in time) tails in units of time.
        metadata : dict
            Layer metadata.
        name : str
            Name of the layer.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimenions.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each point. Each property should be an array of length N,
            where N is the number of points.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        tail_length : float
            Length of the positive (backward in time) tails in units of time.
        tail_width : float
            Width of the track tails in pixels.
        translate : tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.
        visible : bool
            Whether the layer visual is currently being displayed.

        Returns
        -------
        layer : :class:`napari.layers.Tracks`
            The newly-created tracks layer."""

    def add_vectors(
        self,
        data=None,
        *,
        affine=None,
        axis_labels=None,
        blending='translucent',
        cache=True,
        edge_color='red',
        edge_color_cycle=None,
        edge_colormap='viridis',
        edge_contrast_limits=None,
        edge_width=1,
        experimental_clipping_planes=None,
        feature_defaults=None,
        features=None,
        length=1,
        metadata=None,
        name=None,
        ndim=None,
        opacity=0.7,
        out_of_slice_display=False,
        projection_mode='none',
        properties=None,
        property_choices=None,
        rotate=None,
        scale=None,
        shear=None,
        translate=None,
        units=None,
        vector_style='triangle',
        visible=True,
    ) -> napari.layers.vectors.vectors.Vectors:
        """Add a Vectors layer to the layer list.

        Parameters
        ----------
        data : (N, 2, D) or (N1, N2, ..., ND, D) array
            An (N, 2, D) array is interpreted as "coordinate-like" data and a
            list of N vectors with start point and projections of the vector in
            D dimensions. An (N1, N2, ..., ND, D) array is interpreted as
            "image-like" data where there is a length D vector of the
            projections at each pixel.
        affine : n-D array or napari.utils.transforms.Affine
            (N+1, N+1) affine transformation matrix in homogeneous coordinates.
            The first (N, N) entries correspond to a linear transform and
            the final column is a length N translation vector and a 1 or a napari
            `Affine` transform object. Applied as an extra transform on top of the
            provided scale, rotate, and shear values.
        axis_labels : tuple of str, optional
            Dimension names of the layer data.
            If not provided, axis_labels will be set to (..., 'axis -2', 'axis -1').
        blending : str
            One of a list of preset blending modes that determines how RGB and
            alpha values of the layer visual get mixed. Allowed values are
            {'opaque', 'translucent', and 'additive'}.
        cache : bool
            Whether slices of out-of-core datasets should be cached upon retrieval.
            Currently, this only applies to dask arrays.
        edge_color : str
            Color of all of the vectors.
        edge_color_cycle : np.ndarray, list
            Cycle of colors (provided as string name, RGB, or RGBA) to map to edge_color if a
            categorical attribute is used color the vectors.
        edge_colormap : str, napari.utils.Colormap
            Colormap to set vector color if a continuous attribute is used to set edge_color.
        edge_contrast_limits : None, (float, float)
            clims for mapping the property to a color map. These are the min and max value
            of the specified property that are mapped to 0 and 1, respectively.
            The default value is None. If set the none, the clims will be set to
            (property.min(), property.max())
        edge_width : float
            Width for all vectors in pixels.
        experimental_clipping_planes : list of dicts, list of ClippingPlane, or ClippingPlaneList
            Each dict defines a clipping plane in 3D in data coordinates.
            Valid dictionary keys are {'position', 'normal', and 'enabled'}.
            Values on the negative side of the normal are discarded if the plane is enabled.
        feature_defaults : dict[str, Any] or DataFrame
            The default value of each feature in a table with one row.
        features : dict[str, array-like] or DataFrame
            Features table where each row corresponds to a vector and each column
            is a feature.
        length : float
            Multiplicative factor on projections for length of all vectors.
        metadata : dict
            Layer metadata.
        name : str
            Name of the layer.
        ndim : int
            Number of dimensions for vectors. When data is not None, ndim must be D.
            An empty vectors layer can be instantiated with arbitrary ndim.
        opacity : float
            Opacity of the layer visual, between 0.0 and 1.0.
        out_of_slice_display : bool
            If True, renders vectors not just in central plane but also slightly out of slice
            according to specified point marker size.
        projection_mode : str
            How data outside the viewed dimensions but inside the thick Dims slice will
            be projected onto the viewed dimenions.
        properties : dict {str: array (N,)}, DataFrame
            Properties for each vector. Each property should be an array of length N,
            where N is the number of vectors.
        property_choices : dict {str: array (N,)}
            possible values for each property.
        rotate : float, 3-tuple of float, or n-D array.
            If a float convert into a 2D rotation matrix using that value as an
            angle. If 3-tuple convert into a 3D rotation matrix, using a yaw,
            pitch, roll convention. Otherwise assume an nD rotation. Angles are
            assumed to be in degrees. They can be converted from radians with
            np.degrees if needed.
        scale : tuple of float
            Scale factors for the layer.
        shear : 1-D array or n-D array
            Either a vector of upper triangular values, or an nD shear matrix with
            ones along the main diagonal.
        translate : tuple of float
            Translation values for the layer.
        units : tuple of str or pint.Unit, optional
            Units of the layer data in world coordinates.
            If not provided, the default units are assumed to be pixels.

        vector_style : str
            One of a list of preset display modes that determines how vectors are displayed.
            Allowed values are {'line', 'triangle', and 'arrow'}.
        visible : bool
            Whether the layer visual is currently being displayed.

        Returns
        -------
        layer : :class:`napari.layers.Vectors`
            The newly-created vectors layer."""

    def open(
        self,
        path: Union[
            str,
            pathlib.Path,
            collections.abc.Sequence[Union[str, pathlib.Path]],
        ],
        *,
        stack: Union[bool, list[list[Union[str, pathlib.Path]]]] = False,
        plugin: Optional[str] = 'napari',
        layer_type: Optional[
            Literal[
                graph,
                image,
                labels,
                points,
                shapes,
                surface,
                tracks,
                vectors,
            ]
        ] = None,
        **kwargs,
    ) -> list[napari.layers.base.base.Layer]:
        """Open a path or list of paths with plugins, and add layers to viewer.

        A list of paths will be handed one-by-one to the napari_get_reader hook
        if stack is False, otherwise the full list is passed to each plugin
        hook.

        Parameters
        ----------
        path : str or list of str
            A filepath, directory, or URL (or a list of any) to open.
        stack : bool or list[list[str]], optional
            If a list of strings is passed as ``path`` and ``stack`` is ``True``, then the
            entire list will be passed to plugins.  It is then up to individual
            plugins to know how to handle a list of paths.  If ``stack`` is
            ``False``, then the ``path`` list is broken up and passed to plugin
            readers one by one.  by default False.
            If the stack option is a list of lists containing individual paths,
            the inner lists are passedto the reader and will be stacked.
        plugin : str, optional
            Name of a plugin to use, by default builtins.  If provided, will
            force ``path`` to be read with the specified ``plugin``.
            If None, ``plugin`` will be read from preferences or inferred if just
            one reader is compatible.
            If the requested plugin cannot read ``path``, an exception will be raised.
        layer_type : str, optional
            If provided, will force data read from ``path`` to be passed to the
            corresponding ``add_<layer_type>`` method (along with any
            additional) ``kwargs`` provided to this function.  This *may*
            result in exceptions if the data returned from the path is not
            compatible with the layer_type.
        **kwargs
            All other keyword arguments will be passed on to the respective
            ``add_layer`` method.

        Returns
        -------
        layers : list
            A list of any layers that were added to the viewer.
        """

    def open_sample(
        self,
        plugin: str,
        sample: str,
        reader_plugin: Optional[str] = None,
        **kwargs,
    ) -> list[napari.layers.base.base.Layer]:
        """Open `sample` from `plugin` and add it to the viewer.

        To see all available samples registered by plugins, use
        :func:`napari.plugins.available_samples`

        Parameters
        ----------
        plugin : str
            name of a plugin providing a sample
        sample : str
            name of the sample
        reader_plugin : str, optional
            reader plugin to use, passed to ``viewer.open``. Only used if the
            sample data is an URI (Uniform Resource Identifier). By default None.
        **kwargs
            additional kwargs will be passed to the sample data loader provided
            by `plugin`.  Use of ``**kwargs`` may raise an error if the kwargs do
            not match the sample data loader.

        Returns
        -------
        layers : list
            A list of any layers that were added to the viewer.

        Raises
        ------
        KeyError
            If `plugin` does not provide a sample named `sample`.
        """

    def reset_view(self, *, margin: float = 0.05) -> None:
        """Reset the camera view.

        Parameters
        ----------
        margin : float in [0, 1)
            Margin as fraction of the canvas, showing blank space around the
            data.
        """

    def rounded_division(min_val, max_val, precision): ...

def valid_add_kwargs() -> dict[str, set[str]]:
    """Return a dict where keys are layer types & values are valid kwargs."""
