// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef NETDATA_WINDOWS_PLUGIN_H
#define NETDATA_WINDOWS_PLUGIN_H

#include "database/rrd.h"

#define PLUGIN_WINDOWS_NAME "windows.plugin"

// https://learn.microsoft.com/es-es/windows/win32/sysinfo/kernel-objects?redirectedfrom=MSDN
// 2^24
#define WINDOWS_MAX_KERNEL_OBJECT 16777216

void *win_plugin_main(void *ptr);

extern char windows_shared_buffer[8192];

int do_GetSystemUptime(int update_every, usec_t dt);
int do_GetSystemRAM(int update_every, usec_t dt);
int do_GetSystemCPU(int update_every, usec_t dt);
int do_PerflibStorage(int update_every, usec_t dt);
int do_PerflibNetwork(int update_every, usec_t dt);
int do_PerflibProcesses(int update_every, usec_t dt);
int do_PerflibProcessor(int update_every, usec_t dt);
int do_PerflibMemory(int update_every, usec_t dt);
int do_PerflibObjects(int update_every, usec_t dt);
int do_PerflibThermalZone(int update_every, usec_t dt);
int do_PerflibWebService(int update_every, usec_t dt);
int do_PerflibMSSQL(int update_every, usec_t dt);
int do_PerflibNetFramework(int update_every, usec_t dt);
int do_PerflibAD(int update_every, usec_t dt);
int do_PerflibADCS(int update_every, usec_t dt);
int do_PerflibADFS(int update_every, usec_t dt);

enum PERFLIB_PRIO {
    PRIO_WEBSITE_IIS_REQUESTS_RATE = 21000, // PRIO selected, because APPS is using 20YYY
    PRIO_WEBSITE_IIS_REQUESTS_BY_TYPE_RATE,
    PRIO_WEBSITE_IIS_TRAFFIC,
    PRIO_WEBSITE_IIS_FTP_FILE_TRANSFER_RATE,
    PRIO_WEBSITE_IIS_ACTIVE_CONNECTIONS_COUNT,
    PRIO_WEBSITE_IIS_CONNECTIONS_ATTEMP,
    PRIO_WEBSITE_IIS_USERS,
    PRIO_WEBSITE_IIS_ISAPI_EXT_REQUEST_COUNT,
    PRIO_WEBSITE_IIS_ISAPI_EXT_REQUEST_RATE,
    PRIO_WEBSITE_IIS_ERRORS_RATE,
    PRIO_WEBSITE_IIS_LOGON_ATTEMPTS,
    PRIO_WEBSITE_IIS_UPTIME,

    PRIO_IIS_APP_POOL_STATE,
    PRIO_IIS_APP_POOL_WORKER_PROCESSES_CURRENT,
    PRIO_IIS_APP_POOL_WORKER_PROCESSES_MAX,
    PRIO_IIS_APP_POOL_WORKER_PROCESS_RECENT_FAILURES,
    PRIO_IIS_APP_POOL_RECYCLES,
    PRIO_IIS_APP_POOL_TOTAL_WORKER_PROCESSES_CREATED,
    PRIO_IIS_APP_POOL_TOTAL_WORKER_PROCESS_FAILURES,
    PRIO_IIS_APP_POOL_TOTAL_WORKER_PROCESS_PING_FAILURES,
    PRIO_IIS_APP_POOL_TOTAL_WORKER_PROCESS_SHUTDOWN_FAILURES,
    PRIO_IIS_APP_POOL_TOTAL_WORKER_PROCESS_STARTUP_FAILURES,
    PRIO_IIS_APP_POOL_TOTAL_UPTIME,

    PRIO_MSSQL_USER_CONNECTIONS,

    PRIO_MSSQL_DATABASE_TRANSACTIONS,
    PRIO_MSSQL_DATABASE_ACTIVE_TRANSACTIONS,
    PRIO_MSSQL_DATABASE_WRITE_TRANSACTIONS,
    PRIO_MSSQL_DATABASE_BACKUP_RESTORE_OPERATIONS,
    PRIO_MSSQL_DATABASE_LOG_FLUSHES,
    PRIO_MSSQL_DATABASE_LOG_FLUSHED,

    PRIO_MSSQL_DATABASE_DATA_FILE_SIZE,

    PRIO_MSSQL_STATS_BATCH_REQUEST,
    PRIO_MSSQL_STATS_COMPILATIONS,
    PRIO_MSSQL_STATS_RECOMPILATIONS,
    PRIO_MSSQL_STATS_AUTO_PARAMETRIZATION,
    PRIO_MSSQL_STATS_SAFE_AUTO_PARAMETRIZATION,

    PRIO_MSSQL_BLOCKED_PROCESSES,

    PRIO_MSSQL_BUFF_CACHE_HIT_RATIO,
    PRIO_MSSQL_BUFF_MAN_IOPS,
    PRIO_MSSQL_BUFF_CHECKPOINT_PAGES,
    PRIO_MSSQL_BUFF_METHODS_PAGE_SPLIT,
    PRIO_MSSQL_BUFF_PAGE_LIFE_EXPECTANCY,

    PRIO_MSSQL_MEMMGR_CONNECTION_MEMORY_BYTES,
    PRIO_MSSQL_MEMMGR_TOTAL_SERVER,
    PRIO_MSSQL_MEMMGR_EXTERNAL_BENEFIT_OF_MEMORY,
    PRIO_MSSQL_MEMMGR_PENDING_MEMORY_GRANTS,

    PRIO_MSSQL_LOCKS_WAIT,
    PRIO_MSSQL_LOCKS_DEADLOCK,

    PRIO_MSSQL_SQL_ERRORS,

    PRIO_NETFRAMEWORK_CLR_EXCEPTION_THROWN,
    PRIO_NETFRAMEWORK_CLR_EXCEPTION_FILTERS,
    PRIO_NETFRAMEWORK_CLR_EXCEPTION_FINALLYS,
    PRIO_NETFRAMEWORK_CLR_EXCEPTION_THROW_TO_CATCH_DEPTH,

    PRIO_NETFRAMEWORK_CLR_INTEROP_CCW,
    PRIO_NETFRAMEWORK_CLR_INTEROP_MARSHALLING,
    PRIO_NETFRAMEWORK_CLR_INTEROP_STUBS_CREATED,

    PRIO_NETFRAMEWORK_CLR_JIT_METHODS,
    PRIO_NETFRAMEWORK_CLR_JIT_TIME,
    PRIO_NETFRAMEWORK_CLR_JIT_STANDARD_FAILURES,
    PRIO_NETFRAMEWORK_CLR_JIT_IL_BYTES,

    PRIO_NETFRAMEWORK_CLR_LOADING_HEAP_SIZE,
    PRIO_NETFRAMEWORK_CLR_LOADING_APP_DOMAINS_LOADED,
    PRIO_NETFRAMEWORK_CLR_LOADING_APP_DOMAINS_UNLOADED,
    PRIO_NETFRAMEWORK_CLR_LOADING_ASSEMBLIES_LOADED,
    PRIO_NETFRAMEWORK_CLR_LOADING_CLASSES_LOADED,
    PRIO_NETFRAMEWORK_CLR_LOADING_CLASS_LOAD_FAILURE,

    PRIO_NETFRAMEWORK_CLR_REMOTING_CHANNELS,
    PRIO_NETFRAMEWORK_CLR_REMOTING_CONTEXT_BOUND_CLASSES_LOADED,
    PRIO_NETFRAMEWORK_CLR_REMOTING_CONTEXT_BOUND_OBJECTS,
    PRIO_NETFRAMEWORK_CLR_REMOTING_CONTEXTS_PROXIES,
    PRIO_NETFRAMEWORK_CLR_REMOTING_CONTEXTS,
    PRIO_NETFRAMEWORK_CLR_REMOTING_REMOTE_CALLS,

    PRIO_NETFRAMEWORK_CLR_SECURITY_LINK_TIME_CHECKS,
    PRIO_NETFRAMEWORK_CLR_SECURITY_RT_CHECKS_TIME,
    PRIO_NETFRAMEWORK_CLR_SECURITY_STACK_WALK_DEPTH,
    PRIO_NETFRAMEWORK_CLR_SECURITY_RUNTIME_CHECKS,

    PRIO_NETFRAMEWORK_CLR_LOCKS_AND_THREADS_QUEUE_LENGTH,
    PRIO_NETFRAMEWORK_CLR_LOCKS_AND_THREADS_LOGICAL_THREADS,
    PRIO_NETFRAMEWORK_CLR_LOCKS_AND_THREADS_CURRENT_PHYSICAL_THREADS,
    PRIO_NETFRAMEWORK_CLR_LOCKS_AND_THREADS_RECOGNIZED_THREADS,
    PRIO_NETFRAMEWORK_CLR_LOCKS_AND_THREADS_CONTENTIONS,

    PRIO_AD_OPERATIONS_TOTAL,
    PRIO_AD_DIROPERATIONS_TOTAL,
    PRIO_AD_CACHE_LOOKUP_TOTAL,
    PRIO_AD_CACHE_HITS_TOTAL,
    PRIO_AD_REPLICATION_INTRASITE_COMPRESSED,
    PRIO_AD_REPLICATION_INTERSITE_COMPRESSED,
    PRIO_AD_SYNC_OBJECTS_REMAINING,
    PRIO_AD_REPLICATION_PROPERTY_UPDATED,
    PRIO_AD_REPLICATION_PROPERTY_FILTERED,
    PRIO_AD_SYNC_PENDING,
    PRIO_AD_SYNC_TOTAL,
    PRIO_AD_THREADS_IN_USE,
    PRIO_AD_BIND_TIME,
    PRIO_AD_BIND_TOTAL,
    PRIO_AD_LDAP_SEARCHES_TOTAL,
    PRIO_AD_AVG_REQUEST_LATENCY,
    PRIO_AD_OUTSTANDING_REQUEST,

    PRIO_ADCS_CERT_REQUESTS_TOTAL,
    PRIO_ADCS_CERT_REQUESTS_PROCESSING_TIME,
    PRIO_ADCS_CERT_RETRIVALS,
    PRIO_ADCS_CERT_FAILED_REQUESTS,
    PRIO_ADCS_CERT_ISSUED_REQUESTS,
    PRIO_ADCS_CERT_PENDING_REQUESTS,
    PRIO_ADCS_CERT_CHALLENGE_RESPONSES,
    PRIO_ADCS_CERT_RETRIEVAL_PROCESSING_TIME,
    PRIO_ADCS_CERT_REQ_CRYPTO_SIGNING_TIME,
    PRIO_ADCS_CERT_REQ_POLICY_MODULE_PROCESS_TIME,
    PRIO_ADCS_CERT_CHALLENGE_RESP_PROCESSING_TIME,
    PRIO_ADCS_CERT_SIGNED_CERTIFICATE_TIMESTAMP_LIST,
    PRIO_ADCS_CERT_SIGNED_CERTIFICATE_TIMESTAMP_PROC_TIME_LIST,

    PRIO_ADFS_LOGIN_CONNECTION_FAILURES_TOTAL,
    PRIO_ADFS_CERTIFICATE_AUTHENTICATION_TOTAL,
    PRIO_ADFS_DB_ARTIFACT_FAILURE_TOTAL,
    PRIO_ADFS_DB_ARTIFACT_QUERY_TYME_SECONDS_TOTAL,
    PRIO_ADFS_DB_CONFIG_FAILURE_TOTAL,
    PRIO_ADFS_DB_CONFIG_QUERY_TYME_SECONDS_TOTAL,
    PRIO_ADFS_DEVICE_AUTHENTICATIONS_TOTAL,
    PRIO_ADFS_EXTERNAL_AUTHENTICATION_TOTAL,
    PRIO_ADFS_FEDERATION_AUTHENTICATION_TOTAL,
    PRIO_ADFS_FEDERATION_REQUESTS_AUTHENTICATION_TOTAL,

    PRIO_ADFS_OAUTH_AUTHORIZED_REQUEST,
    PRIO_ADFS_OAUTH_CLIENT_AUTHORIZATION_REQUEST,
    PRIO_ADFS_OAUTH_CLIENT_CREDENTIAL_REQUEST,
    PRIO_ADFS_OAUTH_CLIENT_PRV_KEY_JWT_AUTH,
    PRIO_ADFS_OAUTH_CLIENT_SECRET_BASIC_AUTH,
    PRIO_ADFS_OAUTH_CLIENT_SECRET_POST_AUTH,
    PRIO_ADFS_OAUTH_CLIENT_WINDOWS_AUTH,
    PRIO_ADFS_OAUTH_TOKEN_REQUESTS_SUCCESS,

    PRIO_ADFS_PASSIVE_REQUESTS,
    PRIO_ADFS_PASSPORT_AUTHENTICATOR,
    PRIO_ADFS_PASSWORD_CHANGE_REQUEST,
    PRIO_ADFS_SAMLP_TOKEN_REQUESTS,
    PRIO_ADFS_SSO_AUTH,
    PRIO_ADFS_TRUST_TOKEN_SUCCESS,
    PRIO_ADFS_USER_PASS_AUTH,
    PRIO_ADFS_WSFED_TOKEN_REQUESTS
};

int do_PerflibHyperV(int update_every, usec_t dt);

#endif //NETDATA_WINDOWS_PLUGIN_H
