// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef NETDATA_ALL_H
#define NETDATA_ALL_H 1

#include "database/rrd.h"

// netdata internal data collection plugins

#include "plugins.d/plugins_d.h"

// ----------------------------------------------------------------------------
// netdata chart priorities

// This is a work in progress - to scope is to collect here all chart priorities.
// These should be based on the CONTEXT of the charts + the chart id when needed
// - for each SECTION +1000 (or +X000 for big sections)
// - for each FAMILY  +100
// - for each CHART   +10

#define NETDATA_CHART_PRIO_SYSTEM_CPU                   100
#define NETDATA_CHART_PRIO_SYSTEM_LOAD                  100
#define NETDATA_CHART_PRIO_SYSTEM_IO                    150
#define NETDATA_CHART_PRIO_SYSTEM_PGPGIO                151
#define NETDATA_CHART_PRIO_SYSTEM_RAM                   200
#define NETDATA_CHART_PRIO_SYSTEM_NET                   500
#define NETDATA_CHART_PRIO_SYSTEM_IPV4                  500 // freebsd only
#define NETDATA_CHART_PRIO_SYSTEM_IP                    501
#define NETDATA_CHART_PRIO_SYSTEM_IPV6                  502
#define NETDATA_CHART_PRIO_SYSTEM_PROCESSES             600
#define NETDATA_CHART_PRIO_SYSTEM_PROCESS_STATES        601
#define NETDATA_CHART_PRIO_SYSTEM_FORKS                 700
#define NETDATA_CHART_PRIO_SYSTEM_ACTIVE_PROCESSES      750
#define NETDATA_CHART_PRIO_SYSTEM_CTXT                  800
#define NETDATA_CHART_PRIO_SYSTEM_IDLEJITTER            800
#define NETDATA_CHART_PRIO_SYSTEM_INTR                  900
#define NETDATA_CHART_PRIO_SYSTEM_SOFTIRQS              950
#define NETDATA_CHART_PRIO_SYSTEM_SOFTNET_STAT          955
#define NETDATA_CHART_PRIO_SYSTEM_INTERRUPTS           1000
#define NETDATA_CHART_PRIO_SYSTEM_DEV_INTR             1000 // freebsd only
#define NETDATA_CHART_PRIO_SYSTEM_SOFT_INTR            1100 // freebsd only
#define NETDATA_CHART_PRIO_SYSTEM_FILES_NR             1000
#define NETDATA_CHART_PRIO_SYSTEM_ENTROPY              1000
#define NETDATA_CHART_PRIO_SYSTEM_UPTIME               1000
#define NETDATA_CHART_PRIO_SYSTEM_REBOOT_REQUIRED      1010
#define NETDATA_CHART_PRIO_CLOCK_SYNC_STATE            1100
#define NETDATA_CHART_PRIO_CLOCK_STATUS                1105
#define NETDATA_CHART_PRIO_CLOCK_SYNC_OFFSET           1110
#define NETDATA_CHART_PRIO_SYSTEM_IPC_MSQ_QUEUES       1200 // freebsd only
#define NETDATA_CHART_PRIO_SYSTEM_IPC_MSQ_MESSAGES     1201
#define NETDATA_CHART_PRIO_SYSTEM_IPC_MSQ_SIZE         1202
#define NETDATA_CHART_PRIO_SYSTEM_IPC_SEMAPHORES       1203
#define NETDATA_CHART_PRIO_SYSTEM_IPC_SEM_ARRAYS       1204
#define NETDATA_CHART_PRIO_SYSTEM_IPC_SHARED_MEM_SEGS  1205
#define NETDATA_CHART_PRIO_SYSTEM_IPC_SHARED_MEM_SIZE  1206
#define NETDATA_CHART_PRIO_SYSTEM_IPC_SHARED_MEM_CALLS 1207
#define NETDATA_CHART_PRIO_SYSTEM_PACKETS              7001 // freebsd only
#define NETDATA_CHART_PRIO_WINDOWS_THREADS             8001 // Windows only
#define NETDATA_CHART_PRIO_WINDOWS_THERMAL_ZONES       8002 // Windows only

// ----------------------------------------------------------------------------
// Hyper-V

#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_CPU_USAGE 20000
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_CPU_USAGE_BY_RUN_CONTEXT 20010
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_MEMORY_PHYSICAL 20020
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_MEMORY_PHYSICAL_GUEST_VISIBLE 20030
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_MEMORY_PRESSURE_CURRENT 20040
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_VID_PHYSICAL_PAGES_ALLOCATED 20050
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_VID_REMOTE_PHYSICAL_PAGES 20060
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_TRAFFIC 20070
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_IPSEC_TRAFFIC 20080
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_PACKETS 20090
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_BROADCAST_PACKETS 20100
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_MULTICAST_PACKETS 20110
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_DIRECTED_PACKETS 20120
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_NET_INTERFACE_PACKETS_DROPPED 20130
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_STORAGE_DEVICE_BYTES 20140
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_STORAGE_DEVICE_ERRORS 20150
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VM_STORAGE_DEVICE_OPERATIONS 20160
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VMS_HEALTH 20170

#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_TRAFFIC 20400
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_PACKETS 20410
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_BROADCAST_PACKETS 20420
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_MULTICAST_PACKETS 20430
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_DIRECTED_PACKETS 20440
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_PACKETS_FLOODED 20450
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_DROPPED_PACKETS 20460
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_EXTENSIONS_DROPPED_PACKETS 20470
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_LEARNED_MAC_ADDRESSES 20470
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_VSWITCH_PURGED_MAC_ADDRESSES 20480

#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_IO_TLB_FLUSH 20600
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_VIRTUAL_TLB_FLUSH_ENTRIES 20610
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_VIRTUAL_TLB_PAGES 20620
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_ADDRESS_SPACE 20630
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_ATTACHED_DEVICES 20640
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_DEVICE_DMA_ERRORS 20650
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_DEVICE_INTERRUPT_ERRORS 20660
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_DEVICE_INTERRUPT_THROTTLE_EVENTS 20670
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_DEPOSITED_PAGES 20680
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_GPA_SPACE_PAGES 20690
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_DEVICE_SPACE_PAGES 20700
#define NETDATA_CHART_PRIO_WINDOWS_HYPERV_ROOT_PARTITION_GPA_SPACE_MODIFICATIONS 20710
// ----------------------------------------------------------------------------

// CPU per core

#define NETDATA_CHART_PRIO_CPU_PER_CORE               1000 // +1 per core
#define NETDATA_CHART_PRIO_CPUFREQ_SCALING_CUR_FREQ   1002
#define NETDATA_CHART_PRIO_CORE_THROTTLING            1003
#define NETDATA_CHART_PRIO_PACKAGE_THROTTLING         1004
#define NETDATA_CHART_PRIO_CPUIDLE                    1005
#define NETDATA_CHART_PRIO_INTERRUPTS_PER_CORE        1006 // +1 per core
#define NETDATA_CHART_PRIO_POWERCAP                   1007 // Linux powercap
#define NETDATA_CHART_PRIO_CPU_TEMPERATURE            1050 // freebsd only


// Memory Section - 1xxx

#define NETDATA_CHART_PRIO_MEM_SYSTEM_AVAILABLE       1010
#define NETDATA_CHART_PRIO_MEM_SYSTEM_OOM_KILL        1020
#define NETDATA_CHART_PRIO_MEM_SYSTEM_COMMITTED       1030
#define NETDATA_CHART_PRIO_MEM_SWAP                   1035
#define NETDATA_CHART_PRIO_MEM_SWAP_CALLS             1037
#define NETDATA_CHART_PRIO_MEM_SWAP_PAGES             1037 // Windows only
#define NETDATA_CHART_PRIO_MEM_SWAPIO                 1038
#define NETDATA_CHART_PRIO_MEM_SYSTEM_POOL            1039 // Windows only
#define NETDATA_CHART_PRIO_MEM_ZSWAP                  1036
#define NETDATA_CHART_PRIO_MEM_ZSWAPIO                1037
#define NETDATA_CHART_PRIO_MEM_ZSWAP_COMPRESS_RATIO   1038
#define NETDATA_CHART_PRIO_MEM_ZSWAP_POOL_TOT_SIZE    1039
#define NETDATA_CHART_PRIO_MEM_ZSWAP_STORED_PAGE      1040
#define NETDATA_CHART_PRIO_MEM_ZSWAP_REJECTS          1041
#define NETDATA_CHART_PRIO_MEM_ZSWAP_POOL_LIM_HIT     1042
#define NETDATA_CHART_PRIO_MEM_ZSWAP_WRT_BACK_PAGES   1043
#define NETDATA_CHART_PRIO_MEM_ZSWAP_SAME_FILL_PAGE   1044
#define NETDATA_CHART_PRIO_MEM_ZSWAP_DUPP_ENTRY       1045
#define NETDATA_CHART_PRIO_MEM_SYSTEM_PGFAULTS        1050
#define NETDATA_CHART_PRIO_MEM_KERNEL                 1100
#define NETDATA_CHART_PRIO_MEM_SLAB                   1200
#define NETDATA_CHART_PRIO_MEM_RECLAIMING             1210
#define NETDATA_CHART_PRIO_MEM_HIGH_LOW               1211
#define NETDATA_CHART_PRIO_MEM_CMA                    1212
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES              1250
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_DETAILS      1251
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_FAULTS       1252
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_FILE         1253
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_ZERO         1254
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_KHUGEPAGED   1255
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_SPLITS       1256
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_SWAPOUT      1257
#define NETDATA_CHART_PRIO_MEM_HUGEPAGES_COMPACT      1258
#define NETDATA_CHART_PRIO_MEM_DIRECTMAP              1260
#define NETDATA_CHART_PRIO_MEM_KSM                    1300
#define NETDATA_CHART_PRIO_MEM_KSM_SAVINGS            1301
#define NETDATA_CHART_PRIO_MEM_KSM_RATIOS             1302
#define NETDATA_CHART_PRIO_MEM_KSM_COW                1303
#define NETDATA_CHART_PRIO_MEM_BALLOON                1350
#define NETDATA_CHART_PRIO_MEM_NUMA                   1400
#define NETDATA_CHART_PRIO_MEM_NUMA_NODES_NUMASTAT    1410
#define NETDATA_CHART_PRIO_MEM_NUMA_NODES_MEMINFO     1411
#define NETDATA_CHART_PRIO_MEM_NUMA_NODES_ACTIVITY    1412
#define NETDATA_CHART_PRIO_MEM_PAGEFRAG               1450
#define NETDATA_CHART_PRIO_MEM_HW                     1500
#define NETDATA_CHART_PRIO_MEM_HW_ECC_CE              1550
#define NETDATA_CHART_PRIO_MEM_HW_ECC_UE              1560
#define NETDATA_CHART_PRIO_MEM_ZRAM                   1600
#define NETDATA_CHART_PRIO_MEM_ZRAM_SAVINGS           1601
#define NETDATA_CHART_PRIO_MEM_ZRAM_RATIO             1602
#define NETDATA_CHART_PRIO_MEM_ZRAM_EFFICIENCY        1603
#define NETDATA_CHART_PRIO_MEM_FRAGMENTATION          1700

// Disks

#define NETDATA_CHART_PRIO_DISK_IO                    2000
#define NETDATA_CHART_PRIO_DISK_OPS                   2010
#define NETDATA_CHART_PRIO_DISK_QOPS                  2015
#define NETDATA_CHART_PRIO_DISK_BACKLOG               2020
#define NETDATA_CHART_PRIO_DISK_BUSY                  2030
#define NETDATA_CHART_PRIO_DISK_UTIL                  2040
#define NETDATA_CHART_PRIO_DISK_AWAIT                 2050
#define NETDATA_CHART_PRIO_DISK_AVGSZ                 2060
#define NETDATA_CHART_PRIO_DISK_SVCTM                 2070
#define NETDATA_CHART_PRIO_DISK_MOPS                  2080
#define NETDATA_CHART_PRIO_DISK_IOTIME                2090
#define NETDATA_CHART_PRIO_DISK_LATENCY               2095
#define NETDATA_CHART_PRIO_DISK_SPLIT                 2096
#define NETDATA_CHART_PRIO_BCACHE_CACHE_ALLOC         2120
#define NETDATA_CHART_PRIO_BCACHE_HIT_RATIO           2120
#define NETDATA_CHART_PRIO_BCACHE_RATES               2121
#define NETDATA_CHART_PRIO_BCACHE_SIZE                2122
#define NETDATA_CHART_PRIO_BCACHE_USAGE               2123
#define NETDATA_CHART_PRIO_BCACHE_OPS                 2124
#define NETDATA_CHART_PRIO_BCACHE_BYPASS              2125
#define NETDATA_CHART_PRIO_BCACHE_CACHE_READ_RACES    2126

#define NETDATA_CHART_PRIO_DISKSPACE_SPACE            2023
#define NETDATA_CHART_PRIO_DISKSPACE_INODES           2024

// MDSTAT

#define NETDATA_CHART_PRIO_MDSTAT_HEALTH              2100
#define NETDATA_CHART_PRIO_MDSTAT_FLUSH               2101
#define NETDATA_CHART_PRIO_MDSTAT_NONREDUNDANT        2105
#define NETDATA_CHART_PRIO_MDSTAT_DISKS               2106 // 5 charts per raid
#define NETDATA_CHART_PRIO_MDSTAT_MISMATCH            2107
#define NETDATA_CHART_PRIO_MDSTAT_OPERATION           2108
#define NETDATA_CHART_PRIO_MDSTAT_FINISH              2109
#define NETDATA_CHART_PRIO_MDSTAT_SPEED               2110

// Filesystem
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_CLEAN       2150
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_COUNT    2151
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_BYTES    2152
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_EBYTES   2153
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_FSYNC    2154
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_EFSYNC   2155
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_OPEN     2156
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_EOPEN    2157
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_CREATE   2158
#define NETDATA_CHART_PRIO_FILESYSTEM_VFS_IO_ECREATE  2159

#define NETDATA_CHART_PRIO_EBPF_FILESYSTEM_CHARTS     2160

// Mount Points
#define NETDATA_CHART_PRIO_EBPF_MOUNT_CHARTS          2190

// File descriptor
#define NETDATA_CHART_PRIO_EBPF_FD_CHARTS             2195


// NFS (server)

#define NETDATA_CHART_PRIO_NFSD_READCACHE             2200
#define NETDATA_CHART_PRIO_NFSD_FILEHANDLES           2201
#define NETDATA_CHART_PRIO_NFSD_IO                    2202
#define NETDATA_CHART_PRIO_NFSD_THREADS               2203
#define NETDATA_CHART_PRIO_NFSD_THREADS_FULLCNT       2204
#define NETDATA_CHART_PRIO_NFSD_THREADS_HISTOGRAM     2205
#define NETDATA_CHART_PRIO_NFSD_READAHEAD             2205
#define NETDATA_CHART_PRIO_NFSD_NET                   2207
#define NETDATA_CHART_PRIO_NFSD_RPC                   2208
#define NETDATA_CHART_PRIO_NFSD_PROC2                 2209
#define NETDATA_CHART_PRIO_NFSD_PROC3                 2210
#define NETDATA_CHART_PRIO_NFSD_PROC4                 2211
#define NETDATA_CHART_PRIO_NFSD_PROC4OPS              2212

// NFS (client)

#define NETDATA_CHART_PRIO_NFS_NET                    2307
#define NETDATA_CHART_PRIO_NFS_RPC                    2308
#define NETDATA_CHART_PRIO_NFS_PROC2                  2309
#define NETDATA_CHART_PRIO_NFS_PROC3                  2310
#define NETDATA_CHART_PRIO_NFS_PROC4                  2311

// BTRFS

#define NETDATA_CHART_PRIO_BTRFS_DISK                 2400
#define NETDATA_CHART_PRIO_BTRFS_DATA                 2401
#define NETDATA_CHART_PRIO_BTRFS_METADATA             2402
#define NETDATA_CHART_PRIO_BTRFS_SYSTEM               2403
#define NETDATA_CHART_PRIO_BTRFS_COMMITS              2404
#define NETDATA_CHART_PRIO_BTRFS_COMMITS_PERC_TIME    2405
#define NETDATA_CHART_PRIO_BTRFS_COMMIT_TIMINGS       2406
#define NETDATA_CHART_PRIO_BTRFS_ERRORS               2407

// ZFS

#define NETDATA_CHART_PRIO_ZFS_ARC_SIZE               2500
#define NETDATA_CHART_PRIO_ZFS_L2_SIZE                2500
#define NETDATA_CHART_PRIO_ZFS_READS                  2510
#define NETDATA_CHART_PRIO_ZFS_ACTUAL_HITS            2519
#define NETDATA_CHART_PRIO_ZFS_ARC_SIZE_BREAKDOWN     2520
#define NETDATA_CHART_PRIO_ZFS_IMPORTANT_OPS          2522
#define NETDATA_CHART_PRIO_ZFS_MEMORY_OPS             2523
#define NETDATA_CHART_PRIO_ZFS_IO                     2700
#define NETDATA_CHART_PRIO_ZFS_HITS                   2520
#define NETDATA_CHART_PRIO_ZFS_DHITS                  2530
#define NETDATA_CHART_PRIO_ZFS_DEMAND_DATA_HITS       2540
#define NETDATA_CHART_PRIO_ZFS_PREFETCH_DATA_HITS     2550
#define NETDATA_CHART_PRIO_ZFS_PHITS                  2560
#define NETDATA_CHART_PRIO_ZFS_MHITS                  2570
#define NETDATA_CHART_PRIO_ZFS_L2HITS                 2580
#define NETDATA_CHART_PRIO_ZFS_LIST_HITS              2600
#define NETDATA_CHART_PRIO_ZFS_HASH_ELEMENTS          2800
#define NETDATA_CHART_PRIO_ZFS_HASH_CHAINS            2810

#define NETDATA_CHART_PRIO_ZFS_POOL_STATE             2820

// HARDIRQS

#define NETDATA_CHART_PRIO_HARDIRQ_LATENCY            2900

// SOFTIRQs

#define NETDATA_CHART_PRIO_SOFTIRQS_PER_CORE          3000 // +1 per core

// IPFW (freebsd)

#define NETDATA_CHART_PRIO_IPFW_PACKETS               3001
#define NETDATA_CHART_PRIO_IPFW_BYTES                 3002
#define NETDATA_CHART_PRIO_IPFW_ACTIVE                3003
#define NETDATA_CHART_PRIO_IPFW_EXPIRED               3004
#define NETDATA_CHART_PRIO_IPFW_MEM                   3005


// IPVS

#define NETDATA_CHART_PRIO_IPVS_NET                   3100
#define NETDATA_CHART_PRIO_IPVS_SOCKETS               3101
#define NETDATA_CHART_PRIO_IPVS_PACKETS               3102

// Softnet

#define NETDATA_CHART_PRIO_SOFTNET_PER_CORE           4101 // +1 per core

// IP STACK

#define NETDATA_CHART_PRIO_IP_TCP_PACKETS             4200
#define NETDATA_CHART_PRIO_IP_TCP_ERRORS              4210
#define NETDATA_CHART_PRIO_IP_TCP_ESTABLISHED_CONNS   4220
#define NETDATA_CHART_PRIO_IP_TCP_OPENS               4220
#define NETDATA_CHART_PRIO_IP_TCP_HANDSHAKE           4230
#define NETDATA_CHART_PRIO_IP_TCP_CONNABORTS          4240
#define NETDATA_CHART_PRIO_IP_TCP_SYN_QUEUE           4250
#define NETDATA_CHART_PRIO_IP_TCP_ACCEPT_QUEUE        4260
#define NETDATA_CHART_PRIO_IP_TCP_REORDERS            4270
#define NETDATA_CHART_PRIO_IP_TCP_OFO                 4280
#define NETDATA_CHART_PRIO_IP_TCP_SYNCOOKIES          4290
#define NETDATA_CHART_PRIO_IP_TCP_MEM_PRESSURE        4300
#define NETDATA_CHART_PRIO_IP_SOCKETS                 4310

// IPv4

#define NETDATA_CHART_PRIO_IPV4_PACKETS               5000
#define NETDATA_CHART_PRIO_IPV4_ERRORS                5050
#define NETDATA_CHART_PRIO_IPV4_BCAST                 5100
#define NETDATA_CHART_PRIO_IPV4_BCAST_PACKETS         5105
#define NETDATA_CHART_PRIO_IPV4_MCAST                 5150
#define NETDATA_CHART_PRIO_IPV4_MCAST_PACKETS         5155
#define NETDATA_CHART_PRIO_IPV4_TCP_PACKETS           5170
#define NETDATA_CHART_PRIO_IPV4_TCP_SOCKETS           5180
#define NETDATA_CHART_PRIO_IPV4_TCP_SOCKETS_MEM       5185
#define NETDATA_CHART_PRIO_IPV4_ICMP_PACKETS          5200
#define NETDATA_CHART_PRIO_IPV4_ICMP_MESSAGES         5205
#define NETDATA_CHART_PRIO_IPV4_ICMP_ERRORS           5210
#define NETDATA_CHART_PRIO_IPV4_UDP_PACKETS           5250
#define NETDATA_CHART_PRIO_IPV4_UDP_ERRORS            5255
#define NETDATA_CHART_PRIO_IPV4_UDP_SOCKETS           5260
#define NETDATA_CHART_PRIO_IPV4_UDP_SOCKETS_MEM       5265
#define NETDATA_CHART_PRIO_IPV4_UDPLITE_PACKETS       5300
#define NETDATA_CHART_PRIO_IPV4_UDPLITE_ERRORS        5305
#define NETDATA_CHART_PRIO_IPV4_UDPLITE_SOCKETS       5310
#define NETDATA_CHART_PRIO_IPV4_ECN                   5350
#define NETDATA_CHART_PRIO_IPV4_FRAGMENTS_IN          5400
#define NETDATA_CHART_PRIO_IPV4_FRAGMENTS_OUT         5405
#define NETDATA_CHART_PRIO_IPV4_FRAGMENTS_SOCKETS     5410
#define NETDATA_CHART_PRIO_IPV4_FRAGMENTS_SOCKETS_MEM 5415
#define NETDATA_CHART_PRIO_IPV4_RAW                   5450

// IPv6
#define NETDATA_CHART_PRIO_IPV6_PACKETS               6000
#define NETDATA_CHART_PRIO_IPV6_ERRORS                6005
#define NETDATA_CHART_PRIO_IPV6_BCAST                 6050
#define NETDATA_CHART_PRIO_IPV6_MCAST                 6100
#define NETDATA_CHART_PRIO_IPV6_MCAST_PACKETS         6105
#define NETDATA_CHART_PRIO_IPV6_TCP_PACKETS           6130
#define NETDATA_CHART_PRIO_IPV6_TCP_SOCKETS           6140
#define NETDATA_CHART_PRIO_IPV6_ICMP_PACKETS          6145
#define NETDATA_CHART_PRIO_IPV6_ICMP_MESSAGES         6146
#define NETDATA_CHART_PRIO_IPV6_ICMP                  6150
#define NETDATA_CHART_PRIO_IPV6_ICMP_REDIR            6155
#define NETDATA_CHART_PRIO_IPV6_ICMP_ERRORS           6160
#define NETDATA_CHART_PRIO_IPV6_ICMP_ECHOS            6165
#define NETDATA_CHART_PRIO_IPV6_ICMP_GROUPMEMB        6170
#define NETDATA_CHART_PRIO_IPV6_ICMP_ROUTER           6180
#define NETDATA_CHART_PRIO_IPV6_ICMP_NEIGHBOR         6185
#define NETDATA_CHART_PRIO_IPV6_ICMP_LDV2             6190
#define NETDATA_CHART_PRIO_IPV6_ICMP_TYPES            6195
#define NETDATA_CHART_PRIO_IPV6_UDP                   6200
#define NETDATA_CHART_PRIO_IPV6_UDP_PACKETS           6205
#define NETDATA_CHART_PRIO_IPV6_UDP_ERRORS            6210
#define NETDATA_CHART_PRIO_IPV6_UDP_SOCKETS           6215
#define NETDATA_CHART_PRIO_IPV6_UDPLITE               6250
#define NETDATA_CHART_PRIO_IPV6_UDPLITE_PACKETS       6255
#define NETDATA_CHART_PRIO_IPV6_UDPLITE_ERRORS        6260
#define NETDATA_CHART_PRIO_IPV6_UDPLITE_SOCKETS       6265
#define NETDATA_CHART_PRIO_IPV6_ECT                   6300
#define NETDATA_CHART_PRIO_IPV6_FRAGSIN               6350
#define NETDATA_CHART_PRIO_IPV6_FRAGSOUT              6355
#define NETDATA_CHART_PRIO_IPV6_FRAGMENTS_SOCKETS     6360
#define NETDATA_CHART_PRIO_IPV6_RAW_SOCKETS           6400

// Network interfaces

#define NETDATA_CHART_PRIO_FIRST_NET_IFACE            7000 // 6 charts per interface
#define NETDATA_CHART_PRIO_FIRST_NET_PACKETS          7001
#define NETDATA_CHART_PRIO_FIRST_NET_ERRORS           7002
#define NETDATA_CHART_PRIO_FIRST_NET_DROPS            7003
#define NETDATA_CHART_PRIO_FIRST_NET_EVENTS           7006
#define NETDATA_CHART_PRIO_CGROUP_NET_IFACE          43000

// SCTP

#define NETDATA_CHART_PRIO_SCTP                       7000

// QoS

#define NETDATA_CHART_PRIO_TC_QOS                     7000
#define NETDATA_CHART_PRIO_TC_QOS_PACKETS             7010
#define NETDATA_CHART_PRIO_TC_QOS_DROPPED             7020
#define NETDATA_CHART_PRIO_TC_QOS_TOKENS              7030
#define NETDATA_CHART_PRIO_TC_QOS_CTOKENS             7040

// Infiniband
#define NETDATA_CHART_PRIO_INFINIBAND                 7100

// Netfilter

#define NETDATA_CHART_PRIO_NETFILTER_SOCKETS          8700
#define NETDATA_CHART_PRIO_NETFILTER_NEW              8701
#define NETDATA_CHART_PRIO_NETFILTER_CHANGES          8702
#define NETDATA_CHART_PRIO_NETFILTER_EXPECT           8703
#define NETDATA_CHART_PRIO_NETFILTER_ERRORS           8705
#define NETDATA_CHART_PRIO_NETFILTER_SEARCH           8710

// SYNPROXY

#define NETDATA_CHART_PRIO_SYNPROXY_SYN_RECEIVED      8751
#define NETDATA_CHART_PRIO_SYNPROXY_COOKIES           8752
#define NETDATA_CHART_PRIO_SYNPROXY_CONN_OPEN         8753
#define NETDATA_CHART_PRIO_SYNPROXY_ENTRIES           8754

// Linux Power Supply

#define NETDATA_CHART_PRIO_POWER_SUPPLY_CAPACITY      9500 // 5 charts per power supply
#define NETDATA_CHART_PRIO_POWER_SUPPLY_POWER         9501
#define NETDATA_CHART_PRIO_POWER_SUPPLY_CHARGE        9502
#define NETDATA_CHART_PRIO_POWER_SUPPLY_ENERGY        9503
#define NETDATA_CHART_PRIO_POWER_SUPPLY_VOLTAGE       9504

// Wireless

#define NETDATA_CHART_PRIO_WIRELESS_IFACE	          7110

// CGROUPS

#define NETDATA_CHART_PRIO_CGROUPS_SYSTEMD           19000 // many charts
#define NETDATA_CHART_PRIO_CGROUPS_CONTAINERS        40000 // many charts

// STATSD

#define NETDATA_CHART_PRIO_STATSD_PRIVATE            90000 // many charts

// Logs Management

#define NETDATA_CHART_PRIO_LOGS_BASE                 95000 // many charts

// PCI

#define NETDATA_CHART_PRIO_PCI_AER                  100000

// AMD GPUs

#define NETDATA_CHART_PRIO_DRM_AMDGPU                 39000

// NETDATA ML CHARTS

// [ml] charts
#define ML_CHART_PRIO_DIMENSIONS                      39181
#define ML_CHART_PRIO_ANOMALY_RATE                    39182
#define ML_CHART_PRIO_TYPE_ANOMALY_RATE               39183
#define ML_CHART_PRIO_DETECTOR_EVENTS                 39184

// [netdata.ml] charts
#define NETDATA_ML_CHART_RUNNING                      890001
#define NETDATA_ML_CHART_PRIO_MACHINE_LEARNING_STATUS 890002
#define NETDATA_ML_CHART_PRIO_METRIC_TYPES            890003
#define NETDATA_ML_CHART_PRIO_TRAINING_STATUS         890004

#define NETDATA_ML_CHART_PRIO_PREDICTION_USAGE        890005
#define NETDATA_ML_CHART_PRIO_TRAINING_USAGE          890006

#define NETDATA_ML_CHART_PRIO_QUEUE_STATS             890007
#define NETDATA_ML_CHART_PRIO_TRAINING_TIME_STATS     890008
#define NETDATA_ML_CHART_PRIO_TRAINING_RESULTS        890009

#define NETDATA_ML_CHART_FAMILY "machine learning"
#define NETDATA_ML_PLUGIN "ml.plugin"
#define NETDATA_ML_MODULE_TRAINING "training"
#define NETDATA_ML_MODULE_DETECTION "detection"
#define NETDATA_ML_MODULE_PREDICTION "prediction"


#endif //NETDATA_ALL_H
