# Dynamic Configuration Manager

> **Info**
>
> Netdata Cloud paid subscription is required.

The Dynamic Configuration Manager allows direct configuration of collectors and alerts through the Netdata UI. This feature allows users to:

- **Create, test, and deploy configurations** for one or more nodes directly within the UI.
- **Eliminate the need for manual command-line edits and node access**, enhancing workflow efficiency.

**Cloud Connection and Security**: Nodes using Dynamic Configuration Manager require a connection to Netdata Cloud. This ensures proper permission handling and data security.

> **Info**
>
> To understand what actions users can perform based on their role, refer to the [Role-Based Access documentation](/docs/netdata-cloud/authentication-and-authorization/role-based-access-model.md#dynamic-configuration-manager).

## Collectors

### Module

A module represents a specific data collector, such as Apache, MySQL, or Redis. Think of modules as templates for data collection.

Each module can have multiple jobs, which are unique configurations of that template tailored to your specific needs.

You can manage individual modules using the following actions:

| Action             | Description                                                                                                               |
|--------------------|---------------------------------------------------------------------------------------------------------------------------|
| **Add job**        | Create new configuration instances (jobs) for a particular module.                                                        |
| **Enable/Disable** | Disabling a module deactivates all currently running jobs and prevents any future jobs from being created for that module |

### Job

A job represents a running instance of a module with a specific configuration. Think of it as a customized data collection task based on a module template.

Every job has a designated "source type" indicating its origin:

- **Stock**: Pre-installed with Netdata and provides basic data collection for common services.
- **User**: Created from user-defined configuration files on the node.
- **Discovered**: Automatically generated by Netdata upon discovering a service running on the node.
- **Dynamic Configuration**: Managed and created through the Dynamic Configuration Manager.

You can manage individual jobs using the following actions:

| Action             | Description                                                                                                                                                                                 |
|--------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Restart**        | This restarts a job's data collection, useful if a job encounters a "Failed" state. Upon restart, a notification with the failure message will be displayed.                                |
| **Remove**         | Delete a job configuration entirely. Note that only jobs created through Dynamic Configuration can be removed. Other job types originate from files on the node and cannot be deleted here. |
| **Enable/Disable** | Control the job's activity. Disabling a running job stops data collection.                                                                                                                  |
| **Edit**           | Modify an existing job's configuration.                                                                                                                                                     |
| **Test**           | Validate newly created or edited configurations before applying them permanently.                                                                                                           |

## Health

Each entry in the Health tab contains an Alert template that then is used to create Alerts.

The functionality in the main view is the same as with the [Collectors tab](#collectors).

### Health entry configuration

You can create new configurations both for templates or individual Alerts.

Each template can have multiple items which resemble Alerts that either apply to a certain [instance](/docs/dashboards-and-charts/netdata-charts.md#instances-dropdown), or all instances under a specific [context](/docs/dashboards-and-charts/netdata-charts.md#contexts)
