<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pika/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pika/metadata.yaml"
sidebar_label: "Pika"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Pika


<img src="https://netdata.cloud/img/pika.svg" width="150"/>


Plugin: go.d.plugin
Module: pika

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Pika servers.

It collects information and statistics about the server executing the following commands:

- [`INFO ALL`](https://github.com/OpenAtomFoundation/pika/wiki/pika-info%E4%BF%A1%E6%81%AF%E8%AF%B4%E6%98%8E)




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Pika instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| pika.connections | accepted | connections |
| pika.clients | connected | clients |
| pika.memory | used | bytes |
| pika.connected_replicas | connected | replicas |
| pika.commands | processed | commands/s |
| pika.commands_calls | a dimension per command | calls/s |
| pika.database_strings_keys | a dimension per database | keys |
| pika.database_strings_expires_keys | a dimension per database | keys |
| pika.database_strings_invalid_keys | a dimension per database | keys |
| pika.database_hashes_keys | a dimension per database | keys |
| pika.database_hashes_expires_keys | a dimension per database | keys |
| pika.database_hashes_invalid_keys | a dimension per database | keys |
| pika.database_lists_keys | a dimension per database | keys |
| pika.database_lists_expires_keys | a dimension per database | keys |
| pika.database_lists_invalid_keys | a dimension per database | keys |
| pika.database_zsets_keys | a dimension per database | keys |
| pika.database_zsets_expires_keys | a dimension per database | keys |
| pika.database_zsets_invalid_keys | a dimension per database | keys |
| pika.database_sets_keys | a dimension per database | keys |
| pika.database_sets_expires_keys | a dimension per database | keys |
| pika.database_sets_invalid_keys | a dimension per database | keys |
| pika.uptime | uptime | seconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/pika.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/pika.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Pika server address. | redis://@localhost:9221 | yes |
| timeout | Dial (establishing new connections), read (socket reads) and write (socket writes) timeout in seconds. | 1 | no |
| username | Username used for authentication. |  | no |
| password | Password used for authentication. |  | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certificate authority that client use when verifying server certificates. |  | no |
| tls_cert | Client tls certificate. |  | no |
| tls_key | Client tls key. |  | no |

</details>

#### Examples

##### TCP socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://@localhost:9221'

```
</details>

##### TCP socket with password

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://:password@127.0.0.1:9221'

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://:password@127.0.0.1:9221'

  - name: remote
    address: 'redis://user:password@203.0.113.0:9221'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `pika` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m pika
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m pika -j jobName
  ```

### Getting Logs

If you're encountering problems with the `pika` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep pika
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep pika /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep pika
```


