/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.Address32;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class ELF32FileReader
extends ELFFileReader {
    public ELF32FileReader(File f, ByteOrder byteOrder, long offset) throws FileNotFoundException, IOException, InvalidDumpFormatException {
        super(f, byteOrder, offset);
    }

    public ELF32FileReader(ImageInputStream in, long offset) throws IOException, InvalidDumpFormatException {
        super(in, offset);
    }

    public boolean validDump(byte[] data, long filesize) {
        return 127 == data[0] && 69 == data[1] && 76 == data[2] && 70 == data[3] && 1 == data[4];
    }

    @Override
    protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
        int type2 = this.is.readInt();
        long fileOffset = this.unsigned(this.is.readInt());
        long virtualAddress = this.unsigned(this.is.readInt());
        long physicalAddress = this.unsigned(this.is.readInt());
        long fileSize = this.unsigned(this.is.readInt());
        long memorySize = this.unsigned(this.is.readInt());
        int flags = this.is.readInt();
        long alignment = this.unsigned(this.is.readInt());
        return new ProgramHeaderEntry(type2, fileOffset, fileSize, virtualAddress, physicalAddress, memorySize, flags, alignment, this);
    }

    private long unsigned(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    @Override
    protected long padToWordBoundary(long l) {
        return (l + 3L) / 4L * 4L;
    }

    @Override
    protected long readElfWord() throws IOException {
        return (long)this.is.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected Address readElfWordAsAddress() throws IOException {
        return new Address32(this.is.readInt());
    }

    @Override
    protected int addressSizeBits() {
        return 32;
    }

    @Override
    protected List<ELFSymbol> readSymbolsAt(SectionHeaderEntry entry) throws IOException {
        if (0L != entry.size % 16L) {
            return Collections.emptyList();
        }
        this.seek(entry.offset);
        long count = entry.size / 16L;
        count = Math.min(Math.abs(count), 8096L);
        ArrayList<ELFSymbol> symbols = new ArrayList<ELFSymbol>((int)count);
        for (long i = 0L; i < count; ++i) {
            long name = (long)this.is.readInt() & 0xFFFFFFFFL;
            long value = (long)this.is.readInt() & 0xFFFFFFFFL;
            long size = (long)this.is.readInt() & 0xFFFFFFFFL;
            byte info = this.is.readByte();
            byte other = this.is.readByte();
            int sectionIndex = this.is.readShort() & 0xFFFF;
            symbols.add(new ELFSymbol(name, value, size, info, other, sectionIndex));
        }
        return symbols;
    }
}

