/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindInfo;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class UnwindModule
extends Module {
    private List<RuntimeFunction> runtimeFunctionEntries;

    public UnwindModule(IProcess process, String name, List<? extends ISymbol> symbols, Collection<? extends IMemoryRange> memoryRanges, long loadAddress, Properties properties) {
        super(process, name, symbols, memoryRanges, loadAddress, properties);
    }

    public UnwindModule(IProcess process, String name, List<? extends ISymbol> symbols, Collection<? extends IMemoryRange> memoryRanges, long loadAddress, Properties properties, List<RuntimeFunction> runtimeFunctionEntries) {
        super(process, name, symbols, memoryRanges, loadAddress, properties);
        this.runtimeFunctionEntries = runtimeFunctionEntries;
        Collections.sort(runtimeFunctionEntries);
    }

    public RuntimeFunction getUnwindDataForAddress(long address) throws MemoryFault {
        RuntimeFunction data = null;
        for (RuntimeFunction entry : this.runtimeFunctionEntries) {
            if (!entry.contains(address)) continue;
            data = entry;
            while (data.getUnwindInfoAddress() % 2L != 0L) {
                int start = this.process.getIntAt(--address + this.getLoadAddress());
                int end = this.process.getIntAt(address + this.getLoadAddress() + 4L);
                int unwindAddress = this.process.getIntAt(address + this.getLoadAddress() + 4L);
                data = new RuntimeFunction(start, end, unwindAddress);
            }
            break block0;
        }
        return data;
    }

    public void dumpUndwindInfo(PrintStream output) {
        if (this.runtimeFunctionEntries == null) {
            output.println("No undwind info available for module " + this.getName());
        }
        output.println("Dumping unwind info for: " + this.getName());
        try {
            for (RuntimeFunction rf : this.runtimeFunctionEntries) {
                output.println(String.format("Found ImageRuntimeFunctionEntry %s", rf));
                if (rf.getUnwindInfoAddress() % 2L != 0L) continue;
                UnwindInfo info = new UnwindInfo(this.process.getAddressSpace(), this, rf.getUnwindInfoAddress());
                output.println(info);
                output.println();
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace(output);
        }
    }
}

