/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.AbstractHashMap;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;
import java.util.HashMap;
import java.util.Random;

public final class IntegerMap
extends AbstractHashMap {
    long[] values = new long[17];
    private boolean doCheck = true;

    @Override
    Object getValuesArray() {
        return this.values;
    }

    @Override
    void allocNewValuesArray(int newSize) {
        this.values = new long[newSize];
    }

    @Override
    void put(long key, Object oldvalues, int offset) {
        long[] v = (long[])oldvalues;
        this.put(key, v[offset]);
    }

    public synchronized long get(long key) {
        int index = this.getIndex(key);
        return index == -1 ? -1L : this.values[index];
    }

    public synchronized void put(long key, long value) {
        this.values[this.putIndex((long)key)] = value;
        this.checkRehash();
    }

    public synchronized long remove(long key) {
        int index = this.removeIndex(key);
        return index == -1 ? -1L : this.values[index];
    }

    public int memoryUsage() {
        return this.tableSize * 17;
    }

    private void test() {
        Random rand = new Random(23L);
        HashMap<Long, Long> check = new HashMap<Long, Long>();
        for (int i = 0; i < 500000; ++i) {
            boolean remove;
            long key = rand.nextLong();
            long value = rand.nextLong();
            boolean bl = remove = i % 3 == 0;
            if (this.get(key) != -1L) continue;
            this.put(key, value);
            if (!this.doCheck) continue;
            check.put(new Long(key), new Long(value));
            if (this.get(key) != value) {
                throw new Error("found " + this.get(key) + " expected " + value);
            }
            if (!remove) continue;
            this.remove(key);
            check.remove(new Long(key));
        }
        if (this.doCheck) {
            Long[] keys = check.keySet().toArray(new Long[0]);
            for (int i = 0; i < keys.length; ++i) {
                long key = keys[i];
                long value = (Long)check.get(keys[i]);
                if (this.get(key) == value) continue;
                throw new Error("at " + i + " found " + this.get(key) + " expected " + value + " key " + key);
            }
        }
    }

    public static void main(String[] args) {
        IntegerMap map = new IntegerMap();
        map.test();
        IntEnumeration e = map.getKeys();
        while (e.hasMoreElements()) {
            long key = e.nextInt();
            if (map.get(key) != -1L) continue;
            throw new Error("uh oh");
        }
        System.out.println("finished!");
    }
}

