/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class J9ConfigFlags {
    public static final boolean arch_arm;
    public static final boolean arch_aarch64;
    public static final boolean arch_power;
    public static final boolean arch_riscv;
    public static final boolean arch_s390;
    public static final boolean arch_x86;

    private static boolean getFlag(Class<?> flagsClass, String ... fieldNames) {
        Boolean value = null;
        for (String fieldName : fieldNames) {
            try {
                Field field = flagsClass.getField(fieldName);
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field.getType() != Boolean.TYPE) continue;
                if (value != null) {
                    throw new InternalError("ambiguous flag");
                }
                value = field.getBoolean(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new InternalError("unexpected exception", e);
            }
            catch (NoSuchFieldException e) {
            }
            catch (SecurityException e) {
                throw new InternalError("unexpected exception", e);
            }
        }
        if (value == null) {
            throw new InternalError("missing flag");
        }
        return value;
    }

    static {
        Class<J9BuildFlags> flagsClass = J9BuildFlags.class;
        arch_arm = J9ConfigFlags.getFlag(flagsClass, "arch_arm", "J9VM_ARCH_ARM");
        arch_aarch64 = J9ConfigFlags.getFlag(flagsClass, "arch_aarch64", "J9VM_ARCH_AARCH64");
        arch_power = J9ConfigFlags.getFlag(flagsClass, "arch_power", "J9VM_ARCH_POWER");
        arch_riscv = J9ConfigFlags.getFlag(flagsClass, "arch_riscv", "J9VM_ARCH_RISCV");
        arch_s390 = J9ConfigFlags.getFlag(flagsClass, "arch_s390", "J9VM_ARCH_S390");
        arch_x86 = J9ConfigFlags.getFlag(flagsClass, "arch_x86", "J9VM_ARCH_X86");
    }
}

