/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.VerificationTypeInfoPointer;
import com.ibm.j9ddr.vm29.structure.StackMapFrame;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=StackMapFrame.class)
public class StackMapFramePointer
extends StructurePointer {
    public static final StackMapFramePointer NULL = new StackMapFramePointer(0L);

    protected StackMapFramePointer(long address) {
        super(address);
    }

    public static StackMapFramePointer cast(AbstractPointer structure) {
        return StackMapFramePointer.cast(structure.getAddress());
    }

    public static StackMapFramePointer cast(UDATA udata) {
        return StackMapFramePointer.cast(udata.longValue());
    }

    public static StackMapFramePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new StackMapFramePointer(address);
    }

    @Override
    public StackMapFramePointer add(long count) {
        return StackMapFramePointer.cast(this.address + StackMapFrame.SIZEOF * count);
    }

    @Override
    public StackMapFramePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public StackMapFramePointer addOffset(long offset) {
        return StackMapFramePointer.cast(this.address + offset);
    }

    @Override
    public StackMapFramePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public StackMapFramePointer sub(long count) {
        return StackMapFramePointer.cast(this.address - StackMapFrame.SIZEOF * count);
    }

    @Override
    public StackMapFramePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public StackMapFramePointer subOffset(long offset) {
        return StackMapFramePointer.cast(this.address - offset);
    }

    @Override
    public StackMapFramePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public StackMapFramePointer untag(long mask) {
        return StackMapFramePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public StackMapFramePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return StackMapFrame.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_bciOffset_", declaredType="U16")
    public U16 bci() throws CorruptDataException {
        return new U16(this.getShortAtOffset(StackMapFrame._bciOffset_));
    }

    public U16Pointer bciEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)StackMapFrame._bciOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_entriesOffset_", declaredType="VerificationTypeInfo*")
    public VerificationTypeInfoPointer entries() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(StackMapFrame._entriesOffset_);
        return VerificationTypeInfoPointer.cast(pointer);
    }

    public PointerPointer entriesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)StackMapFrame._entriesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_frameTypeOffset_", declaredType="U8")
    public U8 frameType() throws CorruptDataException {
        return new U8(this.getByteAtOffset(StackMapFrame._frameTypeOffset_));
    }

    public U8Pointer frameTypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)StackMapFrame._frameTypeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfLocalsOffset_", declaredType="U16")
    public U16 numberOfLocals() throws CorruptDataException {
        return new U16(this.getShortAtOffset(StackMapFrame._numberOfLocalsOffset_));
    }

    public U16Pointer numberOfLocalsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)StackMapFrame._numberOfLocalsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfSlotsOffset_", declaredType="UDATA")
    public UDATA numberOfSlots() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(StackMapFrame._numberOfSlotsOffset_));
    }

    public UDATAPointer numberOfSlotsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)StackMapFrame._numberOfSlotsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_numberOfStackOffset_", declaredType="U16")
    public U16 numberOfStack() throws CorruptDataException {
        return new U16(this.getShortAtOffset(StackMapFrame._numberOfStackOffset_));
    }

    public U16Pointer numberOfStackEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)StackMapFrame._numberOfStackOffset_);
    }
}

