/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedCacheHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassSummaryHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class RomClassSummaryCommand
extends Command {
    private final String[] preferredOrder = new String[]{"romHeader", "constantPool", "fields", "interfacesSRPs", "innerClassesSRPs", "cpNamesAndSignaturesSRPs", "methods", "cpShapeDescription", "classAnnotations", "enclosingObject", "optionalInfo", "UTF8"};

    public RomClassSummaryCommand() {
        this.addCommand("romclasssummary", "[local|shared] [nas]", "Display romclass summary");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            boolean requiredLocal = false;
            boolean requiredShared = false;
            boolean required16bitnas = false;
            J9SharedClassConfigPointer sc = J9SharedClassConfigPointer.NULL;
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            long startAddress = 0L;
            long endAddress = 0L;
            if (args != null && args.length >= 1) {
                if (args[0].equals("shared")) {
                    requiredShared = true;
                } else if (args[0].equals("local")) {
                    requiredLocal = true;
                } else if (args[0].equals("16bitnas")) {
                    required16bitnas = true;
                } else {
                    out.println("USAGE: !romclasssummary [local|shared] [16bitnas]");
                    return;
                }
                if (args.length >= 2 && args[1].equals("16bitnas")) {
                    required16bitnas = true;
                }
                if (requiredShared || requiredLocal) {
                    sc = vm.sharedClassConfig();
                    if (requiredShared && sc.isNull()) {
                        out.println("The request for '" + args[0] + " classes' failed, because shared classes were not enabled on that dump file.");
                        return;
                    }
                    if (sc.notNull()) {
                        startAddress = UDATA.cast(sc.cacheDescriptorList().romclassStartAddress()).longValue();
                        J9SharedCacheHeaderPointer header = sc.cacheDescriptorList().cacheStartAddress();
                        endAddress = UDATA.cast(header).add(header.segmentSRP()).longValue();
                    }
                }
            }
            ClassSummaryHelper classSummaryHelper = new ClassSummaryHelper(this.preferredOrder);
            Statistics statistics = new Statistics();
            ROMClassesIterator classSegmentIterator = new ROMClassesIterator(out, vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ROMClassPointer classPointer = classSegmentIterator.next();
                if (requiredShared || requiredLocal) {
                    long classAddress;
                    boolean isShared = sc.notNull() ? (classAddress = classPointer.getAddress()) >= startAddress && classAddress < endAddress : false;
                    if (requiredShared && !isShared || requiredLocal && isShared) continue;
                }
                RomClassWalker classWalker = new RomClassWalker(classPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode allRegionsNode = linearDumper.getAllRegions(classWalker);
                classSummaryHelper.addRegionsForClass(allRegionsNode);
                if (!required16bitnas) continue;
                statistics.add(allRegionsNode);
            }
            classSummaryHelper.printStatistics(out);
            if (statistics.nameAndSignatureSRP16bitSize != -1L) {
                out.println();
                out.println("<Total 16bit nameAndSignatureSRPs Size>");
                out.println(statistics.nameAndSignatureSRP16bitSize);
            }
            if (statistics.nameAndSignatureSRPCount != -1L && statistics.cpFieldNASCount != -1L) {
                out.println();
                out.println("<Shared nameAndSignatureSRPs>");
                out.println(statistics.cpFieldNASCount - statistics.nameAndSignatureSRPCount / 2L);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private class Statistics {
        public long nameAndSignatureSRP16bitSize = -1L;
        public long nameAndSignatureSRPCount = -1L;
        public long cpFieldNASCount = -1L;

        private Statistics() {
        }

        void add(LinearDumper.J9ClassRegionNode allRegionsNode) throws CorruptDataException {
            this.addRecursive(allRegionsNode, null);
        }

        void addRecursive(LinearDumper.J9ClassRegionNode allRegionsNode, String parent) throws CorruptDataException {
            LinearDumper.J9ClassRegion nodeValue = allRegionsNode.getNodeValue();
            String name = null;
            if (nodeValue != null) {
                long srpValue;
                name = nodeValue.getName();
                if (parent != null && parent.equals("cpNamesAndSignaturesSRPs") && (long)((short)(srpValue = I32Pointer.cast(nodeValue.getSlotPtr()).at(0L).longValue())) == srpValue) {
                    ++this.nameAndSignatureSRPCount;
                    this.nameAndSignatureSRP16bitSize += nodeValue.getLength();
                }
                if (name.equals("cpFieldNAS")) {
                    ++this.cpFieldNASCount;
                }
            }
            for (LinearDumper.J9ClassRegionNode classRegionNode : allRegionsNode.getChildren()) {
                if (name != null && parent != null && !name.trim().equals("constantPool") && !parent.trim().equals("constantPool") && !name.trim().equals("cpNamesAndSignaturesSRPs")) continue;
                this.addRecursive(classRegionNode, name);
            }
        }
    }
}

