/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

class AIX64DumpReader
extends AIXDumpReader {
    private static final long THRDENTRY64_V1_SIZE = 424L;
    private static final long THRDENTRY64_V2_SIZE = 512L;
    private static final long THRDCTX64_V1 = 1000L;
    private static final long THRDCTX64_V2 = 1088L;
    private static final int GPR_COUNT = 32;
    private static final String VMID = "j9vmap64";
    private boolean hasVersionBeenDetermined = false;
    private long sizeofThreadCtx64 = 1000L;
    private long sizeofThreadEntry64 = 424L;

    public AIX64DumpReader(File file, ClosingFileReader closingFileReader) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        this.setReader(closingFileReader);
        this.readCore();
    }

    public AIX64DumpReader(ImageInputStream imageInputStream) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = null;
        this.setReader(imageInputStream);
        this.readCore();
    }

    public String getVMID() {
        return VMID;
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return this._fileReader.readInt();
    }

    @Override
    protected long userInfoOffset() {
        return 1216L;
    }

    @Override
    public boolean is64Bit() {
        return true;
    }

    @Override
    protected Map<String, Number> readRegisters(long l) throws IOException {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(l);
        }
        this._fileReader.seek(l + this.sizeofThreadEntry64);
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
        for (int i = 0; i < 32; ++i) {
            treeMap.put("gpr" + i, this.readLong());
        }
        treeMap.put("msr", this.readLong());
        treeMap.put("iar", this.readLong());
        treeMap.put("lr", this.readLong());
        treeMap.put("ctr", this.readLong());
        treeMap.put("cr", this.readInt());
        treeMap.put("xer", this.readInt());
        treeMap.put("fpscr", this.readInt());
        return treeMap;
    }

    public void calculateThreadStructureSizes(long l) {
        long l2;
        try {
            this._fileReader.seek(l + 424L + 8L);
            l2 = this.readLong();
        }
        catch (IOException iOException) {
            return;
        }
        if (null == this.getProcess().getMemoryRangeForAddress(l2)) {
            this.sizeofThreadEntry64 = 512L;
            this.sizeofThreadCtx64 = 1088L;
        } else {
            this.sizeofThreadEntry64 = 424L;
            this.sizeofThreadCtx64 = 1000L;
        }
        this.hasVersionBeenDetermined = true;
    }

    @Override
    protected long threadSize(long l) {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(l);
        }
        return this.sizeofThreadCtx64;
    }

    @Override
    protected long getStackPointerFrom(Map<String, Number> map) {
        return (Long)map.get("gpr1");
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return (Long)map.get("iar");
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return (Long)map.get("lr");
    }

    @Override
    protected int sizeofTopOfStack() {
        return 304;
    }

    @Override
    protected int pointerSize() {
        return 64;
    }

    @Override
    protected long readAddress() throws IOException {
        return this.readLong();
    }
}

