/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.CharConversion;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntegerMap;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectLruCache;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Template;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressSpace
implements Serializable {
    protected Dump dump;
    protected int asid;
    protected IntegerMap addressMap = new IntegerMap();
    private int quickCacheHits;
    private int cacheHits;
    private int cacheMisses;
    private ObjectLruCache blockCache;
    protected long lastBlockAddress;
    private byte[] lastBlock;
    protected long lastButOneBlockAddress;
    private byte[] lastButOneBlock;
    protected AddressRange[] ranges;
    private boolean is64bit;
    private HashMap userMap = new HashMap();
    private long lowestAddress = -1L;
    public static final long WILD_POINTER = -4995072469322842385L;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private static final boolean printStats = Boolean.getBoolean("zebedee.printStats");

    public AddressSpace(Dump dump, int n) {
        this.dump = dump;
        this.asid = n;
        this.initialize();
    }

    public Dump getDump() {
        return this.dump;
    }

    public AddressSpace getRootAddressSpace() {
        return this.dump.rootSpace;
    }

    public long getLowestAddress() {
        if (this.lowestAddress == -1L) {
            long[] lArray = this.addressMap.getKeysArray();
            Arrays.sort(lArray);
            this.lowestAddress = lArray[0];
        }
        return this.lowestAddress;
    }

    private void initialize() {
        this.blockCache = new ObjectLruCache(500);
        this.userMap = new HashMap();
        this.lastBlockAddress = -1L;
        this.lastButOneBlockAddress = -1L;
        this.lowestAddress = -1L;
        if (printStats && this.getClass() == AddressSpace.class) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<AddressSpace> clazz = AddressSpace.class;
                    synchronized (AddressSpace.class) {
                        System.out.println("stats for asid " + AddressSpace.hex(AddressSpace.this.asid) + " in dump " + AddressSpace.this.dump.getName() + ":");
                        System.out.println("    cacheMisses = " + AddressSpace.this.cacheMisses);
                        System.out.println("    cacheHits = " + AddressSpace.this.cacheHits);
                        System.out.println("    quickCacheHits = " + AddressSpace.this.quickCacheHits);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public int getAsid() {
        return this.asid;
    }

    public AddressRange[] getAddressRanges() {
        if (this.ranges != null) {
            return this.ranges;
        }
        long[] lArray = this.addressMap.getKeysArray();
        Arrays.sort(lArray);
        long l = 0L;
        long l2 = 0L;
        Vector<AddressRange> vector = new Vector<AddressRange>();
        for (int i = 0; i < lArray.length; ++i) {
            if (i == 0) {
                l = lArray[0];
            } else if (lArray[i] != l2 + 4096L) {
                vector.add(new AddressRange(l, l2 + 4096L - l));
                l = lArray[i];
            }
            l2 = lArray[i];
        }
        vector.add(new AddressRange(l, l2 + 4096L - l));
        this.ranges = vector.toArray(new AddressRange[0]);
        return this.ranges;
    }

    public AddressRange[] getUnusedAddressRanges() {
        this.getAddressRanges();
        AddressRange[] addressRangeArray = new AddressRange[this.ranges.length - 1];
        for (int i = 0; i < addressRangeArray.length; ++i) {
            long l = this.ranges[i].getEndAddress() + 1L;
            long l2 = this.ranges[i + 1].getStartAddress() - 1L;
            addressRangeArray[i] = new AddressRange(l, l2 - l);
        }
        return addressRangeArray;
    }

    public AddressSpaceImageInputStream getImageInputStream() {
        return new AddressSpaceImageInputStream(this);
    }

    private void checkIfWild(long l) {
        assert (l != -4995072469322842385L);
        assert ((int)l != -559038737);
        assert (l < -4995072469322846481L || l > -4995072469322838289L) : AddressSpace.hex(l);
        assert ((int)l < -559042833 || (int)l > -559034641) : AddressSpace.hex((int)l);
    }

    protected long roundToPage(long l) {
        this.checkIfWild(l);
        return l & 0xFFFFFFFFFFFFF000L;
    }

    private long offset(long l) {
        long l2 = this.roundToPage(l);
        long l3 = this.addressMap.get(l2);
        if (l3 == -1L) {
            if (this.asid != 1 && (l3 = this.dump.rootSpace.addressMap.get(l2)) != -1L) {
                log.fine("found address " + AddressSpace.hex(l) + " in root address space");
            }
            if (l3 == -1L && this.asid != -910042680 && this.dump.highVirtualSharedSpace != null && (l3 = this.dump.highVirtualSharedSpace.addressMap.get(l2)) != -1L) {
                log.fine("found address " + AddressSpace.hex(l) + " in high virtual shared address space");
            }
            if (l3 == -1L) {
                log.fine("block address " + AddressSpace.hex(l) + " not in dump");
            }
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(long l, byte[] byArray) throws IOException {
        assert (byArray.length <= 4096) : byArray.length;
        long l2 = this.offset(l);
        if (l2 == -1L) {
            throw new IOException("block address " + AddressSpace.hex(l) + " not in dump");
        }
        Dump dump = this.dump;
        synchronized (dump) {
            this.dump.seek(l2);
            this.dump.readFully(byArray);
        }
    }

    public boolean isValidAddress(long l) {
        try {
            return this.offset(l) != -1L;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    final synchronized byte[] getBlockFromQuickCache(long l) {
        if (l == this.lastBlockAddress) {
            return this.lastBlock;
        }
        if (l == this.lastButOneBlockAddress) {
            return this.lastButOneBlock;
        }
        return null;
    }

    final synchronized void putBlockInQuickCache(long l, byte[] byArray) {
        assert ((l & 0xFFFL) == 0L);
        this.lastButOneBlockAddress = this.lastBlockAddress;
        this.lastButOneBlock = this.lastBlock;
        this.lastBlockAddress = l;
        this.lastBlock = byArray;
    }

    public final byte[] getBlock(long l) throws IOException {
        byte[] byArray = this.getBlockFromQuickCache(l = this.roundToPage(l));
        return byArray != null ? byArray : this.getBlockFromCacheOrDisk(l);
    }

    protected byte[] getBlockFromCacheOrDisk(long l) throws IOException {
        byte[] byArray = (byte[])this.blockCache.get(l);
        if (byArray == null) {
            byArray = new byte[4096];
            this.read(l, byArray);
            this.blockCache.put(l, byArray);
        }
        this.putBlockInQuickCache(l, byArray);
        return byArray;
    }

    public int read(long l) throws IOException {
        return this.getBlock(l)[(int)l & 0xFFF] & 0xFF;
    }

    public int readInt(long l) throws IOException {
        int n = (int)l & 0xFFF;
        try {
            if (n <= 4092) {
                return Dump.readInt(this.getBlock(l), n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("address " + AddressSpace.hex(l) + " not in dump");
        }
        int n2 = this.read(l++);
        int n3 = this.read(l++);
        int n4 = this.read(l++);
        int n5 = this.read(l++);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public int readUnsignedByte(long l) throws IOException {
        return this.read(l);
    }

    public byte readByte(long l) throws IOException {
        return (byte)this.readUnsignedByte(l);
    }

    public int readUnsignedShort(long l) throws IOException {
        int n = this.read(l);
        int n2 = this.read(l + 1L);
        return n << 8 | n2;
    }

    public short readShort(long l) throws IOException {
        return (short)this.readUnsignedShort(l);
    }

    public long readUnsignedInt(long l) throws IOException {
        long l2 = this.readInt(l);
        return l2 & 0xFFFFFFFFL;
    }

    public long readLong(long l) throws IOException {
        int n = (int)l & 0xFFF;
        try {
            if (n <= 4088) {
                return Dump.readLong(this.getBlock(l), n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("address " + AddressSpace.hex(l) + " not in dump");
        }
        long l2 = this.readInt(l);
        long l3 = this.readInt(l + 4L);
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    public long readWord(long l) throws IOException {
        return this.is64bit ? this.readLong(l) : (long)this.readInt(l) & 0xFFFFFFFFL;
    }

    public long readWord(long l, boolean bl) throws IOException {
        return bl ? this.readLong(l) : (long)this.readInt(l) & 0xFFFFFFFFL;
    }

    public int getWordLength() {
        return this.is64bit ? 8 : 4;
    }

    public void read(long l, byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            int n3;
            byte[] byArray2;
            int n4;
            if (n2 <= (n4 = (byArray2 = this.getBlock(l)).length - (n3 = (int)(l & Integer.MAX_VALUE) % byArray2.length))) {
                System.arraycopy(byArray2, n3, byArray, n, n2);
                return;
            }
            System.arraycopy(byArray2, n3, byArray, n, n4);
            l += (long)n4;
            n += n4;
            n2 -= n4;
        }
    }

    public String readEbcdicString(long l, int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(l, byArray, 0, n);
        return CharConversion.getEbcdicString(byArray);
    }

    public String readEbcdicString(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readEbcdicString(l + 2L, n);
    }

    public String readEbcdicCString(long l) throws IOException {
        int n = 0;
        long l2 = l;
        while (this.read(l2) != 0) {
            ++l2;
            ++n;
        }
        return this.readEbcdicString(l, n);
    }

    public String readAsciiString(long l, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.read(l++));
        }
        return stringBuffer.toString();
    }

    public String readAsciiCString(long l) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read(l++)) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String readAsciiString(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readAsciiString(l + 2L, n);
    }

    public String readUtf8String(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readAsciiString(l + 2L, n);
    }

    public long readLong(long l, Template template, String string) throws NoSuchFieldException, IOException {
        return template.getField(string).readLong(this.getImageInputStream(), l);
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public void setIs64bit(boolean bl) {
        log.fine("Set address space " + this.asid + " as " + (bl ? "64-bit" : "32-bit"));
        this.is64bit = bl;
    }

    void mapAddressToFileOffset(long l, long l2) {
        if (this.addressMap.get(l) != -1L) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("duplicate address 0x" + AddressSpace.hex(l) + " for asid " + this.asid);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("mapping address 0x" + AddressSpace.hex(l) + " to offset " + AddressSpace.hex(l2) + " for asid " + this.asid);
        }
        this.addressMap.put(l, l2);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    public String toString() {
        return AddressSpace.hex(this.asid);
    }

    void setDump(Dump dump) {
        this.dump = dump;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.asid);
        objectOutputStream.writeObject(this.addressMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.asid = objectInputStream.readInt();
        this.addressMap = (IntegerMap)objectInputStream.readObject();
        this.initialize();
    }

    public boolean equals(Object object) {
        AddressSpace addressSpace = (AddressSpace)object;
        return addressSpace.asid == this.asid && addressSpace.dump.equals(this.dump);
    }

    public int hashCode() {
        return this.asid * this.dump.hashCode();
    }
}

