/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;

public class SnapFormatWrapperCommand
extends Command {
    public SnapFormatWrapperCommand() {
        this.addCommand("snapformat", "[<filename>]", "format trace buffers to a specified file or stdout");
        this.addCommand("snapformat", "-help", "print detailed help");
        this.addCommand("snapformat", "[-f <filename>] [-d <datfile_directory>] [-t <j9vmthread id>] [-s <filter>]", "format trace buffers for all threads or just the specified thread to a file or stdout using the specified .dat files");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length > 0 && (stringArray[0].equals("-help") || stringArray[0].equals("-h") || stringArray[0].equals("-?"))) {
            printStream.println("Format selected trace buffers.");
            printStream.println();
            printStream.println("   -f <filename>            Write output to the specified file (default is stdout)");
            printStream.println();
            printStream.println("   -d <datfile_directory>   Set the directory to search for the trace format database");
            printStream.println();
            printStream.println("   -t <thread_id>           Only output trace information for the specified J9VMThread");
            printStream.println();
            printStream.println("   -s <filter>              Only output tracepoints that match the filter expression.");
            printStream.println("                            A filter expression consists of one or more tracepoint IDs");
            printStream.println("                            combined with AND, OR, and NOT operators (&, |, !).");
            printStream.println("      Examples:");
            printStream.println("         -s j9vm                            Print all tracepoints in component 'j9vm'");
            printStream.println("         -s j9vm|j9mm                       Print all tracepoints in components 'j9vm' and 'j9mm'");
            printStream.println("         -s {entry}                         Only print 'Entry' tracepoints");
            printStream.println("         -s j9vm.0-99                       Only print 'j9vm' tracepoints with IDs below 100");
            printStream.println("         -s j9scar&!(j9scar.59|j9scar.60)   Print j9scar tracepoints except for 59 and 60");
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.j9ddr.tools.ddrinteractive.commands.SnapFormatCommand");
            Object obj = clazz.newInstance();
            if (!(obj instanceof Command)) {
                throw new DDRInteractiveCommandException("Unable to format trace. Could not create formatter.");
            }
            Command command = (Command)obj;
            command.run(string, stringArray, context, printStream);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException exception) {
            throw new DDRInteractiveCommandException("Unable to format trace. " + exception.getMessage(), exception);
        }
    }
}

