/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.IStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import java.util.ArrayList;
import java.util.Iterator;

public class StackRoots {
    private ArrayList<J9ObjectPointer> _allStackRoots = new ArrayList();
    private ArrayList<VoidPointer> _allAddresses = new ArrayList();
    private static StackRoots _singleton;

    private StackRoots() throws CorruptDataException {
        this._allStackRoots = new ArrayList();
        this._allAddresses = new ArrayList();
        this.walkStacks();
    }

    public static StackRoots from() throws CorruptDataException {
        if (null != _singleton) {
            return _singleton;
        }
        _singleton = new StackRoots();
        return _singleton;
    }

    private void walkStacks() throws CorruptDataException {
        GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
        while (gCVMThreadListIterator.hasNext()) {
            J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
            WalkState walkState = new WalkState();
            walkState.walkThread = j9VMThreadPointer;
            walkState.flags = J9Consts.J9_STACKWALK_SKIP_INLINES | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS;
            walkState.callBacks = new StackWalkerCallbacks();
            StackWalkResult stackWalkResult = StackWalkResult.STACK_CORRUPT;
            stackWalkResult = StackWalker.walkStackFrames(walkState);
            if (StackWalkResult.NONE == stackWalkResult) continue;
            throw new UnsupportedOperationException("Failed to walk stack");
        }
    }

    public static ArrayList<J9ObjectPointer> allRoots() throws CorruptDataException {
        StackRoots stackRoots = new StackRoots();
        return stackRoots._allStackRoots;
    }

    public static GCIterator stackRootIterator() throws CorruptDataException {
        StackRoots stackRoots = StackRoots.from();
        final Iterator<J9ObjectPointer> iterator = stackRoots._allStackRoots.iterator();
        final Iterator<VoidPointer> iterator2 = stackRoots._allAddresses.iterator();
        return new GCIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VoidPointer nextAddress() {
                iterator.next();
                return (VoidPointer)iterator2.next();
            }

            @Override
            public Object next() {
                iterator2.next();
                return iterator.next();
            }
        };
    }

    private class StackWalkerCallbacks
    implements IStackWalkerCallbacks {
        private StackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(J9VMThreadPointer j9VMThreadPointer, WalkState walkState) {
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(J9VMThreadPointer j9VMThreadPointer, WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
            if (walkState.method.isNull()) {
                return;
            }
            try {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
                if (j9ObjectPointer.notNull()) {
                    StackRoots.this._allStackRoots.add(j9ObjectPointer);
                    StackRoots.this._allAddresses.add(VoidPointer.cast(pointerPointer));
                }
            }
            catch (CorruptDataException corruptDataException) {
                throw new UnsupportedOperationException("Corrupt objectSlot detected");
            }
        }

        @Override
        public void fieldSlotWalkFunction(J9VMThreadPointer j9VMThreadPointer, WalkState walkState, ObjectReferencePointer objectReferencePointer, VoidPointer voidPointer) {
            if (walkState.method.isNull()) {
                return;
            }
            try {
                J9ObjectPointer j9ObjectPointer = objectReferencePointer.at(0L);
                if (j9ObjectPointer.notNull()) {
                    StackRoots.this._allStackRoots.add(j9ObjectPointer);
                    StackRoots.this._allAddresses.add(VoidPointer.cast(objectReferencePointer));
                }
            }
            catch (CorruptDataException corruptDataException) {
                throw new UnsupportedOperationException("Corrupt objectSlot detected");
            }
        }
    }
}

