/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MarkMapManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm29.structure.MM_HeapMap;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public class GCObjectHeapIteratorMarkMapIterator_V1
extends GCObjectHeapIterator {
    private static final int HEAP_BYTES_PER_MAP_BIT = (int)MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * UDATA.SIZEOF;
    private static final int HEAP_BYTES_PER_MAP_SLOT = HEAP_BYTES_PER_MAP_BIT * (int)MM_HeapMap.BITS_IN_BYTE * UDATA.SIZEOF;
    protected VoidPointer _heapBase;
    protected UDATAPointer _heapMapBits;
    protected UDATA _markWordCache;
    protected long _nextSlotIndex;
    protected long _topSlotIndex;
    protected int _shiftCount;
    protected J9ObjectPointer _nextObject;

    protected GCObjectHeapIteratorMarkMapIterator_V1(GCHeapRegionDescriptor gCHeapRegionDescriptor) throws CorruptDataException {
        super(true, false);
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCObjectHeapIteratorMarkMapIterator_V1.getExtensions();
        MM_IncrementalGenerationalGCPointer mM_IncrementalGenerationalGCPointer = MM_IncrementalGenerationalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
        MM_MarkMapManagerPointer mM_MarkMapManagerPointer = mM_IncrementalGenerationalGCPointer._markMapManager();
        MM_MarkMapPointer mM_MarkMapPointer = mM_MarkMapManagerPointer._previousMarkMap();
        this._heapBase = mM_MarkMapPointer._heapBase();
        this._heapMapBits = mM_MarkMapPointer._heapMapBits();
        VoidPointer voidPointer = gCHeapRegionDescriptor.getLowAddress();
        this._nextSlotIndex = this.convertAddressToMapSlotIndex(this._heapBase, voidPointer);
        VoidPointer voidPointer2 = gCHeapRegionDescriptor.getHighAddress();
        this._topSlotIndex = this.convertAddressToMapSlotIndex(this._heapBase, voidPointer2);
        this._markWordCache = new UDATA(0L);
        this._shiftCount = 0;
    }

    private long convertAddressToMapSlotIndex(VoidPointer voidPointer, VoidPointer voidPointer2) throws CorruptDataException {
        long l = voidPointer2.longValue() - voidPointer.longValue();
        return l / (long)HEAP_BYTES_PER_MAP_SLOT;
    }

    @Override
    public void advance(UDATA uDATA) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            if (null == this._nextObject) {
                this.nextImpl();
            }
            J9ObjectPointer j9ObjectPointer = this._nextObject;
            this._nextObject = null;
            if (null != j9ObjectPointer) {
                return j9ObjectPointer;
            }
        }
        throw new NoSuchElementException("No more objects");
    }

    @Override
    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            J9ObjectPointer j9ObjectPointer;
            if (null == this._nextObject) {
                this.nextImpl();
            }
            if (null != (j9ObjectPointer = this._nextObject)) {
                return j9ObjectPointer;
            }
        }
        throw new NoSuchElementException("No more objects");
    }

    protected void nextImpl() {
        this._nextObject = null;
        while (!(null != this._nextObject || this._nextSlotIndex == this._topSlotIndex && this._markWordCache.eq(0L))) {
            while (null == this._nextObject && !this._markWordCache.eq(0L)) {
                if (this._markWordCache.allBitsIn(1L)) {
                    this._nextObject = this.convertToObject(this._nextSlotIndex - 1L, this._shiftCount);
                }
                ++this._shiftCount;
                this._markWordCache = this._markWordCache.rightShift(1);
            }
            if (null != this._nextObject) continue;
            try {
                this.recacheMarkMapWord();
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
                throw new NoSuchElementException("Failed to continue reading objects from region");
            }
        }
    }

    private void recacheMarkMapWord() throws CorruptDataException {
        while (this._markWordCache.eq(0L) && this._nextSlotIndex != this._topSlotIndex) {
            this._markWordCache = this._heapMapBits.at(this._nextSlotIndex);
            ++this._nextSlotIndex;
            this._shiftCount = 0;
        }
    }

    private J9ObjectPointer convertToObject(long l, int n) {
        long l2 = (long)HEAP_BYTES_PER_MAP_SLOT * l + (long)(HEAP_BYTES_PER_MAP_BIT * n);
        return J9ObjectPointer.cast(this._heapBase.addOffset(l2));
    }

    @Override
    public boolean hasNext() {
        if (null != this._nextObject) {
            return true;
        }
        boolean bl = false;
        try {
            this.recacheMarkMapWord();
            bl = !this._markWordCache.eq(0L);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
        }
        return bl;
    }
}

