/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindAllReadsCommand
extends Command {
    public FindAllReadsCommand() {
        this.addCommand("findallreads", "<targetModuleAddress>", "find all modules that read target module");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            CommandUtils.dbgPrint(printStream, "Usage: !findallreads <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
                int n = 0;
                String string2 = stringArray[0];
                PatternString patternString = new PatternString(string2);
                while (gCClassLoaderIterator.hasNext()) {
                    J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                    HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9ClassLoaderPointer.moduleHashTable());
                    Iterator iterator = hashTable.iterator();
                    block3: while (iterator.hasNext()) {
                        J9ModulePointer j9ModulePointer = (J9ModulePointer)iterator.next();
                        String string3 = J9ObjectHelper.stringValue(j9ModulePointer.moduleName());
                        String string4 = j9ModulePointer.getHexAddress();
                        J9HashTablePointer j9HashTablePointer = j9ModulePointer.readAccessHashTable();
                        HashTable<J9ModulePointer> hashTable2 = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
                        Iterator iterator2 = hashTable2.iterator();
                        while (iterator2.hasNext()) {
                            J9ModulePointer j9ModulePointer2 = (J9ModulePointer)iterator2.next();
                            String string5 = j9ModulePointer2.getHexAddress();
                            if (!patternString.isMatch(string5)) continue;
                            ++n;
                            printStream.printf("%-30s !j9module %s%n", string3, string4);
                            continue block3;
                        }
                    }
                }
                printStream.printf("Found %d module(s) that read(s) from !j9module %s%n", n, string2);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

