/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.exceptions.UnknownArchitectureException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.VMRegMapHelper;
import java.io.PrintStream;

public class J9RegCommand
extends Command {
    public J9RegCommand() {
        this.addCommand("j9reg", "<level>", "list VM named registers");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("j9reg <level> - list VM named registers");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        int n = 0;
        if (0 == stringArray.length) {
            n = 1;
        } else if (1 == stringArray.length) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                printStream.println(stringArray[0] + " is not a valid integer. Please try again.");
                return;
            }
        } else {
            this.printUsage(printStream);
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            VMRegMapHelper.printRegisters(j9JavaVMPointer, n, printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException("Failed to get vm address from RAS");
        }
        catch (UnknownArchitectureException unknownArchitectureException) {
            throw new DDRInteractiveCommandException(unknownArchitectureException.getMessage(), unknownArchitectureException);
        }
    }
}

