/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ImageProcess
implements com.ibm.dtfj.image.ImageProcess {
    private Vector _runtimes = new Vector();
    private Vector _libraries = new Vector();
    private Vector _threads = new Vector();
    private int _pointerSize;
    private ImageModule _executable;
    private String _id;
    private String _commandLine;
    private Properties _environment;
    private com.ibm.dtfj.image.j9.ImageThread _currentThread;
    private long _faultingNativeID = 0L;
    private int _signalNumber = 0;
    private Exception _runtimeCheckFailure;
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private static String[] names = new String[]{"ZERO", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGEMT", "SIGFPE", "SIGKILL", "SIGBUS", "SIGSEGV", "SIGSYS", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGUSR1", "SIGUSR2", "SIGCHLD", "SIGPWR", "SIGWINCH", "SIGURG/BREAK", "SIGPOLL/ABRT", "SIGSTOP", "SIGTSTP", "SIGCONT", "SIGTTIN", "SIGTTOU", "SIGVTALRM", "SIGPROF", "SIGXCPU", "SIGXFSZ", "SIGWAITING", "SIGLWP", "SIGAIO", "SIGFPE_DIV_BY_ZERO", "SIGFPE_INT_DIV_BY_ZERO", "SIGFPE_INT_OVERFLOW"};

    public ImageProcess(String string, String string2, Properties properties, com.ibm.dtfj.image.j9.ImageThread imageThread, Iterator iterator, ImageModule imageModule, Iterator iterator2, int n) {
        this._id = string;
        this._commandLine = string2;
        this._environment = properties;
        this.setCurrentThread(imageThread);
        this.setThreads(iterator);
        this._executable = imageModule;
        while (iterator2.hasNext()) {
            this._libraries.add(iterator2.next());
        }
        this._pointerSize = n;
    }

    @Override
    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        Properties properties = this.getEnvironment();
        String string = properties.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
        if (string != null) {
            return string;
        }
        if (this._commandLine == null) {
            throw new DataUnavailable("Command line unavailable from core dump");
        }
        return this._commandLine;
    }

    @Override
    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (null == this._environment) {
            if (null == this._runtimeCheckFailure) {
                throw new DataUnavailable("Environment base address when core file parsed");
            }
            throw new CorruptDataException(new CorruptData("Environment not found due to:  " + this._runtimeCheckFailure.getMessage(), null));
        }
        return this._environment;
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return this._id;
    }

    @Override
    public Iterator getLibraries() throws DataUnavailable, CorruptDataException {
        return this._libraries.iterator();
    }

    @Override
    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        if (null == this._executable) {
            throw new DataUnavailable("Executable image not found");
        }
        return this._executable;
    }

    @Override
    public Iterator getThreads() {
        return this._threads.iterator();
    }

    @Override
    public ImageThread getCurrentThread() throws CorruptDataException {
        com.ibm.dtfj.image.j9.ImageThread imageThread = this._currentThread;
        if (0L != this._faultingNativeID) {
            Iterator iterator = this.getThreads();
            while (iterator.hasNext()) {
                com.ibm.dtfj.image.j9.ImageThread imageThread2;
                Object e = iterator.next();
                if (e instanceof CorruptData || Long.decode((imageThread2 = (com.ibm.dtfj.image.j9.ImageThread)e).getID()) != this._faultingNativeID) continue;
                imageThread = imageThread2;
                break;
            }
        }
        if (0L != this._faultingNativeID && null == imageThread) {
            throw new CorruptDataException(new CorruptData("no current thread", null));
        }
        return imageThread;
    }

    @Override
    public Iterator getRuntimes() {
        Iterator<Object> iterator = null == this._runtimeCheckFailure ? this._runtimes.iterator() : Collections.singleton(new CorruptData("No runtimes due to early startup error:  " + this._runtimeCheckFailure.getMessage(), null)).iterator();
        return iterator;
    }

    @Override
    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        int n;
        int n2 = n = null == this._currentThread ? 0 : this._currentThread.getSignal();
        if (0 != this._signalNumber) {
            n = this._signalNumber;
        }
        return n;
    }

    private String resolvePlatformName(int n) {
        if (n >= 0 && n < names.length) {
            return names[n];
        }
        return "Signal." + Integer.toString(n);
    }

    @Override
    public String getSignalName() throws DataUnavailable, CorruptDataException {
        if (0 == this.getSignalNumber()) {
            return null;
        }
        int n = this.getSignalNumber();
        return this.resolvePlatformName(n);
    }

    @Override
    public int getPointerSize() {
        return this._pointerSize;
    }

    public void addRuntime(JavaRuntime javaRuntime) {
        this._runtimes.add(javaRuntime);
    }

    public void setFaultingThreadID(long l) {
        this._faultingNativeID = l;
    }

    public void setSignalNumber(int n) {
        this._signalNumber = n;
    }

    public void runtimeExtractionFailed(Exception exception) {
        this._runtimeCheckFailure = exception;
    }

    protected void setThreads(Iterator iterator) {
        this._threads.clear();
        while (iterator.hasNext()) {
            this._threads.add(iterator.next());
        }
    }

    protected void setCurrentThread(com.ibm.dtfj.image.j9.ImageThread imageThread) {
        this._currentThread = imageThread;
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

