/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaStaticField
extends JavaField {
    private String _value;

    public JavaStaticField(JavaRuntime javaRuntime, String string, String string2, int n, String string3, long l) {
        super(javaRuntime, string, string2, n, l);
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java static field cannot exist in a null Java VM");
        }
        this._value = string3;
    }

    @Override
    public Object getReferenceType(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        String string = this.getSignature();
        if (string.startsWith("L") || string.startsWith("[")) {
            try {
                ImagePointer imagePointer = this.getDeclaringClass().getID().getAddressSpace().getPointer(this.parse(16));
                if (0L == imagePointer.getAddress()) {
                    return null;
                }
                try {
                    return this._javaVM.getObjectAtAddress(imagePointer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CorruptDataException(new CorruptData(illegalArgumentException.getMessage(), imagePointer));
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        throw new IllegalArgumentException("field is not of suitable type. Actual signature is " + this.getSignature());
    }

    @Override
    public boolean getBoolean(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("Z")) {
            if (null == this._value) {
                throw new CorruptDataException(new CorruptData("parse error: value is null", null));
            }
            return this._value.charAt(0) != '0';
        }
        throw new IllegalArgumentException("field is not of type boolean. actual signature is " + this.getSignature());
    }

    @Override
    public byte getByte(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("B")) {
            return (byte)this.parse(2);
        }
        throw new IllegalArgumentException("field is not of type byte. actual signature is " + this.getSignature());
    }

    @Override
    public char getChar(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("C")) {
            return (char)this.parse(4);
        }
        throw new IllegalArgumentException("field is not of type char. actual signature is " + this.getSignature());
    }

    @Override
    public double getDouble(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("D")) {
            long l = this.parse(16);
            return Double.longBitsToDouble(l);
        }
        return super.getDouble(javaObject);
    }

    @Override
    public float getFloat(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("F")) {
            int n = (int)this.parse(8);
            return Float.intBitsToFloat(n);
        }
        return super.getFloat(javaObject);
    }

    @Override
    public int getInt(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("I")) {
            return (int)this.parse(8);
        }
        return super.getInt(javaObject);
    }

    @Override
    public long getLong(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("J")) {
            return this.parse(16);
        }
        return super.getLong(javaObject);
    }

    @Override
    public short getShort(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals("S")) {
            return (short)this.parse(4);
        }
        return super.getShort(javaObject);
    }

    private long parse(int n) throws CorruptDataException {
        if (null == this._value) {
            throw new CorruptDataException(new CorruptData("parse error: value is null", null));
        }
        if (this._value.length() > n) {
            throw new CorruptDataException(new CorruptData("parse error: value [" + this._value + "] length " + this._value.length() + " exceeds maximum of " + n, null));
        }
        if (16 == this._value.length()) {
            String string = this._value.substring(0, 8);
            String string2 = this._value.substring(8, 16);
            long l = Long.parseLong(string, 16);
            long l2 = Long.parseLong(string2, 16);
            return l << 32 | l2;
        }
        return Long.parseLong(this._value, 16);
    }
}

