/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JCJavaRuntimeMemoryCategory
implements JavaRuntimeMemoryCategory {
    private final String name;
    private final long deepAllocations;
    private final long deepBytes;
    private boolean shallowValuesSet = false;
    private long shallowAllocations;
    private long shallowBytes;
    private final List children = new LinkedList();
    private static final String nl = System.getProperty("line.separator");

    public JCJavaRuntimeMemoryCategory(String string, long l, long l2) {
        this.name = string;
        this.deepAllocations = l2;
        this.deepBytes = l;
    }

    @Override
    public Iterator getChildren() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    public void addChild(JavaRuntimeMemoryCategory javaRuntimeMemoryCategory) {
        this.children.add(javaRuntimeMemoryCategory);
    }

    @Override
    public long getDeepAllocations() {
        return this.deepAllocations;
    }

    @Override
    public long getDeepBytes() {
        return this.deepBytes;
    }

    @Override
    public Iterator getMemorySections(boolean bl) {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setShallowCounters(long l, long l2) {
        this.shallowBytes = l;
        this.shallowAllocations = l2;
        this.shallowValuesSet = true;
    }

    @Override
    public long getShallowAllocations() {
        if (this.shallowValuesSet) {
            return this.shallowAllocations;
        }
        if (this.children.size() == 0) {
            return this.deepAllocations;
        }
        return 0L;
    }

    @Override
    public long getShallowBytes() {
        if (this.shallowValuesSet) {
            return this.shallowBytes;
        }
        if (this.children.size() == 0) {
            return this.deepBytes;
        }
        return 0L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.buildPrintTree(stringBuffer, 1);
        return stringBuffer.toString();
    }

    private void buildPrintTree(StringBuffer stringBuffer, int n) {
        int n2;
        if (n > 1) {
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append("    ");
                }
                stringBuffer.append("|");
            }
            stringBuffer.append(nl);
        }
        for (n2 = 0; n2 < n - 2; ++n2) {
            stringBuffer.append("|    ");
        }
        if (n > 1) {
            stringBuffer.append("+--");
        }
        stringBuffer.append(this.name);
        stringBuffer.append(": ");
        stringBuffer.append(Long.toString(this.deepBytes));
        stringBuffer.append(" / ");
        stringBuffer.append(Long.toString(this.deepAllocations));
        stringBuffer.append(" allocation");
        if (this.deepAllocations != 1L) {
            stringBuffer.append("s");
        }
        stringBuffer.append(nl);
        for (JCJavaRuntimeMemoryCategory jCJavaRuntimeMemoryCategory : this.children) {
            jCJavaRuntimeMemoryCategory.buildPrintTree(stringBuffer, n + 1);
        }
        if (this.children.size() > 0 && this.getShallowBytes() > 0L) {
            JCJavaRuntimeMemoryCategory jCJavaRuntimeMemoryCategory;
            jCJavaRuntimeMemoryCategory = new JCJavaRuntimeMemoryCategory("Other", this.getShallowBytes(), this.getShallowAllocations());
            jCJavaRuntimeMemoryCategory.buildPrintTree(stringBuffer, n + 1);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.children == null ? 0 : this.children.hashCode());
        n = 31 * n + (int)(this.deepAllocations ^ this.deepAllocations >>> 32);
        n = 31 * n + (int)(this.deepBytes ^ this.deepBytes >>> 32);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JCJavaRuntimeMemoryCategory)) {
            return false;
        }
        JCJavaRuntimeMemoryCategory jCJavaRuntimeMemoryCategory = (JCJavaRuntimeMemoryCategory)object;
        if (this.children == null ? jCJavaRuntimeMemoryCategory.children != null : !this.children.equals(jCJavaRuntimeMemoryCategory.children)) {
            return false;
        }
        if (this.deepAllocations != jCJavaRuntimeMemoryCategory.deepAllocations) {
            return false;
        }
        if (this.deepBytes != jCJavaRuntimeMemoryCategory.deepBytes) {
            return false;
        }
        return !(this.name == null ? jCJavaRuntimeMemoryCategory.name != null : !this.name.equals(jCJavaRuntimeMemoryCategory.name));
    }
}

