/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import java.net.URL;

public abstract class PluginConfig {
    protected final Entry entry;
    protected Throwable t = null;
    protected boolean cacheOutput = true;

    public PluginConfig(Entry entry) {
        this.entry = entry;
    }

    public String getName() {
        return this.entry.getName();
    }

    public ICommand newInstance(ClassLoader classLoader) throws CommandException {
        ClassInfo classInfo = (ClassInfo)this.entry.getData();
        try {
            Class<?> clazz = Class.forName(classInfo.getClassname(), true, classLoader);
            Object obj = clazz.newInstance();
            if (obj instanceof BaseCommand) {
                ((BaseCommand)obj).setConfig(this);
            }
            return (ICommand)obj;
        }
        catch (Throwable throwable) {
            this.t = throwable;
            throw new CommandException("Failed to create a new instance of command " + classInfo.getClassname(), throwable);
        }
    }

    public abstract String toCSV();

    public String getClassName() {
        ClassInfo classInfo = (ClassInfo)this.entry.getData();
        return classInfo.getClassname();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PluginConfig)) {
            return false;
        }
        PluginConfig pluginConfig = (PluginConfig)object;
        Object t = this.entry.getData();
        Object t2 = pluginConfig.entry.getData();
        return t.equals(t2);
    }

    public int hashCode() {
        return this.getClassName().hashCode();
    }

    public String getId() {
        return this.getClassName();
    }

    public Throwable getError() {
        return this.t;
    }

    public boolean isEnabled() {
        return this.t == null;
    }

    public URL getURL() {
        return this.entry.toURL();
    }

    public boolean cacheOutput() {
        return this.cacheOutput;
    }
}

