/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaBuffer;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaGrid;
import com.ibm.cuda.CudaKernel;
import com.ibm.cuda.CudaStream;

public final class CudaFunction {
    public static final int ATTRIBUTE_BINARY_VERSION = 6;
    public static final int ATTRIBUTE_CONST_SIZE_BYTES = 2;
    public static final int ATTRIBUTE_LOCAL_SIZE_BYTES = 3;
    public static final int ATTRIBUTE_MAX_THREADS_PER_BLOCK = 0;
    public static final int ATTRIBUTE_NUM_REGS = 4;
    public static final int ATTRIBUTE_PTX_VERSION = 5;
    public static final int ATTRIBUTE_SHARED_SIZE_BYTES = 1;
    final int deviceId;
    private final long nativeHandle;

    private static native int getAttribute(int var0, long var1, int var3) throws CudaException;

    private static native void launch(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long[] var12) throws CudaException;

    static long nativeValueOf(Object object) {
        long l = 0L;
        if (object != null) {
            Class<? extends Object> clazz = object.getClass();
            if (clazz == CudaBuffer.class) {
                l = ((CudaBuffer)object).getAddress();
            } else if (clazz == Integer.class) {
                l = ((Integer)object).intValue();
            } else if (clazz == Long.class) {
                l = (Long)object;
            } else if (clazz == Double.class) {
                l = Double.doubleToRawLongBits((Double)object);
            } else if (clazz == Float.class) {
                l = Float.floatToRawIntBits(((Float)object).floatValue());
            } else if (clazz == Short.class) {
                l = ((Short)object).shortValue();
            } else if (clazz == Byte.class) {
                l = ((Byte)object).byteValue();
            } else if (clazz == Character.class) {
                l = ((Character)object).charValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
        return l;
    }

    private static native void setCacheConfig(int var0, long var1, int var3) throws CudaException;

    private static native void setSharedMemConfig(int var0, long var1, int var3) throws CudaException;

    CudaFunction(int n, long l) {
        this.deviceId = n;
        this.nativeHandle = l;
    }

    public int getAttribute(int n) throws CudaException {
        return CudaFunction.getAttribute(this.deviceId, this.nativeHandle, n);
    }

    void launch(CudaGrid cudaGrid, Object ... objectArray) throws CudaException {
        int n = objectArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = CudaFunction.nativeValueOf(objectArray[i]);
        }
        CudaStream cudaStream = cudaGrid.stream;
        CudaFunction.launch(this.deviceId, this.nativeHandle, cudaGrid.gridDimX, cudaGrid.gridDimY, cudaGrid.gridDimZ, cudaGrid.blockDimX, cudaGrid.blockDimY, cudaGrid.blockDimZ, cudaGrid.sharedMemBytes, cudaStream != null ? cudaStream.getHandle() : 0L, lArray);
    }

    void launch(CudaGrid cudaGrid, CudaKernel.Parameters parameters) throws CudaException {
        if (!parameters.isComplete()) {
            throw new IllegalArgumentException();
        }
        CudaStream cudaStream = cudaGrid.stream;
        CudaFunction.launch(this.deviceId, this.nativeHandle, cudaGrid.gridDimX, cudaGrid.gridDimY, cudaGrid.gridDimZ, cudaGrid.blockDimX, cudaGrid.blockDimY, cudaGrid.blockDimZ, cudaGrid.sharedMemBytes, cudaStream != null ? cudaStream.getHandle() : 0L, parameters.values);
    }

    public void setCacheConfig(CudaDevice.CacheConfig cacheConfig) throws CudaException {
        CudaFunction.setCacheConfig(this.deviceId, this.nativeHandle, cacheConfig.nativeValue);
    }

    public void setSharedMemConfig(CudaDevice.SharedMemConfig sharedMemConfig) throws CudaException {
        CudaFunction.setSharedMemConfig(this.deviceId, this.nativeHandle, sharedMemConfig.nativeValue);
    }
}

