/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.GlobalRefCleaner;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSiteDynamicInvokerHandle;
import java.lang.invoke.StructuralComparator;
import java.lang.invoke.WrongMethodTypeException;
import sun.misc.Cleaner;

public class MutableCallSite
extends CallSite {
    private MutableCallSiteDynamicInvokerHandle cachedDynamicInvoker;
    private final GlobalRefCleaner globalRefCleaner;
    private static final long targetFieldOffset;
    private volatile MethodHandle target;
    private volatile MethodHandle epoch;
    private static final Object bypassBase;
    private int equivalenceInterval = 0;
    private int equivalenceCounter = 0;
    private long invalidationCookie;

    private static native void registerNatives();

    private static long initializeTargetFieldOffset() {
        try {
            return MethodHandle.UNSAFE.objectFieldOffset(MutableCallSite.class.getDeclaredField("target"));
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError();
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public MutableCallSite(MethodHandle methodHandle) throws NullPointerException {
        super(methodHandle.type());
        this.target = this.epoch = methodHandle;
        this.freeze();
        this.globalRefCleaner = new GlobalRefCleaner();
        Cleaner.create(this, this.globalRefCleaner);
    }

    public MutableCallSite(MethodType methodType) throws NullPointerException {
        super(methodType);
        this.target = CallSite.initialTarget(methodType);
        this.epoch = null;
        this.freeze();
        this.globalRefCleaner = new GlobalRefCleaner();
        Cleaner.create(this, this.globalRefCleaner);
    }

    @Override
    public final MethodHandle dynamicInvoker() {
        if (null == this.cachedDynamicInvoker) {
            this.cachedDynamicInvoker = new MutableCallSiteDynamicInvokerHandle(this);
        }
        return this.cachedDynamicInvoker;
    }

    @Override
    public final MethodHandle getTarget() {
        return this.target;
    }

    private static Object initializeBypassBase() {
        try {
            return MethodHandle.UNSAFE.staticFieldBase(MutableCallSite.class.getDeclaredField("targetFieldOffset"));
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError();
            internalError.initCause(exception);
            throw internalError;
        }
    }

    @Override
    public void setTarget(MethodHandle methodHandle) {
        if (this.type() != methodHandle.type) {
            throw WrongMethodTypeException.newWrongMethodTypeException(this.type(), methodHandle.type);
        }
        MethodHandle methodHandle2 = this.target;
        if (methodHandle2 != methodHandle) {
            if (--this.equivalenceCounter <= 0) {
                if (StructuralComparator.get().handlesAreEquivalent(methodHandle2, methodHandle)) {
                    this.equivalenceInterval = 1;
                    MethodHandle.UNSAFE.compareAndSwapObject(this, targetFieldOffset, methodHandle2, methodHandle);
                } else {
                    this.thaw(methodHandle2, methodHandle);
                    this.equivalenceInterval = Math.min(1 + this.equivalenceInterval + (this.equivalenceInterval >> 2), 1000);
                }
                this.equivalenceCounter = this.equivalenceInterval;
            } else {
                this.thaw(methodHandle2, methodHandle);
            }
            if (this.globalRefCleaner.bypassOffset != 0L) {
                MethodHandle.UNSAFE.putObject(bypassBase, this.globalRefCleaner.bypassOffset, (Object)methodHandle);
            }
        }
    }

    private synchronized void thaw(MethodHandle methodHandle, MethodHandle methodHandle2) {
        this.epoch = null;
        MutableCallSite.invalidate(new long[]{this.invalidationCookie});
        this.target = methodHandle2;
        this.epoch = methodHandle2;
    }

    private void freeze() {
    }

    private static native void invalidate(long[] var0);

    public static void syncAll(MutableCallSite[] mutableCallSiteArray) throws NullPointerException {
        for (int i = 0; i < mutableCallSiteArray.length; ++i) {
            mutableCallSiteArray[i].freeze();
        }
    }

    static native void freeGlobalRef(long var0);

    static {
        MutableCallSite.registerNatives();
        targetFieldOffset = MutableCallSite.initializeTargetFieldOffset();
        bypassBase = MutableCallSite.initializeBypassBase();
    }
}

