/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private int dataLength = 0;
    private static final long mask = 127L;

    public MetaMessage() {
        this(new byte[]{-1, 0});
    }

    public MetaMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        super(null);
        this.setMessage(n, byArray, n2);
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
        if (byArray.length >= 3) {
            this.dataLength = byArray.length - 3;
            for (int i = 2; i < byArray.length && (byArray[i] & 0x80) != 0; ++i) {
                --this.dataLength;
            }
        }
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n >= 128 || n < 0) {
            throw new InvalidMidiDataException("Invalid meta event with type " + n);
        }
        if (n2 > 0 && n2 > byArray.length || n2 < 0) {
            throw new InvalidMidiDataException("length out of bounds: " + n2);
        }
        this.length = 2 + this.getVarIntLength(n2) + n2;
        this.dataLength = n2;
        this.data = new byte[this.length];
        this.data[0] = -1;
        this.data[1] = (byte)n;
        this.writeVarInt(this.data, 2, n2);
        if (n2 > 0) {
            System.arraycopy((Object)byArray, 0, (Object)this.data, this.length - this.dataLength, this.dataLength);
        }
    }

    public int getType() {
        if (this.length >= 2) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.dataLength];
        System.arraycopy((Object)this.data, this.length - this.dataLength, (Object)byArray, 0, this.dataLength);
        return byArray;
    }

    @Override
    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy((Object)this.data, 0, (Object)byArray, 0, byArray.length);
        MetaMessage metaMessage = new MetaMessage(byArray);
        return metaMessage;
    }

    private int getVarIntLength(long l) {
        int n = 0;
        do {
            ++n;
        } while ((l >>= 7) > 0L);
        return n;
    }

    private void writeVarInt(byte[] byArray, int n, long l) {
        int n2;
        for (n2 = 63; n2 > 0 && (l & 127L << n2) == 0L; n2 -= 7) {
        }
        while (n2 > 0) {
            byArray[n++] = (byte)((l & 127L << n2) >> n2 | 0x80L);
            n2 -= 7;
        }
        byArray[n] = (byte)(l & 0x7FL);
    }
}

