/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class CoreInfoCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public CoreInfoCommand() {
        this.addCommand("coreinfo", "", "Prints commandline, platform and -version info of VM found in the current core file.");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("coreinfo - Prints commandline, platform and -version info of VM found in the current core file.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (0 < stringArray.length) {
            printStream.println("!coreinfo expects no args. Usage :");
            this.printUsage(printStream);
            return;
        }
        try {
            J9RASPointer j9RASPointer = DataType.getJ9RASPointer();
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(j9RASPointer);
            IProcess iProcess = j9JavaVMPointer.getProcess();
            J9DDRImageProcess j9DDRImageProcess = new J9DDRImageProcess(iProcess);
            try {
                printStream.println("COMMANDLINE\n" + j9DDRImageProcess.getCommandLine() + "\n");
            }
            catch (DataUnavailable dataUnavailable) {
                printStream.println("COMMANDLINE is not available\n");
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the commandline from process");
            }
            Properties properties = J9JavaVMHelper.getSystemProperties(j9JavaVMPointer);
            printStream.println("JAVA SERVICE LEVEL INFO\n" + j9RASPointer.serviceLevel().getCStringAtOffset(0L));
            printStream.println("JAVA VERSION INFO\n" + properties.get("java.fullversion"));
            printStream.println("JAVA VM VERSION\t- " + properties.get("java.vm.version") + "\n");
            boolean bl = iProcess.bytesPerPointer() == 8;
            ICore iCore = j9JavaVMPointer.getProcess().getAddressSpace().getCore();
            Platform platform = iCore.getPlatform();
            printStream.println("PLATFORM INFO");
            printStream.print("Platform Name :\t" + platform.name());
            if (bl) {
                printStream.println(" 64Bit");
            } else {
                printStream.println(" 32Bit");
            }
            printStream.println("OS Level\t: " + j9RASPointer.osnameEA().getCStringAtOffset(0L) + " " + j9RASPointer.osversionEA().getCStringAtOffset(0L));
            printStream.println("Processors -");
            printStream.println("  Architecture\t: " + j9RASPointer.osarchEA().getCStringAtOffset(0L));
            printStream.println("  How Many\t: " + j9RASPointer.cpus().longValue());
            try {
                properties = j9DDRImageProcess.getEnvironment();
                Enumeration<Object> enumeration = properties.keys();
                printStream.println("\nENVIRONMENT VARIABLES");
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    printStream.println(string2 + "=" + properties.get(string2));
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the environment variables from process");
            }
            catch (DataUnavailable dataUnavailable) {
                printStream.println("Environment variables are not available\n");
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }
}

