/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class J9ClassShapeCommand
extends Command {
    public J9ClassShapeCommand() {
        this.addCommand("j9classshape", "<ramclass>", "view instance shape");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            CommandUtils.dbgPrint(printStream, "Usage: !j9classshape <classAddress>\n");
            return;
        }
        try {
            Object object;
            String string2;
            Object object2;
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9ClassPointer j9ClassPointer = J9ClassPointer.NULL;
            String string3 = stringArray[0];
            if (string3.matches("\\p{Digit}.*")) {
                j9ClassPointer = J9ClassPointer.cast(CommandUtils.parsePointer(string3, J9BuildFlags.env_data64));
            } else {
                object2 = J9ClassShapeCommand.findClassByName(j9JavaVMPointer, string3);
                if (((J9ClassPointer[])object2).length == 0) {
                    CommandUtils.dbgPrint(printStream, "No classes matching \"" + string3 + "\" found\n");
                    return;
                }
                if (((J9ClassPointer[])object2).length > 1) {
                    CommandUtils.dbgPrint(printStream, "Multiple classes matching \"" + string3 + "\" found\n");
                    return;
                }
                j9ClassPointer = object2[0];
                string2 = J9ClassHelper.getJavaName(j9ClassPointer);
                object = j9ClassPointer.getHexAddress();
                CommandUtils.dbgPrint(printStream, String.format("!j9class %1$s\n", object));
            }
            object2 = J9ClassPointer.NULL;
            string2 = J9ClassHelper.getName(j9ClassPointer);
            object = j9JavaVMPointer.mainThread();
            boolean bl = false;
            CommandUtils.dbgPrint(printStream, "Instance fields in %s:\n", string2);
            CommandUtils.dbgPrint(printStream, "\noffset     name\tsignature\t(declaring class)\n");
            if (((AbstractPointer)object).isNull()) {
                return;
            }
            long l = J9ClassHelper.classDepth(j9ClassPointer).longValue();
            for (long i = 0L; i <= l; ++i) {
                J9ClassPointer j9ClassPointer2 = i == l ? j9ClassPointer : J9ClassPointer.cast(j9ClassPointer.superclasses().at(i));
                U32 u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
                Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(j9ClassPointer2.romClass(), j9ClassPointer, (J9ClassPointer)object2, u32);
                while (iterator.hasNext()) {
                    boolean bl2;
                    J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                    boolean bl3 = true;
                    boolean bl4 = j9ObjectFieldOffset.isHidden();
                    boolean bl5 = bl2 = bl4 && j9ObjectFieldOffset.getOffsetOrAddress().add(J9Object.SIZEOF).eq(j9ClassPointer2.lockOffset());
                    if (bl2) {
                        boolean bl6 = bl3 = !bl && j9ClassPointer.lockOffset().eq(j9ClassPointer2.lockOffset());
                        if (bl3) {
                            bl = true;
                        }
                    }
                    if (!bl3) continue;
                    this.printShapeField(printStream, j9ClassPointer2, j9ObjectFieldOffset.getField(), j9ObjectFieldOffset.getOffsetOrAddress(), bl4);
                }
                object2 = j9ClassPointer2;
            }
            CommandUtils.dbgPrint(printStream, "\nTotal instance size: %d\n", j9ClassPointer.totalInstanceSize().longValue());
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printShapeField(PrintStream printStream, J9ClassPointer j9ClassPointer, J9ROMFieldShapePointer j9ROMFieldShapePointer, UDATA uDATA, boolean bl) throws CorruptDataException {
        String string = J9ROMFieldShapeHelper.getName(j9ROMFieldShapePointer);
        String string2 = J9ROMFieldShapeHelper.getSignature(j9ROMFieldShapePointer);
        String string3 = J9UTF8Helper.stringValue(j9ClassPointer.romClass().className());
        CommandUtils.dbgPrint(printStream, "%d\t%s\t%s\t(%s)%s\n", uDATA.longValue(), string, string2, string3, bl ? " <hidden>" : "");
    }

    public static J9ClassPointer[] findClassByName(J9JavaVMPointer j9JavaVMPointer, String string) throws DDRInteractiveCommandException {
        ArrayList<J9ClassPointer> arrayList = new ArrayList<J9ClassPointer>();
        try {
            PatternString patternString = new PatternString(string);
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                String string2 = J9ClassHelper.getJavaName(j9ClassPointer);
                if (!patternString.isMatch(string2)) continue;
                arrayList.add(j9ClassPointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        return arrayList.toArray(new J9ClassPointer[arrayList.size()]);
    }
}

