/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9MemTag;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.WildCard;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class J9MemTagCommands
extends Command
implements IEventListener {
    public static final long SEARCH_SLAB_SIZE = 1024L;
    private final int SORT_TYPE_DEFAULT = 1;
    private final int SORT_TYPE_NAME = 2;
    private final int SORT_TYPE_ALLOCSIZE = 3;
    private final String SORT_TYPE_STRING_NAME = "name";
    private final String SORT_TYPE_STRING_ALLOCSIZE = "allocsize";
    private final String SORT_TYPE_PREFIX = "sort:";
    private static final String[][] commands = new String[][]{{"!findcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite."}, {"!printallcallsites [sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *)."}, {"!printfreedcallsites [sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)"}, {"!findheader", "locate the memory allocation header for the specified address."}, {"!findallcallsites [sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite."}, {"!findfreedcallsites [sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite."}, {"!findfreedcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite."}};
    private PrintStream out;

    public J9MemTagCommands() {
        this.addCommand("findcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite.");
        this.addCommand("printallcallsites", "[sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *).");
        this.addCommand("printfreedcallsites", "[sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)");
        this.addCommand("findheader", "", "locate the memory allocation header for the specified address.");
        this.addCommand("findallcallsites", "[sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsites", "[sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        string = string.toLowerCase();
        this.out = printStream;
        EventManager.register(this);
        try {
            if (string.endsWith("findallcallsites")) {
                this.runFindAllCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findfreedcallsites")) {
                this.runFindAllFreedCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findfreedcallsite")) {
                this.runFindFreedCallsite(string, stringArray, context);
                return;
            }
            if (string.endsWith("printallcallsites")) {
                this.runPrintAllCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("printfreedcallsites")) {
                this.runPrintAllFreedCallsites(string, stringArray, context);
                return;
            }
            if (string.endsWith("findheader")) {
                this.runFindHeader(string, stringArray, context);
                return;
            }
            if (string.endsWith("findcallsite")) {
                this.runFindCallsite(string, stringArray, context);
                return;
            }
            throw new DDRInteractiveCommandException("Unrecognized command: " + string);
        }
        finally {
            EventManager.unregister(this);
        }
    }

    private void printUsageForFindFreedCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findfreedcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start> [sort:<name:allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindFreedCallsite(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        long l = 0L;
        long l2 = UDATA.MASK;
        int n = 1;
        if (0 == stringArray.length) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        String[] stringArray2 = stringArray[0].split(",");
        String string2 = stringArray2[0];
        if (stringArray2.length == 2) {
            l = Long.decode(stringArray2[1]);
        } else if (stringArray2.length == 3) {
            l = Long.decode(stringArray2[1]);
            l2 = Long.decode(stringArray2[2]);
        } else if (stringArray2.length > 3 || stringArray.length > 2) {
            this.out.print("Too many args : ");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                this.out.print(stringArray[i]);
            }
            this.out.println(stringArray[stringArray.length - 1]);
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (stringArray.length == 2 && (n = this.parseSortType(stringArray[1])) == -1) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (Addresses.greaterThan(l, l2)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = WildCard.parseWildcard(string2, stringBuffer);
        if (l3 < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String string3 = stringBuffer.toString();
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateFreedHeaders(l, l2);
        if (J9BuildFlags.env_data64) {
            this.out.println("+------------------------------------------+------------------+-------------------+");
            this.out.println("|          address      |      size        |    org size      | callsite          |");
            this.out.println("+------------------------------------------+------------------+-------------------+");
        } else {
            this.out.println("+--------------------------+----------+-------------------+");
            this.out.println("|      address  |   size   | org size | callsite          |");
            this.out.println("+--------------------------+----------+-------------------+");
        }
        ArrayList<MemTagEntry> arrayList = new ArrayList<MemTagEntry>();
        int n2 = 0;
        int n3 = 0;
        while (j9MemTagIterator.hasNext()) {
            J9MemTagPointer j9MemTagPointer = j9MemTagIterator.next();
            if (!this.regexMatches(j9MemTagPointer, l3, string3)) continue;
            ++n2;
            try {
                long l4 = j9MemTagPointer.allocSize().longValue();
                if (j9MemTagIterator.isFooterCorrupted()) {
                    ++n3;
                    J9MemTagIterator j9MemTagIterator2 = J9MemTagIterator.iterateAllocatedHeaders(j9MemTagPointer.longValue() + J9MemTag.SIZEOF, j9MemTagPointer.add(l4).longValue() + J9MemTag.SIZEOF);
                    if (j9MemTagIterator2.hasNext()) {
                        J9MemTagPointer j9MemTagPointer2 = j9MemTagIterator2.next();
                        l4 = j9MemTagPointer2.longValue() - j9MemTagPointer.longValue();
                    }
                }
                if (1 != n) {
                    arrayList.add(new MemTagEntry(j9MemTagPointer, l4));
                    continue;
                }
                this.printMemTagForFindFreedCallSite(new MemTagEntry(j9MemTagPointer, l4));
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace(this.out);
            }
        }
        if (2 == n || 3 == n) {
            if (2 == n) {
                Collections.sort(arrayList, new NameComparator());
            } else {
                Collections.sort(arrayList, new AllocSizeComparator());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                MemTagEntry memTagEntry = (MemTagEntry)arrayList.get(i);
                this.printMemTagForFindFreedCallSite(memTagEntry);
            }
        }
        this.out.println("Freed call site count = " + n2);
        this.out.println("Corrupted freed call site count = " + n3);
    }

    private void printMemTagForFindFreedCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer j9MemTagPointer = memTagEntry.getHeader();
        long l = memTagEntry.getAllocSize();
        try {
            String string = j9MemTagPointer.callSite().getCStringAtOffset(0L);
            if (J9BuildFlags.env_data64) {
                this.out.append(String.format(" !j9x 0x%s ", this.padWith('0', J9MemTagHelper.j9mem_get_memory_base(j9MemTagPointer).getHexAddress().substring(2), 16)));
                this.out.append(String.format("0x%s ", this.padWith('0', Long.toHexString(l), 16)));
                if (l == j9MemTagPointer.allocSize().longValue()) {
                    this.out.append(String.format("%19s", ""));
                } else {
                    this.out.append(String.format("%s ", j9MemTagPointer.allocSize().getHexValue()));
                }
                this.out.append(String.format("%s", string));
            } else {
                this.out.append(String.format(" !j9x 0x%s ", this.padWith('0', J9MemTagHelper.j9mem_get_memory_base(j9MemTagPointer).getHexAddress().substring(2), 8)));
                this.out.append(String.format("0x%s ", this.padWith('0', Long.toHexString(l), 8)));
                if (l != j9MemTagPointer.allocSize().longValue()) {
                    this.out.append(String.format("%13s", ""));
                } else {
                    this.out.append(String.format("%s ", j9MemTagPointer.allocSize().getHexValue()));
                }
                this.out.append(String.format("%s", string));
            }
            this.out.append('\n');
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(this.out);
        }
    }

    private void printUsageForFindCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindCallsite(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        long l = 0L;
        long l2 = UDATA.MASK;
        int n = 1;
        if (stringArray.length == 0) {
            this.printUsageForFindCallsite();
            return;
        }
        String[] stringArray2 = stringArray[0].split(",");
        String string2 = stringArray2[0];
        if (stringArray.length == 2 && (n = this.parseSortType(stringArray[1])) == -1) {
            this.printUsageForFindCallsite();
            return;
        }
        if (stringArray2.length == 2) {
            l = Long.decode(stringArray2[1]);
        } else if (stringArray2.length == 3) {
            l = Long.decode(stringArray2[1]);
            l2 = Long.decode(stringArray2[2]);
        } else if (stringArray2.length > 3 || stringArray.length > 2) {
            this.out.print("Too many args : ");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                this.out.print(stringArray[i]);
            }
            this.out.println(stringArray[stringArray.length - 1]);
            this.printUsageForFindCallsite();
            return;
        }
        if (Addresses.greaterThan(l, l2)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = WildCard.parseWildcard(string2, stringBuffer);
        if (l3 < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String string3 = stringBuffer.toString();
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateAllocatedHeaders(l, l2);
        ArrayList<MemTagEntry> arrayList = new ArrayList<MemTagEntry>();
        int n2 = 0;
        while (j9MemTagIterator.hasNext()) {
            J9MemTagPointer j9MemTagPointer = j9MemTagIterator.next();
            if (!this.regexMatches(j9MemTagPointer, l3, string3)) continue;
            ++n2;
            try {
                long l4 = j9MemTagPointer.allocSize().longValue();
                if (1 != n) {
                    arrayList.add(new MemTagEntry(j9MemTagPointer, l4));
                    continue;
                }
                this.printMemTagForFindCallSite(new MemTagEntry(j9MemTagPointer, l4));
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace(this.out);
            }
        }
        if (2 == n || 3 == n) {
            if (2 == n) {
                Collections.sort(arrayList, new NameComparator());
            } else {
                Collections.sort(arrayList, new AllocSizeComparator());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                MemTagEntry memTagEntry = (MemTagEntry)arrayList.get(i);
                this.printMemTagForFindCallSite(memTagEntry);
            }
        }
        this.out.println("Call site count = " + n2);
    }

    private void printMemTagForFindCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer j9MemTagPointer = memTagEntry.getHeader();
        try {
            String string = j9MemTagPointer.callSite().getCStringAtOffset(0L);
            this.out.println(String.format(" !j9x %s,%s\t%s", J9MemTagHelper.j9mem_get_memory_base(j9MemTagPointer).getHexAddress(), j9MemTagPointer.allocSize().getHexValue(), string));
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(this.out);
        }
    }

    private void runFindHeader(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        Object object;
        Object object2;
        long l = 0L;
        Object object3 = null;
        if (stringArray.length != 1) {
            this.out.println("Usage: ");
            this.out.println("  !findheader <address> (e.g. !findheader 0xa2b4c6d8)");
            return;
        }
        l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.env_data64);
        this.out.println(String.format("Searching memory allocation header for %s", U8Pointer.cast(l).getHexAddress()));
        long l2 = l - 1024L;
        block8: do {
            object2 = J9MemTagIterator.iterateAllocatedHeaders(l2, l2 + 1024L + 3L);
            while (((J9MemTagIterator)object2).hasNext() && !Addresses.greaterThan(((AbstractPointer)(object = ((J9MemTagIterator)object2).next())).getAddress(), l)) {
                VoidPointer voidPointer;
                VoidPointer voidPointer2 = J9MemTagHelper.j9mem_get_memory_base((J9MemTagPointer)object);
                try {
                    voidPointer = voidPointer2.addOffset(((J9MemTagPointer)object).allocSize().longValue());
                }
                catch (CorruptDataException corruptDataException) {
                    continue;
                }
                if (!Addresses.greaterThanOrEqual(l, voidPointer2.getAddress()) || !Addresses.lessThan(l, voidPointer.getAddress())) continue;
                object3 = object;
                break block8;
            }
            if (Addresses.lessThan(l2, 1024L)) {
                l2 = 0L;
                continue;
            }
            l2 -= 1024L;
        } while (l2 != 0L);
        if (object3 == null) {
            this.out.println("No memory allocation header found");
        } else {
            try {
                object2 = ((J9MemTagPointer)object3).callSite().getCStringAtOffset(0L);
            }
            catch (CorruptDataException corruptDataException) {
                object2 = "<FAULT> reading callsite string: " + corruptDataException.getMessage();
            }
            try {
                object = ((J9MemTagPointer)object3).category().name().getCStringAtOffset(0L);
            }
            catch (CorruptDataException corruptDataException) {
                object = "<FAULT> reading category name string: " + corruptDataException.getMessage();
            }
            try {
                this.out.println(String.format("Found memory allocation header, !j9x %s,0x%#x", J9MemTagHelper.j9mem_get_memory_base((J9MemTagPointer)object3).getHexAddress(), ((J9MemTagPointer)object3).allocSize().longValue()));
                this.out.println(String.format("J9MemTag at %s {", ((AbstractPointer)object3).getHexAddress()));
                this.out.println(String.format("    U_32 eyeCatcher = 0x%x;", ((J9MemTagPointer)object3).eyeCatcher().longValue()));
                this.out.println(String.format("    U_32 sumCheck = 0x%x;", ((J9MemTagPointer)object3).sumCheck().longValue()));
                this.out.println(String.format("    UDATA allocSize = 0x%x;", ((J9MemTagPointer)object3).allocSize().longValue()));
                this.out.println(String.format("    char* callSite = %s;", object2));
                this.out.println(String.format("    struct OMRMemCategory* category = !omrmemcategory 0x%x (%s);", ((J9MemTagPointer)object3).category().longValue(), object));
                this.out.println("}");
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("CDE formatting J9MemTag at " + ((AbstractPointer)object3).getHexAddress());
            }
        }
    }

    private int parseSortType(String string) throws DDRInteractiveCommandException {
        if (string.length() > "sort:".length() && string.substring(0, "sort:".length()).equalsIgnoreCase("sort:")) {
            String string2 = string.substring("sort:".length());
            if (string2.equalsIgnoreCase("name")) {
                return 2;
            }
            if (string2.equalsIgnoreCase("allocsize")) {
                return 3;
            }
            throw new DDRInteractiveCommandException("Error: Unknown sort type: " + string);
        }
        throw new DDRInteractiveCommandException("Error: Unknown argument: " + string);
    }

    private void runPrintAllCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all memory block callsites...");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "*";
        if (stringArray.length == 1) {
            stringArray2[1] = stringArray[0];
        }
        this.runFindCallsite("!findcallsite", stringArray2, context);
    }

    private void runPrintAllFreedCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "*";
        if (stringArray.length == 1) {
            stringArray2[1] = stringArray[0];
        }
        this.runFindFreedCallsite("!findfreedcallsite", stringArray2, context);
    }

    private void runFindAllCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        int n = 3;
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateAllocatedHeaders();
        if (stringArray.length == 1) {
            n = this.parseSortType(stringArray[0]);
        }
        this.printCallsitesTable(this.buildCallsitesTable(j9MemTagIterator, true), n);
    }

    private void runFindAllFreedCallsites(String string, String[] stringArray, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        int n = 3;
        J9MemTagIterator j9MemTagIterator = J9MemTagIterator.iterateFreedHeaders();
        if (stringArray.length == 1) {
            n = this.parseSortType(stringArray[0]);
        }
        this.printCallsitesTable(this.buildCallsitesTable(j9MemTagIterator, true), n);
    }

    public String padWith(char c, String string, int n) {
        String string2 = "";
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            string2 = string2 + c;
        }
        return string2 + string;
    }

    private Map<String, J9DbgExtMemStats> buildCallsitesTable(J9MemTagIterator j9MemTagIterator, boolean bl) {
        TreeMap<String, J9DbgExtMemStats> treeMap = new TreeMap<String, J9DbgExtMemStats>();
        while (j9MemTagIterator.hasNext()) {
            J9MemTagPointer j9MemTagPointer = j9MemTagIterator.next();
            try {
                Object object;
                long l = j9MemTagPointer.allocSize().longValue();
                if (bl && j9MemTagIterator.isFooterCorrupted() && ((J9MemTagIterator)(object = J9MemTagIterator.iterateAllocatedHeaders(j9MemTagPointer.longValue() + J9MemTag.SIZEOF, j9MemTagPointer.add(l).longValue() + J9MemTag.SIZEOF))).hasNext()) {
                    J9MemTagPointer j9MemTagPointer2 = ((J9MemTagIterator)object).next();
                    l = j9MemTagPointer2.longValue() - j9MemTagPointer.longValue();
                }
                String string = j9MemTagPointer.callSite().getCStringAtOffset(0L);
                j9MemTagIterator.moveCurrentSearchAddress(l);
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, new J9DbgExtMemStats(j9MemTagPointer.allocSize().longValue()));
                    continue;
                }
                object = (J9DbgExtMemStats)treeMap.get(string);
                ((J9DbgExtMemStats)object).incrementTotalBlocksAllocated();
                ((J9DbgExtMemStats)object).addTotalBytesAllocated(j9MemTagPointer.allocSize().longValue());
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("Unexpected CDE reading contents of " + Long.toHexString(j9MemTagPointer.getAddress()));
                corruptDataException.printStackTrace(this.out);
            }
        }
        return treeMap;
    }

    @Override
    public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
        if (corruptDataException instanceof J9MemTagHelper.J9MemTagCheckError) {
            J9MemTagHelper.J9MemTagCheckError j9MemTagCheckError = (J9MemTagHelper.J9MemTagCheckError)corruptDataException;
            this.out.println("J9MemTag check failed at " + Long.toHexString(j9MemTagCheckError.getAddress()) + ": " + string + " :" + corruptDataException.getMessage());
        } else {
            corruptDataException.printStackTrace(this.out);
        }
    }

    private void printCallsitesTable(Map<String, J9DbgExtMemStats> map, final int n) throws DDRInteractiveCommandException {
        this.out.println(" total alloc   | largest");
        this.out.println(" blocks| bytes | bytes | callsite");
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
        if (2 == n || 3 == n) {
            LinkedList<Map.Entry<String, J9DbgExtMemStats>> linkedList = new LinkedList<Map.Entry<String, J9DbgExtMemStats>>(map.entrySet());
            Collections.sort(linkedList, new Comparator<Map.Entry<String, J9DbgExtMemStats>>(){

                @Override
                public int compare(Map.Entry<String, J9DbgExtMemStats> entry, Map.Entry<String, J9DbgExtMemStats> entry2) {
                    if (2 == n) {
                        return entry.getKey().compareTo(entry2.getKey());
                    }
                    if (entry.getValue().getTotalBytesAllocated() < entry2.getValue().getTotalBytesAllocated()) {
                        return 1;
                    }
                    if (entry.getValue().getTotalBytesAllocated() == entry2.getValue().getTotalBytesAllocated()) {
                        return 0;
                    }
                    return -1;
                }
            });
            for (int i = 0; i < linkedList.size(); ++i) {
                Map.Entry entry = (Map.Entry)linkedList.get(i);
                String string = (String)entry.getKey();
                J9DbgExtMemStats j9DbgExtMemStats = (J9DbgExtMemStats)entry.getValue();
                this.out.println(String.format("%7d %7d %7d %s", j9DbgExtMemStats.getTotalBlocksAllocated(), j9DbgExtMemStats.getTotalBytesAllocated(), j9DbgExtMemStats.getLargestBlockAllocated(), string));
            }
        } else if (1 == n) {
            for (Map.Entry<String, J9DbgExtMemStats> entry : map.entrySet()) {
                String string = entry.getKey();
                J9DbgExtMemStats j9DbgExtMemStats = entry.getValue();
                this.out.println(String.format("%7d %7d %7d %s", j9DbgExtMemStats.getTotalBlocksAllocated(), j9DbgExtMemStats.getTotalBytesAllocated(), j9DbgExtMemStats.getLargestBlockAllocated(), string));
            }
        } else {
            throw new DDRInteractiveCommandException("Unknown sort type: " + n);
        }
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
    }

    private boolean regexMatches(J9MemTagPointer j9MemTagPointer, long l, String string) {
        String string2;
        try {
            string2 = j9MemTagPointer.callSite().getCStringAtOffset(0L);
        }
        catch (CorruptDataException corruptDataException) {
            return false;
        }
        return WildCard.wildcardMatch(l, string, string2);
    }

    private class AllocSizeComparator
    implements Comparator<MemTagEntry> {
        private AllocSizeComparator() {
        }

        @Override
        public int compare(MemTagEntry memTagEntry, MemTagEntry memTagEntry2) {
            if (memTagEntry.getAllocSize() < memTagEntry2.getAllocSize()) {
                return 1;
            }
            if (memTagEntry.getAllocSize() == memTagEntry2.getAllocSize()) {
                return 0;
            }
            return -1;
        }
    }

    private class NameComparator
    implements Comparator<MemTagEntry> {
        private NameComparator() {
        }

        @Override
        public int compare(MemTagEntry memTagEntry, MemTagEntry memTagEntry2) {
            String string = null;
            String string2 = null;
            try {
                string = memTagEntry.getHeader().callSite().getCStringAtOffset(0L);
                string2 = memTagEntry2.getHeader().callSite().getCStringAtOffset(0L);
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace();
            }
            return string.compareTo(string2);
        }
    }

    private class MemTagEntry {
        private J9MemTagPointer header;
        private long allocSize;

        public MemTagEntry(J9MemTagPointer j9MemTagPointer, long l) {
            this.header = j9MemTagPointer;
            this.allocSize = l;
        }

        public J9MemTagPointer getHeader() {
            return this.header;
        }

        public long getAllocSize() {
            return this.allocSize;
        }
    }

    static class J9DbgExtMemStats {
        private long totalBlocksAllocated;
        private long totalBytesAllocated;
        private long largestBlockAllocated;

        public J9DbgExtMemStats(long l) {
            this.totalBytesAllocated = l;
            this.totalBlocksAllocated = 1L;
            this.largestBlockAllocated = l;
        }

        public void incrementTotalBlocksAllocated() {
            ++this.totalBlocksAllocated;
        }

        public void addTotalBytesAllocated(long l) {
            this.totalBytesAllocated += l;
            if (l > this.largestBlockAllocated) {
                this.largestBlockAllocated = l;
            }
        }

        public long getTotalBlocksAllocated() {
            return this.totalBlocksAllocated;
        }

        public long getTotalBytesAllocated() {
            return this.totalBytesAllocated;
        }

        public long getLargestBlockAllocated() {
            return this.largestBlockAllocated;
        }
    }
}

