/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMThreads
extends Check {
    CheckVMThreads() {
    }

    @Override
    public void check() {
        try {
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                GCVMThreadIterator gCVMThreadIterator = GCVMThreadIterator.fromJ9VMThread(j9VMThreadPointer);
                while (gCVMThreadIterator.hasNext()) {
                    PointerPointer pointerPointer = PointerPointer.cast(gCVMThreadIterator.nextAddress());
                    if (this._engine.checkSlotVMThread(pointerPointer, VoidPointer.cast(j9VMThreadPointer), 0, gCVMThreadIterator.getState()) == 0) continue;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "VM THREAD SLOTS";
    }

    @Override
    public void print() {
        try {
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            ScanFormatter scanFormatter = new ScanFormatter(this, "VMThread Slots");
            while (gCVMThreadListIterator.hasNext()) {
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                scanFormatter.section("thread", j9VMThreadPointer);
                GCVMThreadIterator gCVMThreadIterator = GCVMThreadIterator.fromJ9VMThread(j9VMThreadPointer);
                while (gCVMThreadIterator.hasNext()) {
                    scanFormatter.entry(gCVMThreadIterator.next());
                }
                scanFormatter.endSection();
            }
            scanFormatter.end("VMThread Slots");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

